/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.web.jsf.crviewer.jsps;

import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.web.jsf.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseActionHandler;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.DisplayHelpContextAction;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.FacesViewerLibraryIDEAdaptor;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.ImportFileChangeListener;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.InsertViewerUtils;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.TagLibraryUtils;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.wizards.datatransfer.FileSystemImportWizard;

public class InsertLocalBeanWizardPage
extends WizardPage
implements Listener,
ModifyListener {
    private FacesViewerLibraryIDEAdaptor m_adaptor;
    private boolean m_filePathValidated;
    private String m_filePathValue;
    private Text m_filePathTextBox;
    private String m_filePathValueToInsert;

    public InsertLocalBeanWizardPage(String string) {
        super(string);
        this.setTitle(NLSResourceManager.page1_title);
        this.setDescription(NLSResourceManager.page1_message);
        this.m_adaptor = new FacesViewerLibraryIDEAdaptor();
    }

    protected String getFileName() {
        return this.m_filePathValueToInsert;
    }

    public void performHelp() {
        Display.getDefault().asyncExec((Runnable)new DisplayHelpContextAction());
    }

    protected boolean isOKtoEndPage1() {
        if (this.m_filePathValue == null) {
            return false;
        }
        if (this.m_filePathValidated) {
            return true;
        }
        FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor = new FacesViewerLibraryIDEAdaptor();
        if (!TagLibraryUtils.checkAndPromptJRCLibraryInstall(facesViewerLibraryIDEAdaptor)) {
            return false;
        }
        try {
            File file = new File(this.m_filePathValue);
            String string = InsertViewerUtils.getNewReportLocation(file, facesViewerLibraryIDEAdaptor);
            if (string != null) {
                this.m_filePathValueToInsert = string;
                this.m_filePathValidated = true;
                return true;
            }
        }
        catch (ReportLocationException reportLocationException) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)((Object)reportLocationException));
        }
        return false;
    }

    public void createControl(final Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)composite2, "com.businessobjects.integration.rad.jsf.crviewer.docroot");
        }
        composite2.setSize(548, 315);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(770);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)new GridData(2));
        Label label = new Label(composite3, 0);
        label.setText(NLSResourceManager.bean_new_wizard_filename_label);
        this.m_filePathTextBox = new Text(composite3, 2048);
        GridData gridData2 = new GridData(512);
        gridData2.widthHint = 175;
        gridData2.horizontalSpan = 1;
        this.m_filePathTextBox.setLayoutData((Object)gridData2);
        this.m_filePathTextBox.addModifyListener((ModifyListener)this);
        Button button = new Button(composite3, 0);
        GridData gridData3 = new GridData(128);
        gridData3.widthHint = 125;
        button.setLayoutData((Object)gridData3);
        button.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BROWSE));
        button.setToolTipText(NLSResourceManager.page1_browse_button_tooltip);
        button.addSelectionListener((SelectionListener)new BrowseActionHandler(this.m_filePathTextBox));
        new Label(composite3, 0);
        new Label(composite3, 0);
        Button button2 = new Button(composite3, 0);
        GridData gridData4 = new GridData(128);
        gridData4.widthHint = 125;
        button2.setLayoutData((Object)gridData4);
        button2.setText(NLSResourceManager.viewer_import_button_text);
        button2.setToolTipText(NLSResourceManager.viewer_import_button_tooltip);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileSystemImportWizard fileSystemImportWizard = new FileSystemImportWizard();
                fileSystemImportWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(new Object[0]));
                WizardDialog wizardDialog = new WizardDialog(composite.getShell(), (IWizard)fileSystemImportWizard);
                ImportFileChangeListener importFileChangeListener = new ImportFileChangeListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)importFileChangeListener);
                wizardDialog.open();
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)importFileChangeListener);
                if (importFileChangeListener.getLastFileAdded() != null) {
                    InsertLocalBeanWizardPage.this.m_filePathTextBox.setText(importFileChangeListener.getLastFileAdded());
                    InsertLocalBeanWizardPage.this.validate();
                }
            }
        });
        composite2.pack();
        this.setControl((Control)composite2);
        this.setPageComplete(false);
    }

    public void handleEvent(Event event) {
        this.getWizard().getContainer().updateButtons();
    }

    private void setPageValidationErrorMessage(String string) {
        if (string == null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(string);
            this.setPageComplete(false);
        }
    }

    private void validate() {
        String string = this.m_filePathTextBox.getText();
        try {
            IFile iFile;
            if (string.trim().length() == 0) {
                this.setPageValidationErrorMessage(NLSResourceManager.err_new_report_wizard_filename_not_entered);
                return;
            }
            if (string.indexOf("*") != -1) {
                this.setPageValidationErrorMessage(NLS.bind((String)NLSResourceManager.err_new_report_wizard_filename_invalid, (Object)"*"));
                return;
            }
            if (string.indexOf("|") != -1) {
                this.setPageValidationErrorMessage(NLS.bind((String)NLSResourceManager.err_new_report_wizard_filename_invalid, (Object)"|"));
                return;
            }
            if (string.indexOf(">") != -1) {
                this.setPageValidationErrorMessage(NLS.bind((String)NLSResourceManager.err_new_report_wizard_filename_invalid, (Object)">"));
                return;
            }
            if (string.indexOf("<") != -1) {
                this.setPageValidationErrorMessage(NLS.bind((String)NLSResourceManager.err_new_report_wizard_filename_invalid, (Object)"<"));
                return;
            }
            if (string.indexOf(":") != -1) {
                this.setPageValidationErrorMessage(NLS.bind((String)NLSResourceManager.err_new_report_wizard_filename_invalid, (Object)":"));
                return;
            }
            if (string.indexOf("\"") != -1) {
                this.setPageValidationErrorMessage(NLS.bind((String)NLSResourceManager.err_new_report_wizard_filename_invalid, (Object)"\""));
                return;
            }
            Path path = new Path(string);
            if (!path.isAbsolute()) {
                iFile = this.m_adaptor.getActiveFile().getParent().getFile((IPath)path);
                if (iFile == null) {
                    this.setPageValidationErrorMessage(NLS.bind((String)NLSResourceManager.err_insert_viewer_wizard_file_not_exist, (Object)string));
                    return;
                }
                path = iFile.getFullPath().makeAbsolute();
            }
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            File file = iFile.getLocation().toFile();
            if (iFile == null || !file.exists()) {
                this.setPageValidationErrorMessage(NLS.bind((String)NLSResourceManager.err_insert_viewer_wizard_file_not_exist, (Object)string));
                return;
            }
            if (!file.isFile() || !file.getName().endsWith(".rpt")) {
                this.setPageValidationErrorMessage(NLSResourceManager.browse_report_error_not_report);
                return;
            }
            this.m_filePathValue = iFile.getLocation().toOSString();
            this.setPageValidationErrorMessage(null);
        }
        catch (Exception exception) {
            this.setPageValidationErrorMessage(NLS.bind((String)NLSResourceManager.err_insert_viewer_wizard_file_not_exist, (Object)string));
            return;
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.m_filePathValidated = false;
        this.validate();
    }
}

