/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.web.jsf.crviewer.internal;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.eclipse.web.properties.PropertiesPlugin;
import com.businessobjects.integration.rad.web.jsf.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.FacesViewerLibraryIDEAdaptor;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;

public class TagLibraryUtils {
    private static final String ENTERPRISE_FACET_ID = "com.businessobjects.integration.eclipse.enterprise.facet";
    public static final String JRC_FACET_ID = "com.businessobjects.sdks.jrc";

    private TagLibraryUtils() {
    }

    public static String getPrefixForUri(IDOMDocument iDOMDocument, String string) {
        TaglibPrefixUtil taglibPrefixUtil = TaglibPrefixUtil.getMapperUtil((Document)iDOMDocument);
        return taglibPrefixUtil.getPrefixForUri(string);
    }

    public static boolean checkAndPromptEnterpriseLibraryInstall(FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor) {
        IProject iProject = facesViewerLibraryIDEAdaptor.getProject();
        try {
            String string;
            IFacetedProject iFacetedProject = ProjectFacetsManager.create((IProject)iProject);
            for (IProjectFacetVersion iProjectFacetVersion : iFacetedProject.getProjectFacets()) {
                string = iProjectFacetVersion.getProjectFacet().getId();
                if (ENTERPRISE_FACET_ID.equals(string)) {
                    return true;
                }
                if (!JRC_FACET_ID.equals(string)) continue;
                UIUtilities.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.err_jrc_facet_installed_title, (String)NLSResourceManager.err_jrc_facet_installed_message);
                    }
                });
                return false;
            }
            boolean bl = MessageDialog.openConfirm((Shell)UIUtilities.getShell(), (String)NLSResourceManager.enterprise_taglib_need_import_title, (String)NLSResourceManager.enterprise_taglib_need_import_message);
            if (!bl) {
                return false;
            }
            string = ProjectFacetsManager.getProjectFacet((String)ENTERPRISE_FACET_ID);
            if (string != null) {
                String string2 = PropertiesPlugin.getDefaultVersion();
                IProjectFacetVersion iProjectFacetVersion = string.getVersion(string2);
                if (iProjectFacetVersion != null) {
                    IDataModel iDataModel = (IDataModel)iProjectFacetVersion.createActionConfig(IFacetedProject.Action.Type.VERSION_CHANGE, iProject.getName());
                    iDataModel.setStringProperty("IFacetDataModelProperties.FACET_ID", string.getId());
                    iDataModel.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", string2);
                    iDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)iProjectFacetVersion);
                    iFacetedProject.installProjectFacet(iProjectFacetVersion, (Object)iDataModel, null);
                } else {
                    MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.version_not_valid_title, (String)NLSResourceManager.version_not_valid_message);
                }
            }
        }
        catch (CoreException coreException) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)((Object)coreException));
            return false;
        }
        return true;
    }

    public static boolean checkAndPromptJRCLibraryInstall(FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor) {
        block8: {
            IProject iProject = facesViewerLibraryIDEAdaptor.getProject();
            try {
                String string;
                IFacetedProject iFacetedProject = ProjectFacetsManager.create((IProject)iProject);
                for (IProjectFacetVersion iProjectFacetVersion : iFacetedProject.getProjectFacets()) {
                    string = iProjectFacetVersion.getProjectFacet().getId();
                    if (JRC_FACET_ID.equals(string)) {
                        return true;
                    }
                    if (!ENTERPRISE_FACET_ID.equals(string)) continue;
                    UIUtilities.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.err_enterprise_facet_installed_title, (String)NLSResourceManager.err_enterprise_facet_installed_message);
                        }
                    });
                    return false;
                }
                boolean bl = MessageDialog.openConfirm((Shell)UIUtilities.getShell(), (String)NLSResourceManager.taglib_need_import_title, (String)NLSResourceManager.taglib_need_import_jrc_message);
                if (!bl) {
                    return false;
                }
                string = ProjectFacetsManager.getProjectFacet((String)JRC_FACET_ID);
                if (string == null) break block8;
                String string2 = PropertiesPlugin.getDefaultVersion();
                IProjectFacetVersion iProjectFacetVersion = null;
                try {
                    iProjectFacetVersion = string.getVersion(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LogManager.getInstance().message(100, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)illegalArgumentException);
                }
                if (iProjectFacetVersion != null) {
                    IDataModel iDataModel = (IDataModel)iProjectFacetVersion.createActionConfig(IFacetedProject.Action.Type.VERSION_CHANGE, iProject.getName());
                    iDataModel.setStringProperty("IFacetDataModelProperties.FACET_ID", string.getId());
                    iDataModel.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", string2);
                    iDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)iProjectFacetVersion);
                    iFacetedProject.installProjectFacet(iProjectFacetVersion, (Object)iDataModel, null);
                    break block8;
                }
                MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.version_not_valid_title, (String)NLSResourceManager.version_not_valid_message);
                return false;
            }
            catch (CoreException coreException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)((Object)coreException));
                return false;
            }
        }
        return true;
    }
}

