/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.web.jsf.crviewer.internal;

import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseTreeContentProvider;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseTreeLabelProvider;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.InsertViewerUtils;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class ReportNotInSpecifiedLocationDialog
extends Dialog
implements ISelectionChangedListener {
    private boolean m_isMove;
    private boolean m_isReadOnly;
    private String m_newLocation = "/";
    private File m_reportLocation;
    private Text m_locationBar;

    protected ReportNotInSpecifiedLocationDialog(Shell shell, File file, boolean bl) {
        super(shell);
        this.m_reportLocation = file;
        this.m_isReadOnly = bl;
    }

    public boolean isMove() {
        return this.m_isMove;
    }

    public String getNewLocation() {
        return this.m_newLocation;
    }

    protected Point getInitialSize() {
        return new Point(450, 400);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.REPORT_LOCATION_DIALOG_TITLE));
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout());
        StyledText styledText = new StyledText(composite2, 72);
        styledText.setBackground(Display.getCurrent().getSystemColor(22));
        styledText.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.REPORT_LOCATION_DIALOG_TEXT));
        GridData gridData = new GridData(768);
        gridData.widthHint = 430;
        styledText.setLayoutData((Object)gridData);
        styledText.setEnabled(false);
        TreeViewer treeViewer = new TreeViewer(composite2);
        treeViewer.setContentProvider((IContentProvider)new BrowseTreeContentProvider(this.m_reportLocation, true));
        treeViewer.setLabelProvider((IBaseLabelProvider)new BrowseTreeLabelProvider());
        treeViewer.setInput((Object)this.m_reportLocation);
        treeViewer.expandToLevel((Object)this.m_reportLocation, 1);
        Tree tree = treeViewer.getTree();
        GridData gridData2 = new GridData(1808);
        gridData2.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData2);
        this.m_locationBar = new Text(composite2, 0);
        GridData gridData3 = new GridData(768);
        this.m_locationBar.setLayoutData((Object)gridData3);
        this.m_locationBar.setEditable(false);
        if (this.m_reportLocation != null) {
            this.m_locationBar.setText(this.m_newLocation);
        }
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Button button = new Button(composite2, 32);
        button.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.REPORT_LOCATION_DIALOG_MOVE));
        button.setEnabled(!this.m_isReadOnly);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ReportNotInSpecifiedLocationDialog.this.m_isMove = !ReportNotInSpecifiedLocationDialog.this.m_isMove;
            }
        });
        return composite2;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        if (iStructuredSelection == null) {
            this.m_locationBar.setText(this.m_reportLocation.getName());
        } else {
            File file = (File)iStructuredSelection.getFirstElement();
            if (file != null) {
                if (file.equals(this.m_reportLocation)) {
                    this.m_newLocation = "/";
                } else {
                    try {
                        String string = file.getCanonicalPath();
                        String string2 = this.m_reportLocation.getCanonicalPath();
                        if (string.startsWith(string2 + File.separator)) {
                            this.m_newLocation = InsertViewerUtils.getRelativePath(string, string2);
                        }
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
                this.m_locationBar.setText(this.m_newLocation);
            }
        }
    }
}

