/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.web.jsf.crviewer.internal;

import com.businessobjects.integration.capabilities.librarycomponents.ILibraryComponentIDEAdaptor;
import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.web.jsf.crviewer.NLSResourceManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportLocationUtils {
    public static boolean isReportInConfigLocation(File file, ILibraryComponentIDEAdaptor iLibraryComponentIDEAdaptor) throws ReportLocationException {
        try {
            String string;
            boolean bl = false;
            String string2 = ReportLocationUtils.getReportDirectoryCanonicalPath(iLibraryComponentIDEAdaptor);
            if (string2 != null && file != null && (string = file.getCanonicalPath()) != null && string.startsWith(string2 + File.separator)) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            String string = NLSResourceManager.err_report_location_comparison;
            throw new ReportLocationException(string, (Throwable)exception);
        }
    }

    public static String getReportDirectoryCanonicalPath(ILibraryComponentIDEAdaptor iLibraryComponentIDEAdaptor) throws ReportLocationException {
        try {
            String string = ReportLocationUtils.getReportLocation(iLibraryComponentIDEAdaptor);
            File file = iLibraryComponentIDEAdaptor.getWebInfLocation();
            File file2 = new File(new File(file, "lib"), string);
            String string2 = file2.getCanonicalPath();
            return string2;
        }
        catch (Exception exception) {
            String string = NLSResourceManager.report_location_retrieval_error;
            throw new ReportLocationException(string, (Throwable)exception);
        }
    }

    private static String getReportLocation(ILibraryComponentIDEAdaptor iLibraryComponentIDEAdaptor) throws ParserConfigurationException, IOException, SAXException {
        File file = ReportLocationUtils.getEngineConfigurationFile(iLibraryComponentIDEAdaptor);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        NodeList nodeList = document.getElementsByTagName("reportlocation");
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        String string = nodeList2.item(0).getNodeValue();
        string = string.trim();
        return string;
    }

    private static File getEngineConfigurationFile(ILibraryComponentIDEAdaptor iLibraryComponentIDEAdaptor) {
        File file = iLibraryComponentIDEAdaptor.getWebInfClassesLocation();
        File file2 = new File(file, "CRConfig.xml");
        return file2;
    }

    public static String copyReportFile(String string, String string2, boolean bl, ILibraryComponentIDEAdaptor iLibraryComponentIDEAdaptor) throws ReportLocationException {
        return ReportLocationUtils.copyReportFile(string, string2, bl, iLibraryComponentIDEAdaptor, false);
    }

    public static String copyReportFile(String string, String string2, boolean bl, ILibraryComponentIDEAdaptor iLibraryComponentIDEAdaptor, boolean bl2) throws ReportLocationException {
        return ReportLocationUtils.copyReportFile(string, string2, new File(string).getName(), bl, iLibraryComponentIDEAdaptor, bl2);
    }

    public static String copyReportFile(String string, String string2, String string3, boolean bl, ILibraryComponentIDEAdaptor iLibraryComponentIDEAdaptor, boolean bl2) throws ReportLocationException {
        File file = new File(string);
        String string4 = ReportLocationUtils.getReportDirectoryCanonicalPath(iLibraryComponentIDEAdaptor);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        if (!string2.endsWith("/") && !string2.endsWith(File.separator)) {
            stringBuffer.append("/");
        }
        stringBuffer.append(string3);
        File file2 = new File(string4, stringBuffer.toString());
        ReportLocationUtils.copyFileObject(file, file2, bl2);
        if (bl) {
            file.delete();
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileObject(File file, File file2, boolean bl) {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            if (file.exists()) {
                if (file2.exists()) {
                    if (bl) {
                        file2.delete();
                    } else {
                        return;
                    }
                }
                if (file.isDirectory()) {
                    file2.mkdir();
                    File[] fileArray = file.listFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file3 = new File(file2.getAbsolutePath() + File.separator + fileArray[i].getName());
                        ReportLocationUtils.copyFileObject(fileArray[i], file3, bl);
                    }
                } else {
                    file2.createNewFile();
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    byte[] byArray = new byte[2048];
                    int n = 0;
                    while ((n = bufferedInputStream.read(byArray)) != -1) {
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                    }
                }
            }
        }
        catch (IOException iOException) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)iOException);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

