/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.web.jsf.crviewer.internal;

import com.businessobjects.integration.capabilities.librarycomponents.ILibraryComponentIDEAdaptor;
import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.web.jsf.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseDialog;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseReportFileValidator;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseTreeContentProvider;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseTreeLabelProvider;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.FacesViewerLibraryIDEAdaptor;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.InsertViewerUtils;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.ReportLocationUtils;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class PropertyReportBrowseActionHandler
extends SelectionAdapter {
    private Text m_filePathTextField;

    public PropertyReportBrowseActionHandler(Text text) {
        this.m_filePathTextField = text;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object = selectionEvent.getSource();
        if (object instanceof Button) {
            Button button = (Button)object;
            FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor = new FacesViewerLibraryIDEAdaptor();
            try {
                String string = ReportLocationUtils.getReportDirectoryCanonicalPath((ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor);
                BrowseDialog browseDialog = new BrowseDialog(button.getShell(), (ILabelProvider)new BrowseTreeLabelProvider(), new BrowseTreeContentProvider(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), false));
                browseDialog.setInput(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
                File file = new File(string + File.separator + this.m_filePathTextField.getText());
                if (!file.exists() && !(file = new File(string)).exists()) {
                    file.mkdirs();
                }
                browseDialog.setInitialSelection(file);
                browseDialog.setTitle(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BROWSE));
                browseDialog.setMessage(NLSResourceManager.page1_browse_button_tooltip);
                browseDialog.setValidator(new BrowseReportFileValidator());
                browseDialog.setBlockOnOpen(true);
                browseDialog.setAllowMultiple(false);
                browseDialog.open();
                if (browseDialog.getResult() != null) {
                    File file2;
                    String string2;
                    String string3 = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(browseDialog.getResult()[0] + "")).getLocation().toOSString();
                    if (this.m_filePathTextField != null && string3 != null && (string2 = InsertViewerUtils.getNewReportLocation(file2 = new File(string3), facesViewerLibraryIDEAdaptor)) != null) {
                        this.m_filePathTextField.setText(string2);
                    }
                }
            }
            catch (ReportLocationException reportLocationException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)((Object)reportLocationException));
            }
        }
    }
}

