/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.web.jsf.crviewer.internal;

import com.businessobjects.integration.capabilities.librarycomponents.ILibraryComponentIDEAdaptor;
import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.capabilities.librarycomponents.jsf.crystalreports.JSFPageViewer;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.web.jsf.crviewer.Activator;
import com.businessobjects.integration.rad.web.jsf.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.FacesViewerLibraryIDEAdaptor;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.MoveReportDialogUserResponse;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.ReportLocationUtils;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.ReportNotInSpecifiedLocationDialog;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.TagLibraryUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertViewerUtils {
    private static final int UNIQUE_NAME_START_COUNTER = 2;
    private static final String HTML = "HTML";
    private static final String DTD_PUBLIC_ID = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private static final String DTD_SYSTEM_ID = null;

    private InsertViewerUtils() {
    }

    public static void setDocType(IDOMDocument iDOMDocument) {
        DocumentType documentType = iDOMDocument.getDoctype();
        if (documentType != null) {
            InsertViewerUtils.updateDoctype(documentType);
        } else {
            DocumentType documentType2 = InsertViewerUtils.createDoctype((Document)iDOMDocument);
            if (documentType2 != null) {
                InsertViewerUtils.insertDoctype(documentType2, (Document)iDOMDocument);
            }
        }
    }

    private static void updateDoctype(DocumentType documentType) {
        if (documentType instanceof IDOMDocumentType) {
            IDOMDocumentType iDOMDocumentType = (IDOMDocumentType)documentType;
            if (iDOMDocumentType != null && HTML.equals(iDOMDocumentType.getName())) {
                ILog iLog;
                if (!DTD_PUBLIC_ID.equals(iDOMDocumentType.getPublicId())) {
                    try {
                        iDOMDocumentType.setPublicId(DTD_PUBLIC_ID);
                    }
                    catch (DOMException dOMException) {
                        iLog = Activator.getDefault().getLog();
                        iLog.log((IStatus)new Status(2, "com.businessobjects.integration.rad.jsf.crviewer", 2, "Cannot set DTD declaration to -//W3C//DTD HTML 4.01 Transitional//EN", null));
                    }
                }
                if (iDOMDocumentType.getSystemId() != null) {
                    try {
                        iDOMDocumentType.setSystemId(DTD_SYSTEM_ID);
                    }
                    catch (DOMException dOMException) {
                        iLog = Activator.getDefault().getLog();
                        iLog.log((IStatus)new Status(2, "com.businessobjects.integration.rad.jsf.crviewer", 2, "Cannot set DTD declaration to -//W3C//DTD HTML 4.01 Transitional//EN", null));
                    }
                }
            } else {
                Document document = documentType.getOwnerDocument();
                if (document != null) {
                    DocumentType documentType2 = InsertViewerUtils.createDoctype(document);
                    document.insertBefore(documentType2, documentType);
                    document.removeChild(documentType);
                }
            }
        }
    }

    private static DocumentType createDoctype(Document document) {
        IDOMDocumentType iDOMDocumentType = null;
        if (document instanceof DocumentImpl) {
            IDOMDocument iDOMDocument = (IDOMDocument)document;
            IDOMDocumentType iDOMDocumentType2 = (IDOMDocumentType)iDOMDocument.createDoctype(HTML);
            iDOMDocumentType2.setPublicId(DTD_PUBLIC_ID);
            iDOMDocumentType2.setSystemId(DTD_SYSTEM_ID);
            iDOMDocumentType = iDOMDocumentType2;
        }
        return iDOMDocumentType;
    }

    private static void insertDoctype(DocumentType documentType, Document document) {
        Node node = null;
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 7 || node2.getNodeType() == 8) continue;
            node = node2;
            break;
        }
        document.insertBefore(documentType, node);
    }

    public static String getRelativePath(String string, String string2) {
        if (string.startsWith(string2 + File.separator)) {
            return string.substring(string2.length()).replace(File.separatorChar, '/');
        }
        return string;
    }

    private static String relocateReport(File file, FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor, MoveReportDialogUserResponse moveReportDialogUserResponse, String string) throws ReportLocationException {
        File file2 = new File(ReportLocationUtils.getReportDirectoryCanonicalPath((ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor) + "/" + moveReportDialogUserResponse.getNewLocation(), string);
        if (file2.exists()) {
            boolean bl = !InsertViewerUtils.isFileReadOnly(file2);
            String[] stringArray = bl ? new String[]{NLSResourceManager.warning_report_exists_in_new_location_overwrite, NLSResourceManager.warning_report_exists_in_new_location_Rename, NLSResourceManager.warning_report_exists_in_new_location_cancel} : new String[]{NLSResourceManager.warning_report_exists_in_new_location_Rename, NLSResourceManager.warning_report_exists_in_new_location_cancel};
            MessageDialog messageDialog = new MessageDialog(UIUtilities.getShell(), NLSResourceManager.warning_report_exists_in_new_location_title, null, NLSResourceManager.warning_report_exists_in_new_location_message, 4, stringArray, 0);
            int n = messageDialog.open();
            if (n == 0 && bl) {
                return InsertViewerUtils.copyReportToSpecifiedLocation(file, string, facesViewerLibraryIDEAdaptor, moveReportDialogUserResponse);
            }
            if (n == 0 && !bl || n == 1 && bl) {
                InputDialog inputDialog = new InputDialog(UIUtilities.getShell(), NLSResourceManager.warning_report_exists_in_new_location_title, NLSResourceManager.warning_report_exists_in_new_location_message, file.getName(), null);
                if (inputDialog.open() == 0) {
                    String string2 = inputDialog.getValue();
                    return InsertViewerUtils.relocateReport(file, facesViewerLibraryIDEAdaptor, moveReportDialogUserResponse, string2);
                }
                return null;
            }
            return null;
        }
        return InsertViewerUtils.copyReportToSpecifiedLocation(file, string, facesViewerLibraryIDEAdaptor, moveReportDialogUserResponse);
    }

    public static String getNewReportLocation(File file, FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor) throws ReportLocationException {
        InsertViewerUtils.ensureReportDirectoryExists(facesViewerLibraryIDEAdaptor);
        if (!ReportLocationUtils.isReportInConfigLocation(file, (ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor)) {
            MoveReportDialogUserResponse moveReportDialogUserResponse = InsertViewerUtils.askAboutMovingReport(file, facesViewerLibraryIDEAdaptor);
            if (moveReportDialogUserResponse.isConfirmed()) {
                return InsertViewerUtils.relocateReport(file, facesViewerLibraryIDEAdaptor, moveReportDialogUserResponse, file.getName());
            }
            return null;
        }
        try {
            return InsertViewerUtils.getRelativePath(file.getCanonicalPath(), ReportLocationUtils.getReportDirectoryCanonicalPath((ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor));
        }
        catch (IOException iOException) {
            throw new ReportLocationException(iOException.getLocalizedMessage());
        }
    }

    private static void ensureReportDirectoryExists(FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor) throws ReportLocationException {
        String string = ReportLocationUtils.getReportDirectoryCanonicalPath((ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor);
        File file = new File(string);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new ReportLocationException(NLSResourceManager.report_location_retrieval_error);
            }
            IContainer iContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(string));
            try {
                if (iContainer != null) {
                    iContainer.refreshLocal(1, null);
                }
            }
            catch (CoreException coreException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)((Object)coreException));
            }
        } else if (!file.isDirectory()) {
            throw new ReportLocationException(NLSResourceManager.report_location_retrieval_error);
        }
    }

    private static String copyReportToSpecifiedLocation(File file, String string, FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor, MoveReportDialogUserResponse moveReportDialogUserResponse) throws ReportLocationException {
        String string2 = string == null ? ReportLocationUtils.copyReportFile(file.getAbsolutePath(), moveReportDialogUserResponse.getNewLocation(), moveReportDialogUserResponse.isMove(), (ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor, true) : ReportLocationUtils.copyReportFile(file.getAbsolutePath(), moveReportDialogUserResponse.getNewLocation(), string, moveReportDialogUserResponse.isMove(), (ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor, true);
        if (moveReportDialogUserResponse.isMove() && file.exists()) {
            MessageDialog.openWarning((Shell)UIUtilities.getShell(), (String)NLSResourceManager.err_file_cannot_be_moved_title, (String)NLS.bind((String)NLSResourceManager.err_file_cannot_be_moved_message, (Object)file.getAbsolutePath()));
        }
        String string3 = ReportLocationUtils.getReportDirectoryCanonicalPath((ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor) + "/" + moveReportDialogUserResponse.getNewLocation();
        IContainer iContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(string3));
        try {
            if (iContainer != null) {
                iContainer.refreshLocal(1, null);
            }
        }
        catch (CoreException coreException) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)((Object)coreException));
        }
        if (moveReportDialogUserResponse.isMove()) {
            IContainer iContainer2 = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(file.getParentFile().getAbsolutePath()));
            try {
                if (iContainer2 != null) {
                    iContainer2.refreshLocal(1, null);
                }
            }
            catch (CoreException coreException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)((Object)coreException));
            }
        }
        return string2;
    }

    private static MoveReportDialogUserResponse askAboutMovingReport(File file, FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor) throws ReportLocationException {
        File file2 = new File(ReportLocationUtils.getReportDirectoryCanonicalPath((ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor));
        ReportNotInSpecifiedLocationDialog reportNotInSpecifiedLocationDialog = new ReportNotInSpecifiedLocationDialog(UIUtilities.getShell(), file2, InsertViewerUtils.isFileReadOnly(file));
        reportNotInSpecifiedLocationDialog.create();
        reportNotInSpecifiedLocationDialog.setBlockOnOpen(true);
        int n = reportNotInSpecifiedLocationDialog.open();
        return new MoveReportDialogUserResponse(n == 0, reportNotInSpecifiedLocationDialog.getNewLocation(), reportNotInSpecifiedLocationDialog.isMove());
    }

    public static String getUniqueViewerName(String string, IDOMDocument iDOMDocument, FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor) {
        int n;
        String string2 = TagLibraryUtils.getPrefixForUri(iDOMDocument, new JSFPageViewer().getURI());
        if (string2 == null) {
            return string;
        }
        NodeList nodeList = iDOMDocument.getDocumentElement().getElementsByTagName(string2 + ":viewer");
        int n2 = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (n = 0; n < n2; ++n) {
            Element element = (Element)nodeList.item(n);
            arrayList.add(element.getAttribute("viewerName"));
        }
        if (!arrayList.contains(string)) {
            return string;
        }
        n = 2;
        for (int i = 0; i < n2 + 1; ++i) {
            if (!arrayList.contains(string + n)) {
                return string + n;
            }
            ++n;
        }
        return null;
    }

    private static boolean isFileReadOnly(File file) {
        return !file.canWrite();
    }
}

