/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.workingset;

import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseUtilities;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.view.model.InvisibleRootParent;
import com.businessobjects.integration.rad.enterprise.view.model.RootParent;
import com.businessobjects.integration.rad.enterprise.view.model.ServerParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import com.businessobjects.integration.rad.enterprise.view.model.ViewContentProvider;
import com.businessobjects.integration.rad.enterprise.view.model.ViewLabelProvider;
import com.businessobjects.integration.rad.enterprise.view.workingset.TreeObjectWorkingSetElement;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class WorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private Text workingSetName;
    private CheckboxTreeViewer viewer;
    private ITreeContentProvider viewerContentProvider;
    private IWorkingSet workingSet;
    private boolean isFirstCheck = true;
    private RootParent root = new RootParent();

    public WorkingSetPage() {
        super(WorkingSetPage.class.getName(), NLSResourceManager.working_set_title, null);
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    public void setSelection(IWorkingSet iWorkingSet) {
        this.workingSet = iWorkingSet;
        if (this.getContainer() != null && this.getShell() != null && this.workingSetName != null) {
            this.workingSetName.setText(iWorkingSet.getName());
            this.updateUI();
            this.validateInput();
        }
    }

    private void updateUI() {
        if (this.workingSet != null) {
            ArrayList<String> arrayList;
            Object object;
            ConnectionInfo connectionInfo;
            this.workingSetName.setText(this.workingSet.getName());
            HashMap<Object, ArrayList<String>> hashMap = new HashMap<Object, ArrayList<String>>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            IAdaptable[] iAdaptableArray = this.workingSet.getElements();
            block0: for (int i = 0; i < iAdaptableArray.length; ++i) {
                TreeObjectWorkingSetElement object2 = (TreeObjectWorkingSetElement)iAdaptableArray[i];
                if (object2.isRoot()) {
                    this.stateChange(this.root, true);
                    arrayList2.add(this.root);
                    break;
                }
                connectionInfo = this.root.getChildren();
                for (int list = 0; list < ((ConnectionInfo)connectionInfo).length; ++list) {
                    object = connectionInfo[list].getConnInfo();
                    if (object.getId() != object2.getConnId()) continue;
                    if (object2.isServer()) {
                        this.stateChange(connectionInfo[list], true);
                        arrayList2.add(connectionInfo[list]);
                        continue;
                    }
                    arrayList = (ArrayList<String>)hashMap.get(object);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(object2.getCUId());
                    hashMap.put(object, arrayList);
                    continue block0;
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                connectionInfo = (ConnectionInfo)entry.getKey();
                List list = (List)entry.getValue();
                object = EnterpriseUtilities.getIdsForCuids((ConnectionInfo)connectionInfo, (List)list);
                if (EnterpriseView.getView() == null) continue;
                arrayList = EnterpriseView.getView().getHelper().findItemsInView(connectionInfo, new ArrayList(object.values()), true);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.stateChange(iterator.next(), true);
                }
                arrayList2.addAll(arrayList);
            }
            this.viewer.setCheckedElements(arrayList2.toArray());
        }
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite2);
        Label label = new Label(composite2, 64);
        label.setText(NLSResourceManager.working_set_name_prompt);
        GridData gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        this.workingSetName = new Text(composite2, 2052);
        this.workingSetName.setLayoutData((Object)new GridData(768));
        this.workingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                WorkingSetPage.this.validateInput();
            }
        });
        this.workingSetName.setFocus();
        label = new Label(composite2, 64);
        label.setText(NLSResourceManager.working_set_name_content);
        gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        this.viewer = new CheckboxTreeViewer(composite2, 2816);
        gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(15);
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewerContentProvider = new ViewContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.viewerContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter(new ViewerSorter());
        InvisibleRootParent invisibleRootParent = new InvisibleRootParent(this.root);
        this.viewer.setInput((Object)invisibleRootParent);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                WorkingSetPage.this.handleCheckStateChange(checkStateChangedEvent);
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                final Object object = treeExpansionEvent.getElement();
                if (!WorkingSetPage.this.viewer.getGrayed(object)) {
                    BusyIndicator.showWhile((Display)WorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WorkingSetPage.this.setSubtreeChecked(object, WorkingSetPage.this.viewer.getChecked(object), false);
                        }
                    });
                }
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(256));
        Button button = new Button(composite3, 8);
        button.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.SELECT_ALL));
        button.setToolTipText(NLSResourceManager.select_all_description);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetPage.this.viewer.setCheckedElements(WorkingSetPage.this.viewerContentProvider.getElements(WorkingSetPage.this.viewer.getInput()));
                WorkingSetPage.this.validateInput();
            }
        });
        button.setLayoutData((Object)new GridData());
        Button button2 = new Button(composite3, 8);
        button2.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.DESELECT_ALL));
        button2.setToolTipText(NLSResourceManager.deselect_all_description);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetPage.this.viewer.setCheckedElements(new Object[0]);
                WorkingSetPage.this.validateInput();
            }
        });
        button2.setLayoutData((Object)new GridData());
        this.updateUI();
        this.validateInput();
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)composite2, "com.businessobjects.integration.rad.enterprise.view.docroot");
        }
        Dialog.applyDialogFont((Control)composite2);
    }

    private void findCheckedElements(List<TreeObject> list, Object object) {
        Object[] objectArray = this.viewerContentProvider.getChildren(object);
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.viewer.getGrayed(objectArray[i])) {
                this.findCheckedElements(list, objectArray[i]);
                continue;
            }
            if (!this.viewer.getChecked(objectArray[i])) continue;
            list.add((TreeObject)objectArray[i]);
        }
    }

    private void setSubtreeChecked(Object object, boolean bl, boolean bl2) {
        if (!(object instanceof TreeParent)) {
            return;
        }
        if (!this.viewer.getExpandedState(object) && bl2) {
            return;
        }
        Object[] objectArray = this.viewerContentProvider.getChildren(object);
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Object object2 = objectArray[i];
            if (bl) {
                this.viewer.setChecked(object2, true);
                this.viewer.setGrayed(object2, false);
            } else {
                this.viewer.setGrayChecked(object2, false);
            }
            if (!this.isExpandable(object2)) continue;
            this.setSubtreeChecked(object2, bl, true);
        }
    }

    private boolean isExpandable(Object object) {
        return object instanceof TreeParent;
    }

    private void handleCheckStateChange(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                WorkingSetPage.this.stateChange(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked());
            }
        });
    }

    private void stateChange(Object object, boolean bl) {
        this.viewer.setGrayed(object, false);
        if (this.isExpandable(object)) {
            this.setSubtreeChecked(object, bl, bl);
        }
        this.updateParentState(object, bl);
        this.validateInput();
    }

    private void updateParentState(Object object, boolean bl) {
        if (object == null) {
            return;
        }
        Object object2 = this.viewerContentProvider.getParent(object);
        if (object2 == null) {
            return;
        }
        boolean bl2 = true;
        Object[] objectArray = null;
        objectArray = this.viewerContentProvider.getChildren(object2);
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (this.viewer.getChecked(objectArray[i]) == bl && !this.viewer.getGrayed(objectArray[i])) continue;
            bl2 = false;
            break;
        }
        this.viewer.setGrayed(object2, !bl2);
        this.viewer.setChecked(object2, !bl2 || bl);
        this.updateParentState(object2, bl);
    }

    private void validateInput() {
        String string = null;
        String string2 = this.workingSetName.getText();
        if (!string2.equals(string2.trim())) {
            string = NLSResourceManager.working_set_err_trailing_spaces;
        }
        if (string2.equals("")) {
            if (this.isFirstCheck) {
                this.setPageComplete(false);
                this.isFirstCheck = false;
                return;
            }
            string = NLSResourceManager.working_set_err_name_empty;
        }
        this.isFirstCheck = false;
        if (!(string != null || this.workingSet != null && string2.equals(this.workingSet.getName()))) {
            IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            for (int i = 0; i < iWorkingSetArray.length; ++i) {
                if (!string2.equals(iWorkingSetArray[i].getName())) continue;
                string = NLSResourceManager.working_set_err_exists;
            }
        }
        if (string == null && !this.hasCheckedElement()) {
            string = NLSResourceManager.working_set_no_select;
        }
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    private boolean hasCheckedElement() {
        return this.viewer.getCheckedElements().length > 0;
    }

    public void finish() {
        Object object;
        List<Object> list;
        ConnectionInfo connectionInfo;
        ArrayList<TreeObjectWorkingSetElement> arrayList = new ArrayList<TreeObjectWorkingSetElement>();
        String string = this.workingSetName.getText();
        ArrayList<TreeObject> arrayList2 = new ArrayList<TreeObject>(10);
        this.findCheckedElements(arrayList2, this.viewer.getInput());
        HashMap hashMap = new HashMap();
        HashMap<ConnectionInfo, HashMap<Integer, Boolean>> hashMap2 = new HashMap<ConnectionInfo, HashMap<Integer, Boolean>>();
        for (TreeObject object2 : arrayList2) {
            connectionInfo = object2.getConnInfo();
            if (object2 instanceof ServerParent) {
                arrayList.add(new TreeObjectWorkingSetElement(connectionInfo.getId(), null, true, true, false, false));
                continue;
            }
            if (object2 instanceof RootParent) {
                arrayList.add(new TreeObjectWorkingSetElement(-1L, null, true, false, true, false));
                continue;
            }
            if (connectionInfo == null) continue;
            list = (List)hashMap.get(connectionInfo);
            if (list == null) {
                list = new ArrayList<Object>();
            }
            object = new Integer(object2.getId());
            list.add(object);
            hashMap.put(connectionInfo, list);
            HashMap<Integer, Boolean> hashMap3 = (Map)hashMap2.get(connectionInfo);
            if (hashMap3 == null) {
                hashMap3 = new HashMap<Integer, Boolean>();
            }
            hashMap3.put(new Integer(object2.getId()), object2 instanceof TreeParent);
            hashMap2.put(connectionInfo, hashMap3);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            connectionInfo = (ConnectionInfo)entry.getKey();
            list = (ArrayList<Object>)entry.getValue();
            object = EnterpriseUtilities.getCuidsForIds((ConnectionInfo)connectionInfo, (List)list);
            for (Map.Entry entry2 : object.entrySet()) {
                Boolean bl;
                String string2 = (String)entry2.getValue();
                Integer n = (Integer)entry2.getKey();
                boolean bl2 = false;
                Map map = (Map)hashMap2.get(connectionInfo);
                if (map != null && (bl = (Boolean)map.get(n)) != null) {
                    bl2 = bl;
                }
                arrayList.add(new TreeObjectWorkingSetElement(connectionInfo.getId(), string2, bl2, false, false, false));
            }
        }
        if (this.workingSet == null) {
            IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = iWorkingSetManager.createWorkingSet(string, arrayList.toArray(new IAdaptable[arrayList.size()]));
        } else {
            this.workingSet.setName(string);
            this.workingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
        }
    }

    public void performHelp() {
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.displayHelp("com.businessobjects.integration.rad.enterprise.view.docroot");
        }
    }
}

