/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.workingset;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfoManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionStore;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.IConnectionStore;
import com.businessobjects.integration.rad.enterprise.view.model.RootParent;
import com.businessobjects.integration.rad.enterprise.view.model.ServerParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import com.businessobjects.integration.rad.enterprise.view.model.UniversesTreeParent;
import com.businessobjects.integration.rad.enterprise.view.workingset.TreeObjectWorkingSetElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetFilter
extends ViewerFilter {
    private IWorkingSet workingSet;
    private boolean allowAll;
    private List<Long> allowedServers = new ArrayList<Long>();
    private Map<Long, List<String>> allowedContainersOnServer = new HashMap<Long, List<String>>();
    private Map<Long, List<String>> allowedObjectsOnServer = new HashMap<Long, List<String>>();
    private boolean changed;
    private boolean workingSetFromBIAR;

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        this.workingSet = iWorkingSet;
        if (iWorkingSet != null) {
            this.allowAll = false;
            this.workingSetFromBIAR = false;
            this.changed = true;
            this.allowedServers.clear();
            this.allowedContainersOnServer.clear();
            this.allowedObjectsOnServer.clear();
            IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
            for (int i = 0; i < iAdaptableArray.length; ++i) {
                List<String> list;
                if (!(iAdaptableArray[i] instanceof TreeObjectWorkingSetElement)) continue;
                TreeObjectWorkingSetElement treeObjectWorkingSetElement = (TreeObjectWorkingSetElement)iAdaptableArray[i];
                Long l = new Long(treeObjectWorkingSetElement.getConnId());
                if (treeObjectWorkingSetElement.isRoot()) {
                    this.allowAll = true;
                    break;
                }
                if (treeObjectWorkingSetElement.isServer()) {
                    this.allowedServers.add(l);
                    continue;
                }
                if (treeObjectWorkingSetElement.isGeneratedByImportBIAR()) {
                    this.workingSetFromBIAR = true;
                }
                if (treeObjectWorkingSetElement.isContainer()) {
                    list = WorkingSetFilter.getListFromMap(this.allowedContainersOnServer, l);
                    list.add(treeObjectWorkingSetElement.getCUId());
                    this.allowedContainersOnServer.put(l, list);
                    continue;
                }
                list = WorkingSetFilter.getListFromMap(this.allowedObjectsOnServer, l);
                list.add(treeObjectWorkingSetElement.getCUId());
                this.allowedObjectsOnServer.put(l, list);
            }
        }
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        ArrayList<String> arrayList;
        List<String> list;
        Object object3;
        Object object4;
        if (object2 == null || viewer == null) {
            return false;
        }
        if (this.allowAll || this.workingSet == null) {
            return true;
        }
        if (object2 instanceof RootParent) {
            return true;
        }
        TreeObject treeObject = (TreeObject)object2;
        Long l = null;
        if (treeObject.getConnInfo() != null) {
            l = new Long(treeObject.getConnInfo().getId());
        }
        if (this.allowedServers.contains(l)) {
            return true;
        }
        if (treeObject instanceof ServerParent) {
            return this.allowedContainersOnServer.keySet().contains(l) || this.allowedObjectsOnServer.keySet().contains(l);
        }
        if (this.changed) {
            object4 = ConnectionInfoManager.getInstance().getConnections((IConnectionStore)ConnectionStore.getInstance());
            for (int i = 0; i < ((ConnectionInfo[])object4).length; ++i) {
                object3 = new Long(object4[i].getId());
                if (this.allowedContainersOnServer.keySet().contains(object3)) {
                    list = this.allowedContainersOnServer.get(object3);
                    arrayList = EnterpriseUtilities.getIdsForCuids((ConnectionInfo)object4[i], (List)list);
                    this.allowedContainersOnServer.put((Long)object3, new ArrayList(arrayList.keySet()));
                }
                if (!this.allowedObjectsOnServer.keySet().contains(object3)) continue;
                list = this.allowedObjectsOnServer.get(object3);
                arrayList = EnterpriseUtilities.getIdsForCuids((ConnectionInfo)object4[i], list);
                this.allowedObjectsOnServer.put((Long)object3, new ArrayList(arrayList.keySet()));
            }
            this.changed = false;
        }
        object4 = WorkingSetFilter.getListFromMap(this.allowedContainersOnServer, l);
        List<String> list2 = WorkingSetFilter.getListFromMap(this.allowedObjectsOnServer, l);
        object3 = EnterpriseUtilities.getCuidForId((ConnectionInfo)treeObject.getConnInfo(), (int)treeObject.getId());
        list = new Integer(treeObject.getId());
        if (object4.contains(object3) || list2.contains(object3)) {
            LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "Working Set:" + (String)object3 + " (" + treeObject.getName() + ") passed by case 1");
            return true;
        }
        if (!this.workingSetFromBIAR || treeObject instanceof UniversesTreeParent || "CrystalEnterprise.FavoritesFolder".equals(treeObject.getProgId()) || "CrystalEnterprise.Inbox".equals(treeObject.getProgId())) {
            for (Object object5 : EnterpriseUtilities.getIdsForCuids((ConnectionInfo)treeObject.getConnInfo(), (List)object4).values()) {
                if (!EnterpriseUtilities.isContained((ConnectionInfo)treeObject.getConnInfo(), (int)((Integer)object5), (int)((Integer)((Object)list)))) continue;
                LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "Working Set:" + (String)object3 + " (" + treeObject.getName() + ") passed by case 2:" + object5 + "," + (String)object3);
                return true;
            }
            if (treeObject instanceof TreeParent) {
                arrayList = new ArrayList<String>(object4.size() + list2.size());
                arrayList.addAll((Collection<String>)object4);
                arrayList.addAll(list2);
                for (Integer n : EnterpriseUtilities.getIdsForCuids((ConnectionInfo)treeObject.getConnInfo(), arrayList).values()) {
                    if (!EnterpriseUtilities.isContained((ConnectionInfo)treeObject.getConnInfo(), (int)((Integer)((Object)list)), (int)n)) continue;
                    LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "Working Set:" + (String)object3 + " (" + treeObject.getName() + ") passed by case 3");
                    return true;
                }
            }
        }
        return false;
    }

    private static final List<String> getListFromMap(Map<Long, List<String>> map, Object object) {
        List<String> list = map.get(object);
        if (list == null) {
            list = new ArrayList<String>();
        }
        return list;
    }
}

