/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.editor;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.enterprise.editormanager.ConnectException;
import com.businessobjects.integration.enterprise.editormanager.EnterpriseEditorInputManager;
import com.businessobjects.integration.enterprise.editormanager.IEnterpriseEditorInput;
import com.businessobjects.integration.enterprise.editormanager.IPropertyChangeListener;
import com.businessobjects.integration.rad.enterprise.objects.ObjectTypeManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfoManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionStore;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.IConnectionStore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

public class EnterpriseEditorInput
implements IEnterpriseEditorInput {
    private static final String TEMP_FILE_PREFIX = "boe";
    private String serverName;
    private String displayName;
    private String progId;
    private String token;
    private long connId;
    private int id;
    private boolean saveToEnterprise = true;
    private File localFile;
    private List listeners = new ArrayList();
    private String enterprisePath;

    public EnterpriseEditorInput(String string, String string2, String string3, String string4, long l, int n) {
        this.serverName = string;
        this.displayName = string4;
        this.token = string2;
        this.connId = l;
        this.id = n;
        this.progId = string3;
        ConnectionInfo connectionInfo = this.getConnInfo();
        try {
            Stack[] stackArray;
            List list = EnterpriseFunctionAccessor.getInstance((int)connectionInfo.getVersion()).query(connectionInfo, "SELECT SI_PARENTID FROM CI_INFOOBJECTS WHERE SI_ID=" + this.getInfoObjectId());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (list.size() > 0) {
                stackArray = (Stack[])list.get(0);
                arrayList.add(stackArray.get("SI_PARENTID"));
            }
            if ((stackArray = EnterpriseUtilities.findPaths((ConnectionInfo)connectionInfo, (int)0, arrayList)).length == 1) {
                Stack stack = stackArray[0];
                arrayList.clear();
                for (int i = 0; i < stack.size(); ++i) {
                    arrayList.add(stack.elementAt(i));
                }
                Map map = EnterpriseUtilities.getNamesForIdsForInfoObjects((ConnectionInfo)connectionInfo, arrayList);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("ceis://").append(connectionInfo.getServerName() + "/");
                while (!stack.isEmpty()) {
                    Integer n2 = (Integer)stack.pop();
                    String string5 = (String)map.get(n2);
                    if (string5 == null) continue;
                    stringBuffer.append(string5).append("/");
                }
                this.enterprisePath = stringBuffer.toString();
            }
        }
        catch (ConnectionException connectionException) {
            this.setSaveToEnterprise(false);
            this.enterprisePath = null;
            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof EnterpriseEditorInput) {
            EnterpriseEditorInput enterpriseEditorInput = (EnterpriseEditorInput)object;
            return enterpriseEditorInput.getConnectionId() == this.connId && enterpriseEditorInput.getInfoObjectId() == this.id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.connId + this.id;
    }

    public IPath getPath() {
        if (this.localFile == null) {
            throw new IllegalStateException();
        }
        return new Path(this.localFile.getAbsolutePath());
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getToken() {
        return this.token;
    }

    public long getConnectionId() {
        return this.connId;
    }

    public int getInfoObjectId() {
        return this.id;
    }

    public String getProgId() {
        return this.progId;
    }

    public boolean isSaveToEnterprise() {
        return this.saveToEnterprise;
    }

    public void setSaveToEnterprise(boolean bl) {
        this.saveToEnterprise = bl;
        if (!bl && this.localFile != null) {
            this.localFile.delete();
        }
    }

    private ConnectionInfo getConnInfo() {
        ConnectionInfo[] connectionInfoArray = ConnectionInfoManager.getInstance().getConnections((IConnectionStore)ConnectionStore.getInstance());
        for (int i = 0; i < connectionInfoArray.length; ++i) {
            ConnectionInfo connectionInfo = connectionInfoArray[i];
            if (this.connId != connectionInfo.getId()) continue;
            return connectionInfo;
        }
        return null;
    }

    public String load() throws ConnectException {
        ConnectionInfo connectionInfo = this.getConnInfo();
        if (connectionInfo != null) {
            try {
                File file = File.createTempFile(TEMP_FILE_PREFIX, null);
                file.delete();
                String string = file.getParentFile().getAbsolutePath();
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                EnterpriseFunctionAccessor.getInstance((int)connectionInfo.getVersion()).download(connectionInfo, this.id, ObjectTypeManager.getExtensions((String)this.progId), string, arrayList, arrayList2);
                if (!arrayList2.isEmpty() || arrayList.size() == 0) {
                    throw new ConnectException();
                }
                this.localFile = new File((String)arrayList.get(0));
                return this.localFile.getAbsolutePath();
            }
            catch (IOException iOException) {
                throw new ConnectException((Throwable)iOException);
            }
            catch (ConnectionException connectionException) {
                throw new ConnectException((Throwable)connectionException);
            }
        }
        return null;
    }

    public void save() throws ConnectException {
        if (this.localFile == null || !this.isSaveToEnterprise()) {
            throw new IllegalStateException();
        }
        ConnectionInfo connectionInfo = this.getConnInfo();
        try {
            EnterpriseFunctionAccessor.getInstance((int)connectionInfo.getVersion()).saveReport(connectionInfo, this.localFile, this.enterprisePath, this.displayName);
        }
        catch (ConnectionException connectionException) {
            throw new ConnectException((Throwable)connectionException);
        }
    }

    public void setName(String string) {
        String string2 = this.displayName;
        this.displayName = string;
        this.firePropertyChange("SI_NAME", string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(iPropertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(iPropertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(String string, Object object, Object object2) {
        ArrayList arrayList;
        List list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList(this.listeners.size());
            arrayList.addAll(this.listeners);
        }
        for (IPropertyChangeListener iPropertyChangeListener : arrayList) {
            iPropertyChangeListener.handleEvent(string, object, object2);
        }
    }

    public void close() {
        if (this.localFile != null) {
            this.localFile.delete();
        }
        EnterpriseEditorInputManager.getInstance().removeEditorInput((IEnterpriseEditorInput)this);
    }

    public boolean exists() {
        boolean bl = false;
        if (this.localFile != null) {
            bl = this.localFile.exists();
        }
        return bl;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.displayName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public Object getAdapter(Class clazz) {
        return null;
    }
}

