/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions.internal;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionAlreadyExistsException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfoManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionStore;
import com.businessobjects.integration.rad.enterprise.sdkconnection.IConnectionStatusListener;
import com.businessobjects.integration.rad.enterprise.sdkconnection.IConnectionStore;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.ConnectionListener;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.NewConnectionWizardPage1;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.NewConnectionWizardPage2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class NewConnectionWizard
extends Wizard {
    private NewConnectionWizardPage1 page1;
    private NewConnectionWizardPage2 page2;
    private ConnectionInfo connInfo;
    private ConnectionInfo connInfoToEdit;
    private boolean isEdit;

    public NewConnectionWizard(ConnectionInfo connectionInfo, boolean bl) {
        this.isEdit = connectionInfo != null;
        this.connInfo = connectionInfo;
        this.page1 = new NewConnectionWizardPage1();
        this.page2 = new NewConnectionWizardPage2();
        if (this.isEdit) {
            this.page1.setInitialDisplayName(connectionInfo.getDisplayName());
            this.page1.setInitialServerName(connectionInfo.getServerName());
            this.page1.setInitialUserId(connectionInfo.getUserId());
            this.page1.setInitialPassword(connectionInfo.getPassword());
            this.page1.setInitialAuthMethod(connectionInfo.getAuthMethod());
            this.page1.setInitialSavePassword(connectionInfo.isSavePassword());
            this.connInfoToEdit = connectionInfo;
        }
        if (bl) {
            this.page1.setTitle(NLSResourceManager.edit_wizard_title);
            this.page2.setTitle(NLSResourceManager.edit_wizard_title);
            this.setWindowTitle(NLSResourceManager.edit_connection_wizard_name);
        } else {
            this.page1.setTitle(NLSResourceManager.logon_wizard_title);
            this.page2.setTitle(NLSResourceManager.logon_wizard_title);
            this.setWindowTitle(NLSResourceManager.new_connection_wizard_name);
        }
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (iWizardPage == this.page1 && this.page1.isModified()) {
            if (!this.connect(false)) {
                return null;
            }
            this.page1.commitChanges();
        }
        return super.getNextPage(iWizardPage);
    }

    public boolean performFinish() {
        return this.connect(true);
    }

    public boolean connect(boolean bl) {
        try {
            TreeViewer treeViewer;
            EnterpriseView enterpriseView;
            if (this.isEdit && bl) {
                ConnectionInfoManager.getInstance().removeConnection((IConnectionStore)ConnectionStore.getInstance(), this.connInfoToEdit);
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (bl) {
                string = this.page2.getAdminURL();
                string2 = this.page2.getCmcURL();
                string3 = this.page2.getInfoViewURL();
                string4 = this.page2.getQueryBuilderURL();
            }
            this.connInfo = ConnectionInfoManager.getInstance().makeConnection((IConnectionStore)ConnectionStore.getInstance(), this.page1.getServerName(), this.page1.getDisplayName(), this.page1.getUserId(), this.page1.getPassword(), this.page1.getAuthMethod(), this.page1.isSavePassword(), string, string2, string3, string4, bl);
            if (bl) {
                this.connInfo.addListener((IConnectionStatusListener)new ConnectionListener(this.connInfo));
            }
            if ((enterpriseView = EnterpriseView.getView()) != null && (treeViewer = enterpriseView.getViewer()) != null) {
                treeViewer.refresh((Object)enterpriseView.getRoot());
            }
            return true;
        }
        catch (ConnectionAlreadyExistsException connectionAlreadyExistsException) {
            MessageDialog.openInformation((Shell)UIUtilities.getShell(), (String)NLSResourceManager.conninfo_exists_title, (String)NLSResourceManager.conninfo_exists_description);
            return false;
        }
        catch (ConnectionException connectionException) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
            return false;
        }
    }
}

