/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions.internal;

import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.BIARItem;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseViewPlugin;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ImportBIARWizardPage
extends WizardPage {
    private BIARItem[] biarItems;
    private String workingSet = null;
    private Text workingSetName;
    private Button isWorkingSetBtn;

    public ImportBIARWizardPage(String string, List<BIARItem> list) {
        super(string);
        this.biarItems = list.toArray(new BIARItem[list.size()]);
        this.setImageDescriptor(EnterpriseViewPlugin.getImageDescriptor("/icons/importbiar_wiz.gif"));
    }

    public String getWorkingSet() {
        return this.workingSet;
    }

    public void createControl(Composite composite) {
        int n;
        this.setTitle(NLSResourceManager.import_biar_wizard_title);
        this.setMessage(NLSResourceManager.import_biar_wizard_message);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        final TableViewer tableViewer = new TableViewer(composite2, 268503042);
        final Table table = tableViewer.getTable();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn tableColumn = table.getSortColumn();
                final TableColumn tableColumn2 = (TableColumn)event.widget;
                int n = table.getSortDirection();
                if (tableColumn == tableColumn2) {
                    n = n == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(tableColumn2);
                    n = 128;
                }
                final int n2 = n == 128 ? 1 : -1;
                Arrays.sort(ImportBIARWizardPage.this.biarItems, new Comparator<BIARItem>(){

                    @Override
                    public int compare(BIARItem bIARItem, BIARItem bIARItem2) {
                        if (tableColumn2 == table.getColumn(0)) {
                            return n2 * bIARItem.getName().compareTo(bIARItem2.getName());
                        }
                        if (tableColumn2 == table.getColumn(1)) {
                            return n2 * bIARItem.getKind().compareTo(bIARItem2.getKind());
                        }
                        if (tableColumn2 == table.getColumn(2)) {
                            return n2 * bIARItem.getCuid().compareTo(bIARItem2.getCuid());
                        }
                        return 0;
                    }
                });
                table.setSortDirection(n);
                tableViewer.refresh();
            }
        };
        GridData gridData2 = new GridData(1808);
        table.setLayoutData((Object)gridData2);
        Group group = new Group(composite2, 0);
        group.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.OPTIONS));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        this.isWorkingSetBtn = new Button((Composite)group, 32);
        GridData gridData3 = new GridData(1);
        this.isWorkingSetBtn.setLayoutData((Object)gridData3);
        Label label = new Label((Composite)group, 0);
        GridData gridData4 = new GridData(768);
        label.setText(NLSResourceManager.create_working_set_from_biar);
        label.setLayoutData((Object)gridData4);
        new Label((Composite)group, 0);
        this.workingSetName = new Text((Composite)group, 2048);
        GridData gridData5 = new GridData(768);
        this.workingSetName.setLayoutData((Object)gridData5);
        this.workingSetName.setEnabled(false);
        this.isWorkingSetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportBIARWizardPage.this.validate();
            }
        });
        this.workingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ImportBIARWizardPage.this.validate();
            }
        });
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] stringArray = new String[]{ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.NAME), ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.TYPE), "CUID"};
        for (n = 0; n < stringArray.length; ++n) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[n]);
            tableColumn.addListener(13, listener);
        }
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TableColumn[] tableColumnArray = table.getColumns();
                if (tableColumnArray.length == 3) {
                    tableColumnArray[0].setWidth((int)((double)table.getClientArea().width * 0.5));
                    tableColumnArray[1].setWidth((int)((double)table.getClientArea().width * 0.25));
                    tableColumnArray[2].setWidth((int)((double)table.getClientArea().width * 0.25));
                }
            }
        });
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                if (object instanceof Object[]) {
                    return ImportBIARWizardPage.this.biarItems;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object object, int n) {
                return null;
            }

            public String getColumnText(Object object, int n) {
                BIARItem bIARItem = (BIARItem)object;
                switch (n) {
                    case 0: {
                        return String.valueOf(bIARItem.getName());
                    }
                    case 1: {
                        return String.valueOf(bIARItem.getKind());
                    }
                    case 2: {
                        return String.valueOf(bIARItem.getCuid());
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object object, String string) {
                return true;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        });
        tableViewer.setInput((Object)this.biarItems);
        for (n = 0; n < stringArray.length; ++n) {
            table.getColumn(n).pack();
        }
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)composite2, "com.businessobjects.integration.rad.enterprise.view.docroot");
        }
        this.setControl((Control)composite2);
    }

    public void performHelp() {
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.displayHelp("com.businessobjects.integration.rad.enterprise.view.docroot");
        }
    }

    private void setError(String string) {
        if (string == null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(string);
            this.setPageComplete(false);
        }
    }

    private void validate() {
        if (this.isWorkingSetBtn.getSelection()) {
            this.workingSetName.setEnabled(true);
            String string = this.workingSetName.getText().trim();
            if (string.length() == 0) {
                this.setError(NLSResourceManager.working_set_name_empty);
            } else {
                IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                if (iWorkingSetManager.getWorkingSet(string) != null) {
                    this.setError(NLS.bind((String)NLSResourceManager.working_set_name_dup, (Object)string));
                } else {
                    this.setError(null);
                }
            }
            this.workingSet = string;
        } else {
            this.workingSetName.setEnabled(false);
            this.workingSet = null;
            this.setError(null);
        }
    }
}

