/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.actions.IEnterpriseViewAction;
import com.businessobjects.integration.rad.enterprise.view.model.ServerParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class RefreshContextAction
extends Action
implements IEnterpriseViewAction {
    private IStructuredSelection selections;

    @Override
    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.selections = iStructuredSelection;
        this.setEnabled(this.isEnabledBasedOnState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        EnterpriseView enterpriseView = EnterpriseView.getView();
        TreeViewer treeViewer = enterpriseView.getViewer();
        for (TreeObject treeObject : this.selections) {
            if (treeObject instanceof ServerParent) {
                treeObject.getConnInfo().setOnline(true);
            }
            try {
                treeViewer.getControl().getShell().setCursor(UIUtilities.getDisplay().getSystemCursor(1));
                treeViewer.refresh((Object)treeObject);
            }
            finally {
                treeViewer.getControl().getShell().setCursor(null);
            }
        }
    }

    public boolean isEnabledBasedOnState() {
        if (this.selections != null && this.selections.size() > 0) {
            if (this.selections.size() == 1) {
                TreeObject treeObject = (TreeObject)this.selections.getFirstElement();
                ConnectionInfo connectionInfo = treeObject.getConnInfo();
                boolean bl = connectionInfo != null && connectionInfo.isConnected();
                return bl;
            }
            for (TreeObject treeObject : this.selections) {
                ConnectionInfo connectionInfo = treeObject.getConnInfo();
                boolean bl = connectionInfo != null && connectionInfo.isConnected();
                if (bl) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.isEnabledBasedOnState();
    }
}

