/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.enterprise.editormanager.EnterpriseEditorInputManager;
import com.businessobjects.integration.enterprise.editormanager.IEnterpriseEditorInput;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.actions.IEnterpriseViewAction;
import com.businessobjects.integration.rad.enterprise.view.editor.EnterpriseEditorInput;
import com.businessobjects.integration.rad.enterprise.view.model.BOEShortcutTreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PartInitException;

public class OpenContextAction
extends Action
implements IEnterpriseViewAction {
    public static String[] CONTAINER_PROGIDS = new String[]{"CrystalEnterprise.Inbox", "CrystalEnterprise.Category", "CrystalEnterprise.PersonalCategory", "CrystalEnterprise.Folder", "CrystalEnterprise.FavoritesFolder"};
    private List<ConnectionInfo> connInfo = new ArrayList<ConnectionInfo>();
    private List<String> progId = new ArrayList<String>();
    private List<String> name = new ArrayList<String>();
    private List<Integer> id = new ArrayList<Integer>();
    private boolean usePopulatedStates = false;
    private IStructuredSelection selection;

    @Override
    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
        this.setEnabled(this.isEnabledBasedOnState());
    }

    public void setState(List<ConnectionInfo> list, List<String> list2, List<String> list3, List<Integer> list4) {
        this.connInfo = list;
        this.progId = list2;
        this.name = list3;
        this.id = list4;
        this.usePopulatedStates = true;
    }

    private boolean isEnabledBasedOnState() {
        if (this.selection != null && this.selection.size() > 0) {
            for (TreeObject treeObject : this.selection) {
                BOEShortcutTreeObject bOEShortcutTreeObject;
                if (treeObject instanceof TreeParent) {
                    return false;
                }
                if (!(treeObject instanceof BOEShortcutTreeObject) || Arrays.binarySearch(CONTAINER_PROGIDS, (bOEShortcutTreeObject = (BOEShortcutTreeObject)treeObject).getTargetProgId()) < 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.isEnabled();
    }

    public void run() {
        Object object;
        Object object2;
        Object object3;
        TreeViewer treeViewer;
        EnterpriseView enterpriseView;
        if (!this.usePopulatedStates && (enterpriseView = EnterpriseView.getView()) != null) {
            treeViewer = enterpriseView.getViewer();
            object3 = this.selection != null ? this.selection : (IStructuredSelection)treeViewer.getSelection();
            object2 = object3.iterator();
            this.connInfo.clear();
            this.progId.clear();
            this.id.clear();
            this.name.clear();
            while (object2.hasNext()) {
                TreeObject treeObject = (TreeObject)object2.next();
                if (treeObject instanceof BOEShortcutTreeObject) {
                    object = (BOEShortcutTreeObject)treeObject;
                    this.progId.add(((BOEShortcutTreeObject)object).getTargetProgId());
                    this.id.add(new Integer(((BOEShortcutTreeObject)object).getTargetId()));
                } else {
                    this.progId.add(treeObject.getProgId());
                    this.id.add(new Integer(treeObject.getId()));
                }
                this.connInfo.add(treeObject.getConnInfo());
                this.name.add(treeObject.getName());
            }
        }
        for (int i = 0; i < this.connInfo.size(); ++i) {
            treeViewer = this.connInfo.get(i);
            object3 = this.progId.get(i);
            object2 = this.name.get(i);
            int n = this.id.get(i);
            object = EnterpriseFunctionAccessor.getInstance((int)treeViewer.getVersion()).getWCALogonToken((ConnectionInfo)treeViewer);
            EnterpriseEditorInput enterpriseEditorInput = new EnterpriseEditorInput(treeViewer.getServerName(), (String)object, (String)object3, (String)object2, treeViewer.getId(), n);
            String string = EnterpriseEditorInputManager.getInstance().getPreferredEditor((String)object3);
            try {
                EnterpriseEditorInputManager.getInstance().setPreferredEditor((String)object3, string);
                EnterpriseEditorInputManager.getInstance().openEditor(UIUtilities.getActivePage(), (IEnterpriseEditorInput)enterpriseEditorInput, (String)object3);
                continue;
            }
            catch (PartInitException partInitException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)partInitException));
            }
        }
    }

    static {
        Arrays.sort(CONTAINER_PROGIDS);
    }
}

