/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.enterprise.editormanager.EnterpriseEditorInputManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfoManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.Credential;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.actions.IEnterpriseViewAction;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.LogonDialog;
import com.businessobjects.integration.rad.enterprise.view.model.RootParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class LogOnOffContextAction
extends Action
implements IEnterpriseViewAction {
    private static final String CONNECT = ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.CONNECT);
    private static final String DISCONNECT = ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.DISCONNECT);
    private IStructuredSelection selection;

    @Override
    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
        this.populateName();
        this.setEnabled(this.isEnabledBasedOnState());
    }

    @Override
    public boolean isVisible() {
        return this.isEnabled();
    }

    private void populateName() {
        TreeObject treeObject;
        String string = super.getText();
        string = this.selection == null || this.selection.isEmpty() ? CONNECT : ((treeObject = (TreeObject)this.selection.getFirstElement()).getConnInfo() == null ? CONNECT : (treeObject.getConnInfo().isConnected() ? DISCONNECT : CONNECT));
        this.setText(string);
    }

    public void run() {
        EnterpriseView enterpriseView = EnterpriseView.getView();
        assert (enterpriseView != null);
        TreeViewer treeViewer = enterpriseView.getViewer();
        TreeParent treeParent = enterpriseView.getRoot();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
        Iterator iterator = iStructuredSelection.iterator();
        HashSet<ConnectionInfo> hashSet = new HashSet<ConnectionInfo>();
        while (iterator.hasNext()) {
            TreeObject treeObject = (TreeObject)iterator.next();
            hashSet.add(treeObject.getConnInfo());
        }
        for (ConnectionInfo connectionInfo : hashSet) {
            boolean bl = false;
            do {
                try {
                    boolean bl2 = !connectionInfo.isConnected();
                    LogOnOffContextAction.setConnectState(connectionInfo, bl2, treeParent, treeViewer);
                    bl = true;
                }
                catch (ConnectionException connectionException) {
                    LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                    bl = false;
                }
            } while (!bl);
        }
    }

    public static boolean setConnectState(ConnectionInfo connectionInfo, boolean bl, TreeParent treeParent, TreeViewer treeViewer) throws ConnectionException {
        boolean bl2;
        IWorkbenchPage iWorkbenchPage;
        Object[] objectArray;
        if (bl) {
            LogonDialog logonDialog;
            objectArray = "";
            if (connectionInfo.isSavePassword()) {
                objectArray = connectionInfo.getPassword();
            }
            if ((logonDialog = new LogonDialog(UIUtilities.getShell(), connectionInfo.getUserId(), (String)objectArray, connectionInfo.getAuthMethod())).open() == 0) {
                iWorkbenchPage = new Credential(logonDialog.getUserName(), logonDialog.getPassword(), logonDialog.getAuthentication());
                ConnectionInfoManager.getInstance().setSessionCredential(connectionInfo, (Credential)iWorkbenchPage);
                connectionInfo.setConnected(bl);
                bl2 = true;
            } else {
                bl2 = false;
            }
        } else {
            connectionInfo.setConnected(bl);
            ConnectionInfoManager.getInstance().removeSessionCredential(connectionInfo);
            objectArray = EnterpriseEditorInputManager.getInstance().getAllEditorInputsOfServer(connectionInfo.getId());
            for (int i = 0; i < objectArray.length; ++i) {
                IEditorPart iEditorPart;
                objectArray[i].setSaveToEnterprise(false);
                iWorkbenchPage = UIUtilities.getActivePage();
                if (iWorkbenchPage == null || (iEditorPart = iWorkbenchPage.findEditor((IEditorInput)objectArray[i])) == null) continue;
                iWorkbenchPage.closeEditor(iEditorPart, true);
            }
            bl2 = true;
        }
        if (treeParent != null && treeViewer != null) {
            objectArray = treeParent.getChildren();
            for (int i = 0; i < objectArray.length; ++i) {
                iWorkbenchPage = objectArray[i].getConnInfo();
                if (iWorkbenchPage == null || !iWorkbenchPage.equals((Object)connectionInfo)) continue;
                treeViewer.refresh((Object)objectArray[i]);
            }
        }
        return bl2;
    }

    public boolean isEnabledBasedOnState() {
        if (this.selection != null && this.selection.size() == 1 && this.selection.size() == 1) {
            TreeObject treeObject = (TreeObject)this.selection.getFirstElement();
            return !(treeObject instanceof RootParent);
        }
        return false;
    }
}

