/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseViewPlugin;
import com.businessobjects.integration.rad.enterprise.view.actions.IEnterpriseViewAction;
import com.businessobjects.integration.rad.enterprise.view.model.RootParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class LaunchInfoViewContextAction
extends Action
implements IEnterpriseViewAction {
    private IStructuredSelection selection;

    @Override
    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
        this.setEnabled(this.isEnabledBasedOnState());
    }

    @Override
    public boolean isVisible() {
        return this.isEnabled();
    }

    public ImageDescriptor getImageDescriptor() {
        return EnterpriseViewPlugin.getImageDescriptor("icons/infoView.gif");
    }

    public boolean isEnabledBasedOnState() {
        if (this.selection != null && this.selection.size() == 1) {
            TreeObject treeObject = (TreeObject)this.selection.getFirstElement();
            boolean bl = !(treeObject instanceof RootParent);
            return bl;
        }
        return false;
    }

    public void run() {
        String string;
        TreeObject treeObject = (TreeObject)this.selection.getFirstElement();
        if (treeObject.getConnInfo() == null) {
            throw new IllegalStateException();
        }
        String string2 = treeObject.getConnInfo().getInfoViewLocation();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        string2 = string2 + "logon/logon.do";
        ConnectionInfo connectionInfo = treeObject.getConnInfo();
        if (connectionInfo != null && connectionInfo.isConnected()) {
            string = EnterpriseFunctionAccessor.getInstance((int)connectionInfo.getVersion()).getWCALogonToken(connectionInfo);
            char c = '?';
            if (string2.indexOf(63) >= 0) {
                c = '&';
            }
            string2 = string2 + c + "token=" + string;
        }
        LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "Launching URL:" + string2);
        string = PlatformUI.getWorkbench();
        if (string != null) {
            IWorkbenchBrowserSupport iWorkbenchBrowserSupport = string.getBrowserSupport();
            try {
                iWorkbenchBrowserSupport.createBrowser(8, string2, this.getText(), this.getText()).openURL(new URL(string2));
            }
            catch (PartInitException partInitException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)partInitException));
            }
            catch (MalformedURLException malformedURLException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)malformedURLException);
            }
        }
    }
}

