/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.BIARItem;
import com.businessobjects.integration.rad.enterprise.sdkconnection.BIARRecord;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.IEnterpriseFunctionsV115;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.view.actions.IEnterpriseViewAction;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.ImportBIARWizard;
import com.businessobjects.integration.rad.enterprise.view.model.ServerParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.workingset.TreeObjectWorkingSetElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ImportFromBIARContextAction
extends Action
implements IEnterpriseViewAction {
    public static final String WORKING_SET_ID = "com.businessobjects.integration.rad.enterprise.view.WorkingSet";
    private static final String FAMILY = "importBIAR.family";
    private IStructuredSelection selection;

    @Override
    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
        this.setEnabled(this.isEnabledBasedOnState());
    }

    private boolean isEnabledBasedOnState() {
        if (this.selection != null && this.selection.size() == 1) {
            TreeObject treeObject = (TreeObject)this.selection.getFirstElement();
            ConnectionInfo connectionInfo = treeObject.getConnInfo();
            boolean bl = connectionInfo != null && connectionInfo.isConnected();
            boolean bl2 = treeObject instanceof ServerParent;
            boolean bl3 = connectionInfo != null && connectionInfo.getVersion() >= 1150;
            return bl && bl3 && bl2;
        }
        return false;
    }

    public void run() {
        TreeObject treeObject;
        ServerParent serverParent = null;
        for (treeObject = (TreeObject)this.selection.getFirstElement(); !(treeObject instanceof ServerParent) || treeObject == null; treeObject = treeObject.getParent()) {
        }
        if (treeObject instanceof ServerParent) {
            serverParent = (ServerParent)treeObject;
        }
        if (serverParent != null) {
            try {
                ConnectionInfo connectionInfo = serverParent.getConnInfo();
                FileDialog fileDialog = new FileDialog(UIUtilities.getShell());
                fileDialog.setText(NLSResourceManager.import_biar_title);
                fileDialog.setFilterExtensions(new String[]{"*.biar"});
                fileDialog.setFilterNames(new String[]{NLSResourceManager.import_biar_filter_description});
                String string = fileDialog.open();
                if (string != null) {
                    File file = new File(string);
                    if (!file.exists()) {
                        MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.import_biar_file_not_exist_title, (String)NLS.bind((String)NLSResourceManager.import_biar_file_not_exist_message, (Object)file.getAbsolutePath()));
                        return;
                    }
                    ImportFromBIARContextAction.importBIAR(connectionInfo, string, serverParent);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)operationCanceledException));
            }
            catch (InterruptedException interruptedException) {
                LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", (Exception)interruptedException);
            }
        }
    }

    public static void importBIAR(ConnectionInfo connectionInfo, String string, ServerParent serverParent) throws OperationCanceledException, InterruptedException {
        ImportBIARJob importBIARJob = new ImportBIARJob(NLSResourceManager.import_biar_job_name, connectionInfo, string, serverParent.getId());
        importBIARJob.schedule();
        IJobManager iJobManager = Job.getJobManager();
        iJobManager.join((Object)FAMILY, null);
        BIARItem[] bIARItemArray = importBIARJob.getItems();
        if (bIARItemArray != null) {
            ImportBIARWizard importBIARWizard = new ImportBIARWizard(new ArrayList<BIARItem>(Arrays.asList(bIARItemArray)));
            WizardDialog wizardDialog = new WizardDialog(UIUtilities.getShell(), (IWizard)importBIARWizard);
            wizardDialog.setPageSize(450, 400);
            if (wizardDialog.open() == 0) {
                CommitBIARJob commitBIARJob = new CommitBIARJob(NLSResourceManager.import_commit_biar_job_name, connectionInfo, importBIARJob.getHelper(), importBIARJob.getInfoObjects());
                commitBIARJob.schedule();
                iJobManager.join((Object)FAMILY, null);
                if (importBIARWizard.getWorkingSet() != null) {
                    ArrayList<TreeObjectWorkingSetElement> arrayList = new ArrayList<TreeObjectWorkingSetElement>(bIARItemArray.length + 1);
                    for (int i = 0; i < bIARItemArray.length; ++i) {
                        arrayList.add(new TreeObjectWorkingSetElement(serverParent.getConnInfo().getId(), bIARItemArray[i].getCuid(), bIARItemArray[i].isContainer(), false, false, true));
                    }
                    IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                    IWorkingSet iWorkingSet = iWorkingSetManager.createWorkingSet(importBIARWizard.getWorkingSet(), arrayList.toArray(new IAdaptable[arrayList.size()]));
                    iWorkingSet.setId(WORKING_SET_ID);
                    iWorkingSetManager.addWorkingSet(iWorkingSet);
                    iWorkingSetManager.addRecentWorkingSet(iWorkingSet);
                    EnterpriseView enterpriseView = EnterpriseView.getView();
                    if (enterpriseView != null) {
                        enterpriseView.setWorkingSetUI(iWorkingSet);
                    }
                }
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.isEnabled();
    }

    private static class ImportBIARJob
    extends Job {
        private ConnectionInfo connInfo;
        private String filePath;
        private int serverId;
        private BIARItem[] items;
        private IEnterpriseFunctionsV115 helper;
        private Object infoObjects;

        public ImportBIARJob(String string, ConnectionInfo connectionInfo, String string2, int n) {
            super(string);
            this.connInfo = connectionInfo;
            this.filePath = string2;
            this.serverId = n;
        }

        public BIARItem[] getItems() {
            return this.items;
        }

        public Object getInfoObjects() {
            return this.infoObjects;
        }

        public IEnterpriseFunctionsV115 getHelper() {
            return this.helper;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                this.helper = (IEnterpriseFunctionsV115)EnterpriseFunctionAccessor.getInstance((int)this.connInfo.getVersion());
                BIARRecord bIARRecord = this.helper.importBIAR(this.connInfo, this.filePath, EnterpriseUtilities.getCuidForId((ConnectionInfo)this.connInfo, (int)this.serverId));
                this.items = bIARRecord.getItems();
                this.infoObjects = bIARRecord.getInfoObjects();
                return Status.OK_STATUS;
            }
            catch (ConnectionException connectionException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                return Status.CANCEL_STATUS;
            }
        }

        public boolean belongsTo(Object object) {
            return ImportFromBIARContextAction.FAMILY.equals(object);
        }
    }

    private static class CommitBIARJob
    extends Job {
        private ConnectionInfo connInfo;
        private IEnterpriseFunctionsV115 helper;
        private Object infoObjects;

        public CommitBIARJob(String string, ConnectionInfo connectionInfo, IEnterpriseFunctionsV115 iEnterpriseFunctionsV115, Object object) {
            super(string);
            this.connInfo = connectionInfo;
            this.helper = iEnterpriseFunctionsV115;
            this.infoObjects = object;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                this.helper.commitImportedItems(this.connInfo, this.infoObjects);
                return Status.OK_STATUS;
            }
            catch (ConnectionException connectionException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                return Status.CANCEL_STATUS;
            }
        }
    }
}

