/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.sdkconnection.IEnterpriseFunctionsV115;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.view.actions.IEnterpriseViewAction;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.ExportBIARWizard;
import com.businessobjects.integration.rad.enterprise.view.model.BOEObjectsTreeParent;
import com.businessobjects.integration.rad.enterprise.view.model.RootParent;
import com.businessobjects.integration.rad.enterprise.view.model.ServerParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportToBIARContextAction
extends Action
implements IEnterpriseViewAction {
    private static final String GET_ID_FAMILY = "GET_IDS";
    private IStructuredSelection selection;

    @Override
    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
        this.setEnabled(this.isEnabledBasedOnState());
    }

    private boolean isEnabledBasedOnState() {
        if (this.selection != null && this.selection.size() > 0) {
            TreeObject treeObject = (TreeObject)this.selection.getFirstElement();
            ConnectionInfo connectionInfo = treeObject.getConnInfo();
            boolean bl = connectionInfo != null && connectionInfo.isConnected();
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = false;
            Iterator iterator = this.selection.iterator();
            int n = -1;
            int n2 = -1;
            while (iterator.hasNext()) {
                TreeObject treeObject2 = (TreeObject)iterator.next();
                ConnectionInfo connectionInfo2 = treeObject2.getConnInfo();
                if (treeObject2 instanceof RootParent) {
                    bl2 = false;
                    break;
                }
                if (connectionInfo2.getId() != connectionInfo.getId()) {
                    bl3 = false;
                    break;
                }
                if (!connectionInfo2.isConnected()) {
                    bl4 = false;
                } else {
                    try {
                        if (n == -1) {
                            n = treeObject2.getConnInfo().getFavoritesFolder();
                        }
                        if (n2 == -1) {
                            n2 = EnterpriseFunctionAccessor.getInstance((int)connectionInfo2.getVersion()).getUsersFolder(connectionInfo2);
                        }
                        bl4 = !ExportToBIARContextAction.isContainerInFavorites(n, n2, treeObject2) && !(treeObject2 instanceof ServerParent);
                    }
                    catch (ConnectionException connectionException) {
                        LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                        bl4 = false;
                    }
                }
                if (bl4) continue;
                break;
            }
            boolean bl5 = connectionInfo != null && connectionInfo.getVersion() >= 1150;
            return bl2 && bl && bl5 && bl3 && bl4;
        }
        return false;
    }

    public void run() {
        GetIdsJob getIdsJob = new GetIdsJob();
        IJobManager iJobManager = Job.getJobManager();
        try {
            getIdsJob.schedule();
            iJobManager.join((Object)GET_ID_FAMILY, null);
            ExportBIARWizard exportBIARWizard = new ExportBIARWizard();
            WizardDialog wizardDialog = new WizardDialog(UIUtilities.getShell(), (IWizard)exportBIARWizard);
            wizardDialog.setPageSize(450, 300);
            if (wizardDialog.open() == 0) {
                ExportBIARJob exportBIARJob = new ExportBIARJob(exportBIARWizard, getIdsJob.getIds(), getIdsJob.getConnInfo());
                exportBIARJob.schedule();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)operationCanceledException));
        }
        catch (InterruptedException interruptedException) {
            LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", (Exception)interruptedException);
        }
    }

    @Override
    public boolean isVisible() {
        return this.isEnabled();
    }

    private static boolean isContainerInFavorites(int n, int n2, TreeObject treeObject) {
        if (treeObject instanceof RootParent || treeObject == null) {
            return false;
        }
        if (treeObject.getId() == n || treeObject.getId() == n2) {
            return true;
        }
        return ExportToBIARContextAction.isContainerInFavorites(n, n2, treeObject.getParent());
    }

    private class GetIdsJob
    extends Job {
        private List<String> ids;
        private ConnectionInfo connInfo;

        public GetIdsJob() {
            super(NLSResourceManager.export_biar_get_id_job_name);
            this.ids = new ArrayList<String>();
            this.connInfo = null;
        }

        public List getIds() {
            return this.ids;
        }

        public ConnectionInfo getConnInfo() {
            return this.connInfo;
        }

        private void getChildrenRecursively(ConnectionInfo connectionInfo, int n, List<String> list) throws ConnectionException {
            if (connectionInfo != null) {
                List list2 = EnterpriseFunctionAccessor.getInstance((int)connectionInfo.getVersion()).query(connectionInfo, "SELECT SI_ID, SI_OBJECT_IS_CONTAINER FROM CI_INFOOBJECTS, CI_APPOBJECTS, CI_SYSTEMOBJECTS WHERE SI_PARENTID=" + n);
                for (Map map : list2) {
                    Integer n2 = (Integer)map.get("SI_ID");
                    Boolean bl = (Boolean)map.get("SI_OBJECT_IS_CONTAINER");
                    if (n2 != null) {
                        list.add(n2.toString());
                    }
                    if (!bl.booleanValue()) continue;
                    this.getChildrenRecursively(connectionInfo, n2, list);
                }
            }
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            for (TreeObject treeObject : ExportToBIARContextAction.this.selection) {
                if (this.connInfo == null) {
                    this.connInfo = treeObject.getConnInfo();
                } else {
                    if (treeObject.getConnInfo() == null) continue;
                    if (this.connInfo.getId() != treeObject.getConnInfo().getId()) {
                        MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.export_biar_diff_server_title, (String)NLSResourceManager.export_biar_diff_server_message);
                        return Status.CANCEL_STATUS;
                    }
                }
                this.ids.add(String.valueOf(treeObject.getId()));
                if (!(treeObject instanceof BOEObjectsTreeParent)) continue;
                try {
                    this.getChildrenRecursively(this.connInfo, treeObject.getId(), this.ids);
                }
                catch (ConnectionException connectionException) {
                    LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                }
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object object) {
            return ExportToBIARContextAction.GET_ID_FAMILY.equals(object);
        }
    }

    private class ExportBIARJob
    extends Job {
        private ExportBIARWizard wizard;
        private List ids;
        private ConnectionInfo connInfo;

        public ExportBIARJob(ExportBIARWizard exportBIARWizard, List list, ConnectionInfo connectionInfo) {
            super(NLSResourceManager.export_biar_job_name);
            this.wizard = exportBIARWizard;
            this.ids = list;
            this.connInfo = connectionInfo;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                IEnterpriseFunctionsV115 iEnterpriseFunctionsV115 = (IEnterpriseFunctionsV115)EnterpriseFunctionAccessor.getInstance((int)this.connInfo.getVersion());
                iEnterpriseFunctionsV115.exportBIAR(this.connInfo, this.ids, this.wizard.getFilePath(), this.wizard.isExportDeps(), this.wizard.isExportUsers(), this.wizard.isExportGroups(), this.wizard.isExportCategories(), this.wizard.isExportCalendars(), this.wizard.isExportEvents());
                return Status.OK_STATUS;
            }
            catch (ConnectionException connectionException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                return Status.CANCEL_STATUS;
            }
        }
    }
}

