/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.filesystem.FileSystemManager;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.enterprise.objects.AbstractObjectHandler;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.actions.ImportFromBIARContextAction;
import com.businessobjects.integration.rad.enterprise.view.model.RootParent;
import com.businessobjects.integration.rad.enterprise.view.model.ServerParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;

public class BIARObjectHandler
extends AbstractObjectHandler {
    public boolean isPublishable(ConnectionInfo connectionInfo, int n) {
        if (connectionInfo != null && connectionInfo.isConnected() && connectionInfo.getVersion() >= 1150) {
            return n >= 0;
        }
        return false;
    }

    public List<Integer> publish(ConnectionInfo connectionInfo, Map map, List list) throws ConnectionException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry entry : map.entrySet()) {
            List list2 = (List)entry.getValue();
            block4: for (File file : list2) {
                EnterpriseView enterpriseView;
                if (!file.exists() || !"biar".equals(FileSystemManager.getFileExtension((String)file.getName())) || (enterpriseView = EnterpriseView.getView()) == null) continue;
                RootParent rootParent = (RootParent)enterpriseView.getRoot();
                TreeObject[] treeObjectArray = rootParent.getChildren();
                for (int i = 0; i < treeObjectArray.length; ++i) {
                    if (connectionInfo.getId() != treeObjectArray[i].getConnInfo().getId()) continue;
                    try {
                        ImportFromBIARContextAction.importBIAR(connectionInfo, file.getAbsolutePath(), (ServerParent)treeObjectArray[i]);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)operationCanceledException));
                    }
                    catch (InterruptedException interruptedException) {
                        LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", (Exception)interruptedException);
                    }
                    continue block4;
                }
            }
        }
        arrayList.add(new Integer(0));
        return arrayList;
    }
}

