/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view;

import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfoManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionStore;
import com.businessobjects.integration.rad.enterprise.sdkconnection.IConnectionStore;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ServerPropertySource
implements IPropertySource {
    private static final String VERSION_PROP = "connInfo.version";
    private static final String CMC_LOCATION_PROP = "connInfo.CMC";
    private static final String INFOVIEW_LOCATION_PROP = "connInfo.infoView";
    private static final String ADMIN_LAUNCH_LOCATION_PROP = "connInfo.adminlaunch";
    private static final String QUERY_BUILDER_LOCATION_PROP = "querybuilder.adminlaunch";
    private ConnectionInfo connInfo;

    public ServerPropertySource(ConnectionInfo connectionInfo) {
        this.connInfo = connectionInfo;
    }

    public Object getEditableValue() {
        return "";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[5];
        propertyDescriptorArray[0] = new PropertyDescriptor((Object)VERSION_PROP, ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.VERSION));
        TextPropertyDescriptor textPropertyDescriptor = new TextPropertyDescriptor((Object)CMC_LOCATION_PROP, NLSResourceManager.cmc_location);
        textPropertyDescriptor.setValidator((ICellEditorValidator)new URLCellEditorValidator());
        propertyDescriptorArray[1] = textPropertyDescriptor;
        propertyDescriptorArray[1].setCategory(NLSResourceManager.resources);
        TextPropertyDescriptor textPropertyDescriptor2 = new TextPropertyDescriptor((Object)INFOVIEW_LOCATION_PROP, NLSResourceManager.infoview_location);
        textPropertyDescriptor2.setValidator((ICellEditorValidator)new URLCellEditorValidator());
        propertyDescriptorArray[2] = textPropertyDescriptor2;
        propertyDescriptorArray[2].setCategory(NLSResourceManager.resources);
        TextPropertyDescriptor textPropertyDescriptor3 = new TextPropertyDescriptor((Object)ADMIN_LAUNCH_LOCATION_PROP, NLSResourceManager.adminlaunch_location);
        textPropertyDescriptor3.setValidator((ICellEditorValidator)new URLCellEditorValidator());
        propertyDescriptorArray[3] = textPropertyDescriptor3;
        propertyDescriptorArray[3].setCategory(NLSResourceManager.resources);
        TextPropertyDescriptor textPropertyDescriptor4 = new TextPropertyDescriptor((Object)QUERY_BUILDER_LOCATION_PROP, NLSResourceManager.querybuilder_location);
        textPropertyDescriptor4.setValidator((ICellEditorValidator)new URLCellEditorValidator());
        propertyDescriptorArray[4] = textPropertyDescriptor4;
        propertyDescriptorArray[4].setCategory(NLSResourceManager.resources);
        return propertyDescriptorArray;
    }

    public Object getPropertyValue(Object object) {
        if (object.equals(VERSION_PROP)) {
            return new StringBuffer().append(this.connInfo.getVersion() / 100).append('.').append(this.connInfo.getVersion() % 100 / 10).append('.').append(this.connInfo.getVersion() % 10);
        }
        if (object.equals(INFOVIEW_LOCATION_PROP)) {
            return this.connInfo.getInfoViewLocation();
        }
        if (object.equals(CMC_LOCATION_PROP)) {
            return this.connInfo.getCMCLocation();
        }
        if (object.equals(ADMIN_LAUNCH_LOCATION_PROP)) {
            return this.connInfo.getAdminLaunchpadLocation();
        }
        if (object.equals(QUERY_BUILDER_LOCATION_PROP)) {
            return this.connInfo.getQueryBuilderLocation();
        }
        return null;
    }

    public boolean isPropertySet(Object object) {
        return true;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
        if (this.isPropertyEditable((String)object) && object2 instanceof String) {
            String string = (String)object2;
            if (INFOVIEW_LOCATION_PROP.equals(object)) {
                this.connInfo.setInfoViewLocation(string);
            } else if (CMC_LOCATION_PROP.equals(object)) {
                this.connInfo.setCMCLocation(string);
            } else if (ADMIN_LAUNCH_LOCATION_PROP.equals(object)) {
                this.connInfo.setAdminLaunchpadLocation(string);
            } else if (QUERY_BUILDER_LOCATION_PROP.equals(object)) {
                this.connInfo.setQueryBuilderLocation(string);
            }
            ConnectionInfoManager.getInstance().saveConnection((IConnectionStore)ConnectionStore.getInstance(), this.connInfo);
        }
    }

    private boolean isPropertyEditable(String string) {
        return INFOVIEW_LOCATION_PROP.equals(string) || CMC_LOCATION_PROP.equals(string) || ADMIN_LAUNCH_LOCATION_PROP.equals(string) || QUERY_BUILDER_LOCATION_PROP.equals(string);
    }

    static class URLCellEditorValidator
    implements ICellEditorValidator {
        URLCellEditorValidator() {
        }

        public String isValid(Object object) {
            if (object instanceof String) {
                String string = (String)object;
                if (string.trim().length() == 0) {
                    return "";
                }
                try {
                    new URL(string);
                    return null;
                }
                catch (MalformedURLException malformedURLException) {
                    return malformedURLException.getLocalizedMessage();
                }
            }
            return "";
        }
    }
}

