/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class PropertySource
implements IPropertySource {
    private Map<Object, Object> props;
    private String category;
    private TreeObject treeObject;
    private ConnectionInfo connInfo;
    private int id;
    private static final String[] EDITABLE_PROPERTIES = new String[]{"SI_NAME", "SI_DESCRIPTION", "SI_KEYWORD"};
    private static final String[] BASIC_PROPERTIES = new String[]{"SI_NAME", "SI_DESCRIPTION", "SI_KEYWORD", "SI_ID", "SI_CUID", "SI_KIND", "SI_OWNER", "SI_CREATION_TIME", "SI_UPDATE_TS", "SI_LAST_RUN_TIME"};

    public PropertySource(ConnectionInfo connectionInfo, int n, Map<Object, Object> map, String string) {
        this.connInfo = connectionInfo;
        this.id = n;
        this.props = map;
        if (!map.keySet().contains("SI_KEYWORD")) {
            map.put("SI_KEYWORD", "");
        }
        if (string == null) {
            string = NLSResourceManager.property_category_name;
        }
        this.category = string;
        Arrays.sort(EDITABLE_PROPERTIES);
        Arrays.sort(BASIC_PROPERTIES);
    }

    public PropertySource(TreeObject treeObject, Map map, String string) {
        this(treeObject.getConnInfo(), treeObject.getId(), map, string);
        this.treeObject = treeObject;
    }

    public Map<Object, Object> getProps() {
        return new HashMap<Object, Object>(this.props);
    }

    public Object getEditableValue() {
        return "";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> arrayList = new ArrayList<IPropertyDescriptor>();
        this.populatePropertyDescriptor(this.props, arrayList, this.category);
        return arrayList.toArray(new IPropertyDescriptor[arrayList.size()]);
    }

    public Object getPropertyValue(Object object) {
        Object object2 = this.props.get(object);
        if (object2 instanceof Map) {
            object2 = this.treeObject == null ? new PropertySource(this.connInfo, this.id, (Map)object2, this.category) : new PropertySource(this.treeObject, (Map)object2, this.category);
        }
        return object2;
    }

    public boolean isPropertySet(Object object) {
        return true;
    }

    public void resetPropertyValue(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyValue(Object object, Object object2) {
        block10: {
            if (this.isPropertyEditable((String)object) && object2 instanceof String) {
                try {
                    EnterpriseView enterpriseView;
                    EnterpriseFunctionAccessor.getInstance((int)this.connInfo.getVersion()).setProperty(this.connInfo, this.id, (String)object, (Object)((String)object2));
                    TreeParent treeParent = null;
                    if (this.treeObject != null) {
                        treeParent = this.treeObject.getParent();
                    } else if (this.treeObject == null && (enterpriseView = EnterpriseView.getView()) != null) {
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        arrayList.add(new Integer(this.id));
                        List<TreeObject> list = enterpriseView.getHelper().findItemsInView(this.connInfo, arrayList, true);
                        if (list.size() == 1) {
                            treeParent = list.get(0).getParent();
                        }
                    }
                    enterpriseView = EnterpriseView.getView();
                    if (enterpriseView == null || treeParent == null) break block10;
                    try {
                        enterpriseView.getViewer().getControl().getShell().setCursor(UIUtilities.getDisplay().getSystemCursor(1));
                        enterpriseView.getViewer().refresh((Object)treeParent);
                        this.props.put(object, object2);
                    }
                    finally {
                        enterpriseView.getViewer().getControl().getShell().setCursor(null);
                    }
                }
                catch (ConnectionException connectionException) {
                    LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                }
            }
        }
    }

    private void populatePropertyDescriptor(Map map, List<IPropertyDescriptor> list, String string) {
        for (Map.Entry entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            Object object = this.isPropertyEditable(string2) ? new TextPropertyDescriptor((Object)string2, string2) : new PropertyDescriptor((Object)string2, string2);
            if (!this.isPropertyBasic(string2)) {
                object.setFilterFlags(new String[]{"org.eclipse.ui.views.properties.expert"});
            }
            object.setCategory(string);
            list.add((IPropertyDescriptor)object);
        }
    }

    private boolean isPropertyEditable(String string) {
        boolean bl = true;
        if (this.treeObject != null) {
            bl = !this.treeObject.isReadOnly();
        }
        return Arrays.binarySearch(EDITABLE_PROPERTIES, string) >= 0 && bl;
    }

    private boolean isPropertyBasic(String string) {
        return Arrays.binarySearch(BASIC_PROPERTIES, string) >= 0;
    }
}

