/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view;

import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.enterprise.editormanager.EnterpriseEditorInputManager;
import com.businessobjects.integration.rad.enterprise.objects.ObjectTypeManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseViewHelper;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseViewPlugin;
import com.businessobjects.integration.rad.enterprise.view.actions.ActionsManager;
import com.businessobjects.integration.rad.enterprise.view.actions.CopyToClipboardAction;
import com.businessobjects.integration.rad.enterprise.view.actions.CutToClipboardAction;
import com.businessobjects.integration.rad.enterprise.view.actions.DeleteFromClipboardAction;
import com.businessobjects.integration.rad.enterprise.view.actions.FiltersAction;
import com.businessobjects.integration.rad.enterprise.view.actions.OpenAction;
import com.businessobjects.integration.rad.enterprise.view.actions.OpenContextAction;
import com.businessobjects.integration.rad.enterprise.view.actions.OpenWithContextAction;
import com.businessobjects.integration.rad.enterprise.view.actions.PasteFromClipboardAction;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.ContentTypeFilter;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.EnterpriseViewActionContribution;
import com.businessobjects.integration.rad.enterprise.view.dnd.TreeObjectDragListener;
import com.businessobjects.integration.rad.enterprise.view.dnd.TreeObjectDropListener;
import com.businessobjects.integration.rad.enterprise.view.dnd.TreeObjectTransfer;
import com.businessobjects.integration.rad.enterprise.view.model.InvisibleRootParent;
import com.businessobjects.integration.rad.enterprise.view.model.RootParent;
import com.businessobjects.integration.rad.enterprise.view.model.ServerParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import com.businessobjects.integration.rad.enterprise.view.model.ViewContentProvider;
import com.businessobjects.integration.rad.enterprise.view.model.ViewLabelProvider;
import com.businessobjects.integration.rad.enterprise.view.workingset.WorkingSetFilter;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class EnterpriseView
extends ViewPart {
    public static final String VIEW_ID = "com.businessobjects.integration.rad.enterprise.view.EnterpriseView";
    private static final String FILTERED_CONTENT_TYPES = "EnterpriseViewWorkingSetFilter.STORE_FILTER";
    private static final String FILTER_MEMENTO_KEY_PROG_ID = "progId";
    private static final String STORE_WORKING_SET = "EnterpriseViewWorkingSetFilter.STORE_WORKING_SET";
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private IDialogSettings settings;
    protected WorkingSetFilterActionGroup workingSetGroup;
    private WorkingSetFilter workingSetFilter = new WorkingSetFilter();
    private ContentTypeFilter contentFilter = new ContentTypeFilter();
    protected Action viewOpenAction;
    private Action deleteFromClipboardAction = new DeleteFromClipboardAction();
    private PasteFromClipboardAction pasteFromClipboardAction = new PasteFromClipboardAction();
    private Action copyToClipboardAction;
    private Action cutToClipboardAction;
    private EnterpriseViewHelper helper = new EnterpriseViewHelper(this);
    private RootParent root;

    public static EnterpriseView getView() {
        EnterpriseView enterpriseView = null;
        IWorkbenchPage iWorkbenchPage = UIUtilities.getActivePage();
        if (iWorkbenchPage != null) {
            enterpriseView = (EnterpriseView)iWorkbenchPage.findView(VIEW_ID);
        }
        return enterpriseView;
    }

    public EnterpriseViewHelper getHelper() {
        return this.helper;
    }

    public TreeParent getRoot() {
        return this.root;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public ContentTypeFilter getContentFilter() {
        return this.contentFilter;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IPropertySheetPage.class)) {
            return new PropertySheetPage();
        }
        return super.getAdapter(clazz);
    }

    public void refreshServerInUI(ConnectionInfo connectionInfo) {
        TreeObject[] treeObjectArray = this.root.getChildren();
        for (int i = 0; i < treeObjectArray.length; ++i) {
            if (!connectionInfo.equals((Object)treeObjectArray[i].getConnInfo())) continue;
            ServerParent serverParent = (ServerParent)treeObjectArray[i];
            this.viewer.refresh((Object)serverParent, true);
        }
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        if (iMemento != null) {
            IMemento[] iMementoArray = iMemento.getChildren(FILTERED_CONTENT_TYPES);
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < iMementoArray.length; ++i) {
                String string = iMementoArray[i].getString(FILTER_MEMENTO_KEY_PROG_ID);
                if (string == null) continue;
                hashSet.add(string);
            }
            this.contentFilter.setAllowedContentType(hashSet);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(ObjectTypeManager.getFilterableProgIds());
            hashSet.add("OTHERS");
            this.contentFilter.setAllowedContentType(hashSet);
        }
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        Set set = this.contentFilter.getAllowedContentType();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IMemento iMemento2 = iMemento.createChild(FILTERED_CONTENT_TYPES);
                String string = (String)iterator.next();
                iMemento2.putString(FILTER_MEMENTO_KEY_PROG_ID, string);
                iMemento.putMemento(iMemento2);
            }
        }
    }

    public void createPartControl(Composite composite) {
        this.settings = EnterpriseViewPlugin.getDefault().getDialogSettings();
        this.viewer = new TreeViewer(composite, 268436226);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp(this.viewer.getControl(), "com.businessobjects.integration.rad.enterprise.view.docroot");
        }
        this.root = new RootParent();
        InvisibleRootParent invisibleRootParent = new InvisibleRootParent(this.root);
        this.viewer.setUseHashlookup(true);
        this.viewer.setInput((Object)invisibleRootParent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                EnterpriseView.this.pasteFromClipboardAction.setEnabled(EnterpriseView.this.pasteFromClipboardAction.isEnabled());
                EnterpriseView.this.deleteFromClipboardAction.setEnabled(EnterpriseView.this.deleteFromClipboardAction.isEnabled());
                EnterpriseView.this.copyToClipboardAction.setEnabled(EnterpriseView.this.copyToClipboardAction.isEnabled());
                EnterpriseView.this.cutToClipboardAction.setEnabled(EnterpriseView.this.cutToClipboardAction.isEnabled());
            }
        });
        this.viewer.addFilter((ViewerFilter)this.workingSetFilter);
        this.viewer.addFilter((ViewerFilter)this.contentFilter);
        this.hookWorkingSet();
        this.makeActions();
        this.hookTooltips();
        this.hookContextMenu();
        this.hookOpenListener();
        this.hookDragDropAction();
        this.contributeToActionBars();
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteFromClipboardAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteFromClipboardAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyToClipboardAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutToClipboardAction);
    }

    private void hookWorkingSet() {
        IWorkingSetManager iWorkingSetManager;
        IWorkingSet iWorkingSet;
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if ("changeWorkingSet".equals(string)) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof IWorkingSet) {
                        EnterpriseView.this.setWorkingSet((IWorkingSet)object);
                    } else if (object == null) {
                        EnterpriseView.this.setWorkingSet(null);
                    }
                }
            }
        };
        this.workingSetGroup = new WorkingSetFilterActionGroup(UIUtilities.getShell(), iPropertyChangeListener);
        String string = this.settings.get(STORE_WORKING_SET);
        if (string != null && !string.equals("") && (iWorkingSet = (iWorkingSetManager = EnterpriseViewPlugin.getDefault().getWorkbench().getWorkingSetManager()).getWorkingSet(string)) != null) {
            this.workingSetFilter.setWorkingSet(iWorkingSet);
            this.workingSetGroup.setWorkingSet(iWorkingSet);
        }
    }

    private void hookDragDropAction() {
        int n = 7;
        Transfer[] transferArray = new Transfer[]{TreeObjectTransfer.getInstance()};
        this.viewer.addDragSupport(n, transferArray, (DragSourceListener)new TreeObjectDragListener((StructuredViewer)this.viewer));
        transferArray = new Transfer[]{LocalSelectionTransfer.getTransfer(), TreeObjectTransfer.getInstance(), FileTransfer.getInstance(), ResourceTransfer.getInstance()};
        TreeObjectDropListener treeObjectDropListener = new TreeObjectDropListener(this.viewer);
        this.viewer.addDropSupport(n, transferArray, (DropTargetListener)treeObjectDropListener);
    }

    private void hookTooltips() {
        UIUtilities.hookTooltips((Tree)this.viewer.getTree());
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)EnterpriseView.this.viewer.getSelection();
                ActionsManager.setSelection(iStructuredSelection);
                EnterpriseView.this.fillContextMenu(iMenuManager, iStructuredSelection);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.getMenuManager().add((IContributionItem)new Separator());
        iActionBars.getMenuManager().add((IAction)new FiltersAction(this));
        iActionBars.getMenuManager().add((IContributionItem)new Separator());
        this.workingSetGroup.fillActionBars(iActionBars);
        iActionBars.getMenuManager().add((IContributionItem)new Separator());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        for (EnterpriseViewActionContribution enterpriseViewActionContribution : ActionsManager.getContextMenuActions()) {
            Object object;
            Object object2;
            boolean bl = true;
            if (enterpriseViewActionContribution.getAction() != null) {
                bl = enterpriseViewActionContribution.getAction().isVisible();
            }
            if (!bl) continue;
            if (enterpriseViewActionContribution.isSeparator()) {
                if (enterpriseViewActionContribution.getPath() == null) {
                    iMenuManager.add((IContributionItem)new Separator());
                    continue;
                }
                iMenuManager.add((IContributionItem)new Separator(enterpriseViewActionContribution.getPath()));
                continue;
            }
            if (enterpriseViewActionContribution.isMenu()) {
                object2 = enterpriseViewActionContribution.getName();
                object = enterpriseViewActionContribution.getPath();
                iMenuManager.add((IContributionItem)new MenuManager((String)object2, (String)object));
                continue;
            }
            if (enterpriseViewActionContribution.getAction() instanceof OpenWithContextAction) {
                object2 = (OpenWithContextAction)enterpriseViewActionContribution.getAction();
                if (!object2.isEnabled()) continue;
                object = (TreeObject)iStructuredSelection.getFirstElement();
                String[] stringArray = EnterpriseEditorInputManager.getInstance().getEditorIds(((TreeObject)object).getProgId());
                String string = EnterpriseEditorInputManager.getInstance().getPreferredEditor(((TreeObject)object).getProgId());
                for (int i = 0; i < stringArray.length; ++i) {
                    IMenuManager iMenuManager2;
                    OpenAction openAction = new OpenAction(stringArray[i]);
                    openAction.setText(EnterpriseEditorInputManager.getInstance().getName(stringArray[i]));
                    if (stringArray[i].equals(string)) {
                        openAction.setImageDescriptor(EnterpriseViewPlugin.getImageDescriptor("icons/dot.gif"));
                    }
                    if ((iMenuManager2 = iMenuManager.findMenuUsingPath(enterpriseViewActionContribution.getPath())) == null) continue;
                    iMenuManager2.add((IAction)openAction);
                }
                continue;
            }
            if (enterpriseViewActionContribution.getPath() == null) {
                iMenuManager.add((IAction)enterpriseViewActionContribution.getAction());
                continue;
            }
            object2 = iMenuManager.findMenuUsingPath(enterpriseViewActionContribution.getPath());
            if (object2 == null) continue;
            object2.add((IAction)enterpriseViewActionContribution.getAction());
        }
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.cutToClipboardAction);
        iMenuManager.add((IAction)this.copyToClipboardAction);
        iMenuManager.add((IAction)this.pasteFromClipboardAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.deleteFromClipboardAction);
        iMenuManager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator());
        for (EnterpriseViewActionContribution enterpriseViewActionContribution : ActionsManager.getToolbarActions()) {
            boolean bl = true;
            if (enterpriseViewActionContribution.getAction() != null) {
                bl = enterpriseViewActionContribution.getAction().isVisible();
            }
            if (!bl) continue;
            if (enterpriseViewActionContribution.isSeparator()) {
                if (enterpriseViewActionContribution.getPath() != null) {
                    iToolBarManager.add((IContributionItem)new Separator(enterpriseViewActionContribution.getPath()));
                    continue;
                }
                iToolBarManager.add((IAction)enterpriseViewActionContribution.getAction());
                continue;
            }
            if (enterpriseViewActionContribution.getPath() != null) {
                iToolBarManager.appendToGroup(enterpriseViewActionContribution.getPath(), (IAction)enterpriseViewActionContribution.getAction());
                continue;
            }
            iToolBarManager.add((IAction)enterpriseViewActionContribution.getAction());
        }
        iToolBarManager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(iToolBarManager);
    }

    private void makeActions() {
        this.viewOpenAction = new ViewOpenAction();
        this.deleteFromClipboardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteFromClipboardAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteFromClipboardAction.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.DELETE));
        this.pasteFromClipboardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteFromClipboardAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteFromClipboardAction.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.PASTE));
        this.copyToClipboardAction = new CopyToClipboardAction(this.pasteFromClipboardAction);
        this.copyToClipboardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.copyToClipboardAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyToClipboardAction.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.COPY));
        this.cutToClipboardAction = new CutToClipboardAction(this.pasteFromClipboardAction);
        this.cutToClipboardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        this.cutToClipboardAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.cutToClipboardAction.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.CUT));
    }

    public void setWorkingSetUI(IWorkingSet iWorkingSet) {
        this.workingSetFilter.setWorkingSet(iWorkingSet);
        this.workingSetGroup.setWorkingSet(iWorkingSet);
        this.setWorkingSet(iWorkingSet);
    }

    private void setWorkingSet(IWorkingSet iWorkingSet) {
        TreeViewer treeViewer = this.getViewer();
        Object[] objectArray = treeViewer.getExpandedElements();
        ISelection iSelection = treeViewer.getSelection();
        this.workingSetFilter.setWorkingSet(iWorkingSet);
        if (iWorkingSet != null) {
            this.settings.put(STORE_WORKING_SET, iWorkingSet.getName());
        } else {
            this.settings.put(STORE_WORKING_SET, "");
        }
        treeViewer.refresh();
        treeViewer.setExpandedElements(objectArray);
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            treeViewer.reveal(iStructuredSelection.getFirstElement());
        }
    }

    private void hookOpenListener() {
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                EnterpriseView.this.viewOpenAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.workingSetGroup.dispose();
    }

    class ViewOpenAction
    extends Action {
        ViewOpenAction() {
        }

        public void run() {
            ISelection iSelection = EnterpriseView.this.viewer.getSelection();
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object instanceof TreeParent) {
                boolean bl = EnterpriseView.this.viewer.getExpandedState(object);
                if (bl) {
                    EnterpriseView.this.viewer.collapseToLevel(object, 1);
                } else {
                    EnterpriseView.this.viewer.expandToLevel(object, 1);
                }
            } else {
                OpenContextAction openContextAction = new OpenContextAction();
                openContextAction.setSelection((IStructuredSelection)iSelection);
                if (openContextAction.isEnabled()) {
                    openContextAction.run();
                }
            }
        }
    }
}

