/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.shared;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboFieldEditor
extends FieldEditor {
    private Combo m_combo;
    private String m_value;
    private String[][] m_entryNamesAndValues;

    public ComboFieldEditor(String string, String string2, String[][] stringArray, Composite composite) {
        this.init(string, string2);
        if (!this.checkArray(stringArray)) {
            throw new UnsupportedOperationException();
        }
        this.m_entryNamesAndValues = stringArray;
        this.createControl(composite);
    }

    private boolean checkArray(String[][] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            if (stringArray2 == null || stringArray2.length != 2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void adjustForNumColumns(int n) {
        if (n > 1) {
            Label label = this.getLabelControl();
            int n2 = n;
            if (label != null) {
                ((GridData)label.getLayoutData()).horizontalSpan = 1;
                --n2;
            }
            ((GridData)this.m_combo.getLayoutData()).horizontalSpan = n2;
        } else {
            Label label = this.getLabelControl();
            if (label != null) {
                ((GridData)label.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.m_combo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        int n2 = 1;
        if (n > 1) {
            n2 = n - 1;
        }
        Label label = this.getLabelControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = this.getComboBoxControl(composite);
        gridData = new GridData();
        gridData.horizontalSpan = n2;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        label.setFont(composite.getFont());
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.m_value == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.m_value);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboBoxControl(Composite composite) {
        if (this.m_combo == null) {
            this.m_combo = new Combo(composite, 8);
            this.m_combo.setFont(composite.getFont());
            int n = 0;
            while (n < this.m_entryNamesAndValues.length) {
                this.m_combo.add(this.m_entryNamesAndValues[n][0], n);
                ++n;
            }
            this.m_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = ComboFieldEditor.this.m_value;
                    String string2 = ComboFieldEditor.this.m_combo.getText();
                    ComboFieldEditor.this.m_value = ComboFieldEditor.this.getValueForName(string2);
                    ComboFieldEditor.this.setPresentsDefaultValue(false);
                    ComboFieldEditor.this.fireValueChanged("field_editor_value", string, ComboFieldEditor.this.m_value);
                }
            });
        }
        return this.m_combo;
    }

    protected String getValueForName(String string) {
        int n = 0;
        while (n < this.m_entryNamesAndValues.length) {
            String[] stringArray = this.m_entryNamesAndValues[n];
            if (string.equals(stringArray[0])) {
                return stringArray[1];
            }
            ++n;
        }
        return this.m_entryNamesAndValues[0][0];
    }

    protected void updateComboForValue(String string) {
        this.m_value = string;
        int n = 0;
        while (n < this.m_entryNamesAndValues.length) {
            if (string.equals(this.m_entryNamesAndValues[n][1])) {
                this.m_combo.setText(this.m_entryNamesAndValues[n][0]);
                return;
            }
            ++n;
        }
        if (this.m_entryNamesAndValues.length > 0) {
            this.m_value = this.m_entryNamesAndValues[0][1];
        }
    }
}

