/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.eclipse.web.properties.properties;

import com.businessobjects.integration.capabilities.librarycomponents.model.Resource;
import com.businessobjects.integration.eclipse.web.properties.NLSResourceManager;
import com.businessobjects.integration.eclipse.web.properties.VersionComparator;
import com.businessobjects.integration.eclipse.web.properties.properties.VersionTableInput;
import com.businessobjects.integration.eclipse.web.properties.properties.VersionTableRecord;
import com.businessobjects.sdks.manager.RuntimeLibraryManager;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;

public class VersionTableContentProvider
implements IStructuredContentProvider {
    private static final String UNKNOWN = NLSResourceManager.library_versions_unknown;
    private static final String ADD = NLSResourceManager.library_versions_action_add;
    private static final String NONE = NLSResourceManager.library_versions_action_none;
    private static final String DELETE = NLSResourceManager.library_versions_action_delete;
    private static final String UPDATE = NLSResourceManager.library_versions_action_update;
    private static final String NOT_EXIST = NLSResourceManager.library_versions_not_exist;
    private static final String NOT_NEEDED = "--";
    private int sortField = 0;
    private boolean sortAscending = true;
    private Comparator comparator = new RecordComparator();
    private Object[] data = new Object[0];
    private File resourceLocation;
    private File libraryLocation;

    public Object[] getElements(Object object) {
        Arrays.sort(this.data, this.comparator);
        return this.data;
    }

    public void dispose() {
    }

    protected void setSorting(int n, boolean bl) {
        this.sortField = n;
        this.sortAscending = bl;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object2 instanceof VersionTableInput) {
            List list;
            VersionTableInput versionTableInput = (VersionTableInput)object2;
            String string = versionTableInput.getLibraryId();
            String string2 = versionTableInput.getTargetVersion();
            String string3 = versionTableInput.getProjectVersion();
            IResource iResource = versionTableInput.getProject().findMember("WebContent");
            if (iResource != null) {
                this.resourceLocation = iResource.getLocation().toFile();
                if (iResource instanceof IContainer && (list = ((IContainer)iResource).findMember(WebArtifactEdit.WEBLIB)) != null) {
                    this.libraryLocation = list.getLocation().toFile();
                }
            }
            if (string3 != null) {
                list = this.generateTable(string, string3, string2);
                this.data = list.toArray();
            }
        }
    }

    private static final boolean isNonNumericVersion(String string) {
        return NOT_EXIST.equals(string) || NOT_NEEDED.equals(string) || UNKNOWN.equals(string);
    }

    private List generateTable(String string, String string2, String string3) {
        Object object;
        String string4;
        String string5;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TreeSet treeSet = new TreeSet();
        TreeSet treeSet2 = new TreeSet();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        this.getLibraryInfo(string, string2, string3, treeSet, treeSet2, hashMap, hashMap2, hashMap3);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            object4 = (File)iterator.next();
            object3 = ((File)object4).getName();
            object2 = (File)hashMap.get(object3);
            if (object2 == null) {
                string5 = treeSet2.contains(object3) ? NONE : DELETE;
                string4 = VersionTableContentProvider.getJarFileVersion((File)object4);
                object = new VersionTableRecord((String)object3, string4, NOT_NEEDED, string5, string4.equals(NOT_EXIST));
            } else {
                hashMap.remove(object3);
                string5 = UPDATE;
                string4 = VersionTableContentProvider.getJarFileVersion((File)object4);
                String string6 = VersionTableContentProvider.getJarFileVersion((File)object2);
                if (!((File)object4).exists() && !((File)object2).exists()) {
                    string5 = NONE;
                } else if (!((File)object4).exists() || !((File)object2).exists()) {
                    string5 = ADD;
                } else if (string4.equals(string6) && !string6.equals(UNKNOWN) && !string4.equals(UNKNOWN)) {
                    string5 = NONE;
                }
                object = new VersionTableRecord((String)object3, string4, string6, string5, string4.equals(NOT_EXIST) || string6.equals(NOT_EXIST));
            }
            arrayList.add(object);
        }
        object4 = hashMap.entrySet().iterator();
        while (object4.hasNext()) {
            object3 = (Map.Entry)object4.next();
            object2 = (String)object3.getKey();
            object = (File)object3.getValue();
            string5 = VersionTableContentProvider.getJarFileVersion((File)object);
            arrayList.add(new VersionTableRecord((String)object2, NOT_NEEDED, string5, ADD, string5.equals(NOT_EXIST)));
        }
        object3 = hashMap2.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = null;
            if (hashMap3.keySet().contains(object2)) {
                string5 = NOT_EXIST;
                if (new File(this.resourceLocation, (String)object2).exists()) {
                    string5 = UNKNOWN;
                }
                string4 = NOT_EXIST;
                if (new File(((Resource)hashMap3.get(object2)).getSource()).exists()) {
                    string4 = UNKNOWN;
                }
                object = new VersionTableRecord((String)object2, string5, string4, UPDATE, NOT_EXIST.equals(string4) || NOT_EXIST.equals(string5));
                hashMap3.remove(object2);
            } else {
                string5 = NOT_EXIST;
                if (new File(this.resourceLocation, (String)object2).exists()) {
                    string5 = UNKNOWN;
                }
                object = new VersionTableRecord((String)object2, string5, NOT_NEEDED, DELETE, NOT_EXIST.equals(string5));
            }
            arrayList.add(object);
        }
        object2 = hashMap3.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            string5 = (Resource)hashMap3.get(object);
            string4 = NOT_EXIST;
            if (new File(string5.getSource()).exists()) {
                string4 = UNKNOWN;
            }
            arrayList.add(new VersionTableRecord((String)object, NOT_NEEDED, string4, ADD, NOT_EXIST.equals(string4)));
        }
        return arrayList;
    }

    private void getLibraryInfo(String string, String string2, String string3, Set set, Set set2, Map map, Map map2, Map map3) {
        String string4;
        String string5;
        List list = RuntimeLibraryManager.getInstance().getBusinessObjectsLibraries(string, string2);
        List list2 = RuntimeLibraryManager.getInstance().getExternalLibraries(string, string2);
        List list3 = RuntimeLibraryManager.getInstance().getResources(string, string2);
        List list4 = RuntimeLibraryManager.getInstance().getBusinessObjectsLibraries(string, string3);
        List list5 = RuntimeLibraryManager.getInstance().getExternalLibraries(string, string3);
        List list6 = RuntimeLibraryManager.getInstance().getResources(string, string3);
        int n = 0;
        while (n < list.size()) {
            String string6 = new File((String)list.get(n)).getName();
            set.add(new File(this.libraryLocation, string6));
            ++n;
        }
        int n2 = 0;
        while (n2 < list2.size()) {
            String string7 = new File((String)list2.get(n2)).getName();
            set.add(new File(this.libraryLocation, string7));
            set2.add(string7);
            ++n2;
        }
        int n3 = 0;
        while (n3 < list4.size()) {
            File file = new File((String)list4.get(n3));
            map.put(file.getName(), file);
            ++n3;
        }
        int n4 = 0;
        while (n4 < list5.size()) {
            File file = new File((String)list5.get(n4));
            map.put(file.getName(), file);
            ++n4;
        }
        int n5 = 0;
        while (n5 < list3.size()) {
            Resource resource = (Resource)list3.get(n5);
            string5 = resource.getTarget();
            string4 = string5.replace(File.separatorChar, '/');
            map2.put(string4, resource);
            ++n5;
        }
        int n6 = 0;
        while (n6 < list6.size()) {
            string5 = (Resource)list6.get(n6);
            string4 = string5.getTarget();
            map3.put(string4, string5);
            ++n6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getJarFileVersion(File file) {
        String string;
        block14: {
            JarFile jarFile;
            block13: {
                if (!file.exists()) {
                    return NOT_EXIST;
                }
                string = null;
                jarFile = null;
                jarFile = new JarFile(file);
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                string = (String)attributes.get(Attributes.Name.IMPLEMENTATION_VERSION);
                if (string != null) break block13;
                string = UNKNOWN;
                Map<String, Attributes> map = jarFile.getManifest().getEntries();
                Iterator<Attributes> iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    Attributes attributes2 = iterator.next();
                    if (!(attributes2 instanceof Attributes)) continue;
                    Attributes attributes3 = attributes2;
                    string = (String)attributes3.get(Attributes.Name.IMPLEMENTATION_VERSION);
                    if (string != null) break;
                    string = UNKNOWN;
                    break;
                }
            }
            Object var9_9 = null;
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
                break block14;
            }
            catch (Exception exception) {}
            break block14;
            {
                catch (Exception exception) {
                    string = UNKNOWN;
                    Object var9_10 = null;
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                        break block14;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string;
    }

    class RecordComparator
    implements Comparator {
        RecordComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof VersionTableRecord && object2 instanceof VersionTableRecord) {
                VersionTableRecord versionTableRecord = (VersionTableRecord)object;
                VersionTableRecord versionTableRecord2 = (VersionTableRecord)object2;
                int n = VersionTableContentProvider.this.sortAscending ? 1 : -1;
                Collator collator = Collator.getInstance(Locale.getDefault());
                collator.setStrength(0);
                switch (VersionTableContentProvider.this.sortField) {
                    case 0: {
                        return collator.compare(versionTableRecord.getPath(), versionTableRecord2.getPath()) * n;
                    }
                    case 1: {
                        return this.compareVersionString(versionTableRecord.getSourceVersion(), versionTableRecord2.getSourceVersion()) * n;
                    }
                    case 2: {
                        return this.compareVersionString(versionTableRecord.getTargetVersion(), versionTableRecord2.getTargetVersion()) * n;
                    }
                    case 3: {
                        return collator.compare(versionTableRecord.getAction(), versionTableRecord2.getAction()) * n;
                    }
                }
            }
            return 0;
        }

        private int compareVersionString(String string, String string2) {
            if (VersionTableContentProvider.isNonNumericVersion(string) && VersionTableContentProvider.isNonNumericVersion(string2)) {
                if (NOT_EXIST.equals(string)) {
                    if (NOT_EXIST.equals(string2)) {
                        return 0;
                    }
                    return -1;
                }
                if (NOT_EXIST.equals(string2)) {
                    if (NOT_EXIST.equals(string)) {
                        return 0;
                    }
                    return 1;
                }
                if (UNKNOWN.equals(string2)) {
                    if (UNKNOWN.equals(string)) {
                        return 0;
                    }
                    if (NOT_EXIST.equals(string)) {
                        return -1;
                    }
                    return 1;
                }
                if (UNKNOWN.equals(string)) {
                    if (UNKNOWN.equals(string2)) {
                        return 0;
                    }
                    if (NOT_EXIST.equals(string2)) {
                        return -1;
                    }
                    return 1;
                }
                if (VersionTableContentProvider.NOT_NEEDED.equals(string2)) {
                    if (VersionTableContentProvider.NOT_NEEDED.equals(string)) {
                        return 0;
                    }
                    return -1;
                }
                if (VersionTableContentProvider.NOT_NEEDED.equals(string)) {
                    if (VersionTableContentProvider.NOT_NEEDED.equals(string2)) {
                        return 0;
                    }
                    return 1;
                }
            } else {
                if (VersionTableContentProvider.isNonNumericVersion(string) && !VersionTableContentProvider.isNonNumericVersion(string2)) {
                    if (NOT_EXIST.equals(string)) {
                        return -1;
                    }
                    return 1;
                }
                if (VersionTableContentProvider.isNonNumericVersion(string2) && !VersionTableContentProvider.isNonNumericVersion(string)) {
                    if (NOT_EXIST.equals(string2)) {
                        return 1;
                    }
                    return -1;
                }
            }
            return VersionComparator.compareVersionStrings(string, string2);
        }
    }
}

