/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.eclipse.web.properties.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboFieldEditor
extends FieldEditor {
    private Combo combo;
    private String selectedValue;
    private String[][] entryNamesAndValues;

    public ComboFieldEditor(String string, String string2, String[][] stringArray, Composite composite) {
        this.init(string, string2);
        if (!this.checkArray(stringArray)) {
            throw new UnsupportedOperationException();
        }
        this.entryNamesAndValues = stringArray;
        this.createControl(composite);
    }

    private boolean checkArray(String[][] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            if (stringArray2 == null || stringArray2.length != 2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void adjustForNumColumns(int n) {
        if (n > 1) {
            Label label = this.getLabelControl();
            int n2 = n;
            if (label != null) {
                ((GridData)label.getLayoutData()).horizontalSpan = 1;
                --n2;
            }
            ((GridData)this.combo.getLayoutData()).horizontalSpan = n2;
        } else {
            Label label = this.getLabelControl();
            if (label != null) {
                ((GridData)label.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.combo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        int n2 = 1;
        if (n > 1) {
            n2 = n - 1;
        }
        Label label = this.getLabelControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = this.getComboBoxControl(composite);
        gridData = new GridData();
        gridData.horizontalSpan = n2;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        label.setFont(composite.getFont());
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.selectedValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.selectedValue);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboBoxControl(Composite composite) {
        if (this.combo == null) {
            this.combo = new Combo(composite, 8);
            this.combo.setFont(composite.getFont());
            if (this.entryNamesAndValues.length == 0) {
                this.combo.setEnabled(false);
            } else {
                int n = 0;
                while (n < this.entryNamesAndValues.length) {
                    this.combo.add(this.entryNamesAndValues[n][0], n);
                    ++n;
                }
                this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        String string = ComboFieldEditor.this.selectedValue;
                        String string2 = ComboFieldEditor.this.combo.getText();
                        ComboFieldEditor.this.selectedValue = ComboFieldEditor.this.getValueForName(string2);
                        ComboFieldEditor.this.setPresentsDefaultValue(false);
                        ComboFieldEditor.this.fireValueChanged("field_editor_value", string, ComboFieldEditor.this.selectedValue);
                    }
                });
                this.combo.select(0);
            }
        }
        return this.combo;
    }

    protected String getValueForName(String string) {
        int n = 0;
        while (n < this.entryNamesAndValues.length) {
            String[] stringArray = this.entryNamesAndValues[n];
            if (string.equals(stringArray[0])) {
                return stringArray[1];
            }
            ++n;
        }
        return this.entryNamesAndValues[0][0];
    }

    protected void updateComboForValue(String string) {
        this.selectedValue = string;
        int n = 0;
        while (n < this.entryNamesAndValues.length) {
            if (string.equals(this.entryNamesAndValues[n][1])) {
                this.combo.setText(this.entryNamesAndValues[n][0]);
                return;
            }
            ++n;
        }
        if (this.entryNamesAndValues.length > 0) {
            this.selectedValue = this.entryNamesAndValues[0][1];
        }
    }
}

