/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.eclipse.facets.shared;

import com.businessobjects.integration.eclipse.facets.shared.FacetErrorRecord;
import com.businessobjects.integration.eclipse.facets.shared.NLSResourceManager;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class FacetErrorDialog
extends TitleAreaDialog {
    private FacetErrorRecord[] errors;

    public FacetErrorDialog(Shell shell, Set<FacetErrorRecord> set) {
        super(shell);
        this.errors = (FacetErrorRecord[])set.toArray();
    }

    protected void configureShell(Shell shell) {
        shell.setText(NLSResourceManager.facet_error_dialog_title);
        super.configureShell(shell);
    }

    protected Point getInitialSize() {
        return new Point(450, 400);
    }

    protected Control createDialogArea(Composite composite) {
        int n;
        this.setTitle(NLSResourceManager.facet_error_dialog_title);
        this.setErrorMessage(NLSResourceManager.facet_error_dialog_message);
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        final TableViewer tableViewer = new TableViewer(composite2, 65538);
        final Table table = tableViewer.getTable();
        table.setLinesVisible(false);
        table.setHeaderVisible(true);
        String[] stringArray = new String[]{NLSResourceManager.action, NLSResourceManager.path};
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn tableColumn = table.getSortColumn();
                TableColumn tableColumn2 = (TableColumn)event.widget;
                int n = table.getSortDirection();
                if (tableColumn == tableColumn2) {
                    n = n == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(tableColumn2);
                    n = 128;
                }
                final int n2 = n;
                if (tableColumn2 == table.getColumn(0)) {
                    Arrays.sort(FacetErrorDialog.this.errors, new Comparator<FacetErrorRecord>(){

                        @Override
                        public int compare(FacetErrorRecord facetErrorRecord, FacetErrorRecord facetErrorRecord2) {
                            if (n2 == 128) {
                                return facetErrorRecord.getActionType() - facetErrorRecord2.getActionType();
                            }
                            return facetErrorRecord2.getActionType() - facetErrorRecord.getActionType();
                        }
                    });
                } else {
                    Arrays.sort(FacetErrorDialog.this.errors, new Comparator<FacetErrorRecord>(){

                        @Override
                        public int compare(FacetErrorRecord facetErrorRecord, FacetErrorRecord facetErrorRecord2) {
                            if (n2 == 128) {
                                return facetErrorRecord.getPath().compareTo(facetErrorRecord2.getPath());
                            }
                            return facetErrorRecord2.getPath().compareTo(facetErrorRecord.getPath());
                        }
                    });
                }
                table.setSortDirection(n);
                tableViewer.refresh();
            }
        };
        for (n = 0; n < stringArray.length; ++n) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[n]);
            tableColumn.addListener(13, listener);
        }
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                if (object instanceof Object[]) {
                    return FacetErrorDialog.this.errors;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object object, int n) {
                return null;
            }

            public String getColumnText(Object object, int n) {
                FacetErrorRecord facetErrorRecord = (FacetErrorRecord)object;
                switch (n) {
                    case 0: {
                        switch (facetErrorRecord.getActionType()) {
                            case 1: {
                                return NLSResourceManager.add;
                            }
                            case 3: {
                                return NLSResourceManager.update;
                            }
                            case 2: {
                                return NLSResourceManager.delete;
                            }
                        }
                    }
                    case 1: {
                        return facetErrorRecord.getPath();
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object object, String string) {
                return true;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        });
        tableViewer.setInput((Object)this.errors);
        for (n = 0; n < stringArray.length; ++n) {
            table.getColumn(n).pack();
        }
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Table table = tableViewer.getTable();
                table.getColumn(0).setWidth((int)((double)table.getClientArea().width * 0.3));
                table.getColumn(1).setWidth((int)((double)table.getClientArea().width * 0.7));
            }
        });
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
    }
}

