/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.util.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.Incident;
import java.lang.ref.WeakReference;
import java.util.Date;

public final class IncidentEntry
implements Incident {
    private final Key key;
    private final WeakReference<ClassLoader> classLoaderRef;
    private int count = 1;
    private long timeStamp;
    private final Date dateOfFirstOccurrence;
    private STATE state = STATE.READY_TO_LOG;
    private static final int MAXLABELLENGTH = 1024;
    private String label;

    IncidentEntry(Key key, ClassLoader cldr) {
        this.key = key;
        this.timeStamp = System.currentTimeMillis();
        this.dateOfFirstOccurrence = new Date(this.timeStamp);
        this.count = 1;
        this.classLoaderRef = cldr == null ? null : new WeakReference<ClassLoader>(cldr);
    }

    public synchronized void increment() {
        ++this.count;
        this.timeStamp = System.currentTimeMillis();
    }

    synchronized boolean tag() {
        switch (this.state) {
            case READY_TO_LOG: {
                this.state = STATE.ABOUT_TO_LOG;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(FfdcProvider provider, Object reporter, Throwable th, Object[] capturedDataElements) {
        FfdcProvider ffdcProvider = provider;
        synchronized (ffdcProvider) {
            IncidentEntry incidentEntry = this;
            synchronized (incidentEntry) {
                switch (this.state) {
                    case READY_TO_LOG: 
                    case ABOUT_TO_LOG: {
                        try {
                            provider.log(this, reporter, th, capturedDataElements);
                        }
                        catch (Throwable throwable) {
                            provider.ffdcerror(throwable);
                        }
                        this.state = STATE.ALREADY_LOGGED;
                    }
                }
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public String getSourceId() {
        return this.key.sourceId;
    }

    public String getProbeId() {
        return this.key.probeId;
    }

    public String getExceptionName() {
        return this.key.exceptionName;
    }

    public boolean hasSameClassLoader(ClassLoader cldr) {
        return cldr == null ? this.classLoaderRef == null : this.classLoaderRef != null && this.classLoaderRef.get() == cldr;
    }

    public synchronized long getTimeStamp() {
        return this.timeStamp;
    }

    public Date getDateOfFirstOccurrence() {
        return this.dateOfFirstOccurrence;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label == null) {
            return;
        }
        if (label.length() <= 1024) {
            this.label = label;
            return;
        }
        int discarded = label.length() - 1024;
        this.label = label.substring(0, 1024) + " ...characters cut off:" + discarded;
    }

    public void unblockLogging() {
        this.state = STATE.READY_TO_LOG;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum STATE {
        READY_TO_LOG,
        ABOUT_TO_LOG,
        ALREADY_LOGGED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Key
    implements Comparable<Key> {
        private final String sourceId;
        private final String probeId;
        private final String exceptionName;

        public Key(String sourceId, String probeId, String exceptionName) {
            this.sourceId = String.valueOf(sourceId);
            this.probeId = String.valueOf(probeId);
            this.exceptionName = exceptionName;
        }

        @Override
        public int compareTo(Key other) {
            int compresSourceId = this.sourceId.compareTo(other.sourceId);
            if (compresSourceId != 0) {
                return compresSourceId;
            }
            int compresProbeId = this.probeId.compareTo(other.probeId);
            if (compresProbeId != 0) {
                return compresProbeId;
            }
            return this.exceptionName.compareTo(other.exceptionName);
        }
    }
}

