/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.Ffdc;
import com.ibm.ffdc.Manager;
import com.ibm.ffdc.config.DataCollector;
import com.ibm.ffdc.config.Formattable;
import com.ibm.ffdc.config.IncidentStream;
import com.ibm.ffdc.util.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.FfdcProviderDependent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicableDataCollectors
extends FfdcProviderDependent<FfdcProvider>
implements Formattable {
    private final Throwable th;
    private final List<DataCollector> rc;
    static final String BEGIN_DATA_COLLECTED = "Begin data collected by";
    static final String END_DATA_COLLECTED = "End data collected by";
    static final String DATA_COLLECTOR_FAILED_SEE_FFDC = "Data collector failed see FFDC";

    public ApplicableDataCollectors(FfdcProvider provider, Throwable th) {
        super(provider);
        this.th = th;
        this.rc = new ArrayList<DataCollector>(provider.getDataCollectors().size());
        this.rc.addAll(provider.getDataCollectors());
    }

    public List<DataCollector> getDataCollectors(Throwable th) {
        StackTraceElement[] stack;
        ArrayList<DataCollector> result = new ArrayList<DataCollector>();
        for (StackTraceElement ste : stack = th.getStackTrace()) {
            this.collect(ste, result);
        }
        return result;
    }

    public Throwable getThrowable() {
        return this.th;
    }

    private void collect(StackTraceElement ste, List<DataCollector> collectors) {
        ListIterator<DataCollector> dci = this.rc.listIterator();
        while (dci.hasNext()) {
            DataCollector dc = dci.next();
            String[] supportedTypeNames = null;
            try {
                supportedTypeNames = dc.getSupportedTypeNames();
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, this.getClass().getName(), "69");
                this.provider.deregister(dc);
            }
            if (supportedTypeNames == null || supportedTypeNames.length == 0) continue;
            for (String stn : supportedTypeNames) {
                String cname = ste.getClassName();
                if (!stn.startsWith(ste.getClassName())) continue;
                if (stn.length() == cname.length()) {
                    this.collect(dci, collectors, dc);
                    continue;
                }
                if (stn.length() - cname.length() < 2 || stn.charAt(cname.length()) != '#' || !stn.substring(cname.length() + 1).equals(ste.getMethodName())) continue;
                this.collect(dci, collectors, dc);
            }
        }
    }

    private void collect(ListIterator<DataCollector> dci, List<DataCollector> collectors, DataCollector dc) {
        dci.remove();
        collectors.add(dc);
    }

    @Override
    public void formatTo(IncidentStream is) {
        List<DataCollector> collectors = this.getDataCollectors(this.th);
        for (DataCollector collector : collectors) {
            this.formatTo(collector, this.th, is);
        }
    }

    private void formatTo(DataCollector collector, Throwable th, IncidentStream is) {
        Collection<? extends Object> data;
        String collectorName;
        try {
            collectorName = collector.toString();
        }
        catch (Exception e) {
            Ffdc ffdc = Manager.Ffdc.getFfdc(e, this, this.getClass().getName(), "114");
            ffdc.log(new Object[0]);
            is.write(DATA_COLLECTOR_FAILED_SEE_FFDC, ffdc.toString());
            return;
        }
        is.write(BEGIN_DATA_COLLECTED, collectorName);
        try {
            data = collector.collect(th);
        }
        catch (Exception e) {
            Ffdc ffdc = Manager.Ffdc.getFfdc(e, this, this.getClass().getName() + "126");
            if (ffdc.isLoggable()) {
                ffdc.log(new Object[0]);
            }
            is.write(DATA_COLLECTOR_FAILED_SEE_FFDC, ffdc.toString());
            is.write(END_DATA_COLLECTED, collectorName);
            return;
        }
        if (data == null || data.size() == 0) {
            is.write(END_DATA_COLLECTED, collectorName);
            return;
        }
        for (Object object : data) {
            is.write(null, object);
        }
        is.write(END_DATA_COLLECTED, collectorName);
    }
}

