/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.formatting;

import com.ibm.ffdc.config.IncidentStream;
import com.ibm.ffdc.util.formatting.DateFormatProvider;
import com.ibm.ffdc.util.provider.Incident;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncidentReportHeader
implements IncidentStream.Writer<OutputStream> {
    private final Incident incident;
    private final Throwable th;
    private final Object reporter;

    public IncidentReportHeader(Incident incident, Throwable th, Object reporter) {
        this.incident = incident;
        this.th = th;
        this.reporter = reporter;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        PrintWriter pw = new PrintWriter(os);
        DateFormat dateFormat = this.getDateFormatter();
        assert (this.th != null);
        String exceptionName = this.th.getClass().getName();
        StringBuffer sb = new StringBuffer();
        Date date = new Date();
        FieldPosition fPos = new FieldPosition(0);
        String sourceId = this.incident.getSourceId();
        String probeId = this.incident.getProbeId();
        this.formatTime(sb, dateFormat, date, fPos);
        pw.print(sb.toString());
        pw.print("    FFDC ");
        pw.print("Exception:");
        pw.print(exceptionName);
        pw.print(" SourceId:");
        pw.print(sourceId);
        pw.print(" ProbeId:");
        pw.print(probeId);
        if (this.reporter != null) {
            pw.print(" Reporter:");
            pw.print(this.reporter.getClass().getName());
            pw.print("@");
            pw.print(Integer.toHexString(System.identityHashCode(this.reporter)));
        }
        pw.println();
        this.th.printStackTrace(pw);
        pw.println();
        pw.flush();
    }

    private void formatTime(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        buffer.setLength(0);
        buffer.append('[');
        formatter.format(date, buffer, fPos);
        buffer.append("] ");
    }

    protected DateFormat getDateFormatter() {
        return DateFormatProvider.getDateFormat();
    }
}

