/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.DiagnosticEngine;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.DiagnosticModuleRegistrationFailureException;
import com.ibm.ws.ffdc.impl.Configure;
import com.ibm.ws.ffdc.impl.FFDCHelper;
import com.ibm.ws.ffdc.impl.FFDCJanitor;

public class FFDC {
    public static final int STARTING = 1;
    public static final int RUNNING = 2;
    public static final int STOPPING = 3;
    private static String exceptionFileExtension = ".txt";
    private static String exceptionIndexFileNameExtension = ".log";
    private static int serverState = 0;
    private static boolean isServer = false;
    private static String serverName = null;
    private static boolean isZos = false;
    private static String zOSJobNumber = null;
    private static String zOSJobName = null;
    private static String zOSStoken = null;
    private static String fullServerName = null;
    private static Object synchObject = new Object();
    private static String logRoot = null;
    private static long lastRead = 0L;
    static Configure currentConfiguration;

    public static void setState(int newState) {
        if (newState < 1 || newState > 3) {
            return;
        }
        if (newState != serverState) {
            serverState = newState;
            FFDC.configureComponents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServer() {
        Object object = synchObject;
        synchronized (object) {
            isServer = true;
            serverState = 1;
            FFDC.configureComponents();
        }
    }

    public static boolean isServer() {
        return isServer;
    }

    public static void setZos(boolean isZOSFlag) {
        isZos = isZOSFlag;
    }

    public static void setServerName(String inServerName, String inFullServerName) {
        serverName = inServerName;
        fullServerName = inFullServerName;
        FFDCHelper.setServerName(serverName);
    }

    public static void setzOSjobAttributes(String inJobNo, String inJobName, String inStoken) {
        zOSJobNumber = inJobNo;
        zOSJobName = inJobName;
        zOSStoken = inStoken;
    }

    public static String getzOSServantName() {
        return zOSStoken;
    }

    public static void setLogRoot(String inLogRoot) {
        logRoot = inLogRoot;
    }

    public static boolean isZos() {
        return isZos;
    }

    public static String getzOSjobNumber() {
        return zOSJobNumber;
    }

    public static String getzOSjobName() {
        return zOSJobName;
    }

    public static String getFullServerName() {
        return fullServerName;
    }

    public static String getLogRoot() {
        return logRoot;
    }

    public static void resetThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureComponents() {
        Object object = synchObject;
        synchronized (object) {
            if (!isServer) {
                return;
            }
            currentConfiguration = Configure.newConfiguration(serverState);
            FFDC.currentConfiguration.debugMode = true;
            lastRead = System.currentTimeMillis();
            if (currentConfiguration == null) {
                return;
            }
            if (!FFDC.currentConfiguration.theSwitch || FFDC.currentConfiguration.processLevel == 0) {
                return;
            }
            FFDCJanitor.getInstance().configure(currentConfiguration);
        }
    }

    public static Configure getConfiguration() {
        return currentConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configure checkAndRefreshIfNeeded() {
        Object object = synchObject;
        synchronized (object) {
            Configure cfg = currentConfiguration;
            if (cfg != null && cfg.refreshInterval == 0) {
                return cfg;
            }
            double lastChange = (System.currentTimeMillis() - lastRead) / 60000L;
            if (cfg == null || lastRead == 0L || lastChange > (double)cfg.refreshInterval) {
                FFDC.configureComponents();
                FFDCJanitor.getInstance().doCleanupIfNeeded();
            }
            return currentConfiguration;
        }
    }

    public static boolean hasPermissionForLogging() {
        Configure cfg = FFDC.checkAndRefreshIfNeeded();
        if (cfg == null) {
            return false;
        }
        boolean mustNotLog = !cfg.theSwitch || cfg.processLevel == 0 || cfg.processLevel == 1;
        return !mustNotLog;
    }

    public static int registerDiagnosticModule(DiagnosticModule diagnosticModule, String packageName) {
        boolean goodDiagnosticModule = false;
        boolean alreadyRegistered = true;
        int failedValidation = 2;
        int unknownFailure = 3;
        try {
            diagnosticModule.init();
        }
        catch (DiagnosticModuleRegistrationFailureException dmFailed) {
            return 2;
        }
        catch (Throwable th) {
            return 3;
        }
        if (!DiagnosticEngine.registerDM(diagnosticModule, packageName)) {
            return 0;
        }
        return 0;
    }

    public static boolean deregisterDiagnosticModule(String packageName) {
        return DiagnosticEngine.deregisterDM(packageName);
    }

    public static String getExceptionFileExtension() {
        return exceptionFileExtension;
    }

    public static void setExceptionFileExtension(String newExceptionFileExtension) {
        exceptionFileExtension = newExceptionFileExtension;
    }

    public static String getExceptionIndexFileNameExtension() {
        return exceptionIndexFileNameExtension;
    }

    public static void setExceptionIndexFileNameExtension(String exceptionIndexFileNameExtension) {
        FFDC.exceptionIndexFileNameExtension = exceptionIndexFileNameExtension;
    }
}

