/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006, 2008. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import com.ibm.team.foundation.rcp.core.internal.favorites.Favorite;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Favorite</b></em>'.
 *
 * @since 0.5
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoriteImpl#getItem <em>Item</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoriteImpl#getRepositoryUrl <em>Repository Url</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FavoriteImpl extends FavoritesNodeImpl implements Favorite {
	/**
	 * The cached value of the '{@link #getItem() <em>Item</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getItem()
	 * @generated
	 * @ordered
	 */
	protected IItemHandle item;

	/**
	 * The flag representing whether the Item containment reference has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final int ITEM_ESETFLAG= 1 << 3;

	/**
	 * The default value of the '{@link #getRepositoryUrl() <em>Repository Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRepositoryUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String REPOSITORY_URL_EDEFAULT= null;

	/**
	 * The cached value of the '{@link #getRepositoryUrl() <em>Repository Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRepositoryUrl()
	 * @generated
	 * @ordered
	 */
	protected String repositoryUrl= REPOSITORY_URL_EDEFAULT;

	/**
	 * The flag representing whether the Repository Url attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final int REPOSITORY_URL_ESETFLAG= 1 << 4;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FavoriteImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return FavoritesPackage.Literals.FAVORITE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IItemHandle getItem() {
		return item;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetItem(IItemHandle newItem, NotificationChain msgs) {
		IItemHandle oldItem= item;
		item= newItem;
		boolean oldItemESet= (ALL_FLAGS & ITEM_ESETFLAG) != 0;
		ALL_FLAGS|= ITEM_ESETFLAG;
		if (eNotificationRequired()) {
			ENotificationImpl notification= new ENotificationImpl(this, Notification.SET, FavoritesPackage.FAVORITE__ITEM, oldItem, newItem, !oldItemESet);
			if (msgs == null)
				msgs= notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setItem(IItemHandle newItem) {
		if (newItem != item) {
			NotificationChain msgs= null;
			if (item != null)
				msgs= ((InternalEObject) item).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - FavoritesPackage.FAVORITE__ITEM, null, msgs);
			if (newItem != null)
				msgs= ((InternalEObject) newItem).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - FavoritesPackage.FAVORITE__ITEM, null, msgs);
			msgs= basicSetItem(newItem, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else {
			boolean oldItemESet= (ALL_FLAGS & ITEM_ESETFLAG) != 0;
			ALL_FLAGS|= ITEM_ESETFLAG;
			if (eNotificationRequired())
				eNotify(new ENotificationImpl(this, Notification.SET, FavoritesPackage.FAVORITE__ITEM, newItem, newItem, !oldItemESet));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicUnsetItem(NotificationChain msgs) {
		IItemHandle oldItem= item;
		item= null;
		boolean oldItemESet= (ALL_FLAGS & ITEM_ESETFLAG) != 0;
		ALL_FLAGS&= ~ITEM_ESETFLAG;
		if (eNotificationRequired()) {
			ENotificationImpl notification= new ENotificationImpl(this, Notification.UNSET, FavoritesPackage.FAVORITE__ITEM, oldItem, null, oldItemESet);
			if (msgs == null)
				msgs= notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetItem() {
		if (item != null) {
			NotificationChain msgs= null;
			msgs= ((InternalEObject) item).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - FavoritesPackage.FAVORITE__ITEM, null, msgs);
			msgs= basicUnsetItem(msgs);
			if (msgs != null)
				msgs.dispatch();
		} else {
			boolean oldItemESet= (ALL_FLAGS & ITEM_ESETFLAG) != 0;
			ALL_FLAGS&= ~ITEM_ESETFLAG;
			if (eNotificationRequired())
				eNotify(new ENotificationImpl(this, Notification.UNSET, FavoritesPackage.FAVORITE__ITEM, null, null, oldItemESet));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetItem() {
		return (ALL_FLAGS & ITEM_ESETFLAG) != 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getRepositoryUrl() {
		return repositoryUrl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRepositoryUrl(String newRepositoryUrl) {
		String oldRepositoryUrl= repositoryUrl;
		repositoryUrl= newRepositoryUrl;
		boolean oldRepositoryUrlESet= (ALL_FLAGS & REPOSITORY_URL_ESETFLAG) != 0;
		ALL_FLAGS|= REPOSITORY_URL_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FavoritesPackage.FAVORITE__REPOSITORY_URL, oldRepositoryUrl, repositoryUrl, !oldRepositoryUrlESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetRepositoryUrl() {
		String oldRepositoryUrl= repositoryUrl;
		boolean oldRepositoryUrlESet= (ALL_FLAGS & REPOSITORY_URL_ESETFLAG) != 0;
		repositoryUrl= REPOSITORY_URL_EDEFAULT;
		ALL_FLAGS&= ~REPOSITORY_URL_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, FavoritesPackage.FAVORITE__REPOSITORY_URL, oldRepositoryUrl, REPOSITORY_URL_EDEFAULT, oldRepositoryUrlESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetRepositoryUrl() {
		return (ALL_FLAGS & REPOSITORY_URL_ESETFLAG) != 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case FavoritesPackage.FAVORITE__ITEM:
			return basicUnsetItem(msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case FavoritesPackage.FAVORITE__ITEM:
			return getItem();
		case FavoritesPackage.FAVORITE__REPOSITORY_URL:
			return getRepositoryUrl();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case FavoritesPackage.FAVORITE__ITEM:
			setItem((IItemHandle) newValue);
			return;
		case FavoritesPackage.FAVORITE__REPOSITORY_URL:
			setRepositoryUrl((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
		case FavoritesPackage.FAVORITE__ITEM:
			unsetItem();
			return;
		case FavoritesPackage.FAVORITE__REPOSITORY_URL:
			unsetRepositoryUrl();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case FavoritesPackage.FAVORITE__ITEM:
			return isSetItem();
		case FavoritesPackage.FAVORITE__REPOSITORY_URL:
			return isSetRepositoryUrl();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result= new StringBuffer(super.toString());
		result.append(" (repositoryUrl: "); //$NON-NLS-1$
		if ((ALL_FLAGS & REPOSITORY_URL_ESETFLAG) != 0)
			result.append(repositoryUrl);
		else
			result.append("<unset>"); //$NON-NLS-1$
		result.append(')');
		return result.toString();
	}

	/**
	 * Not generated.
	 */
	public Object getModelInstance() {
		IItemHandle itemHandle= getItem();
		if (itemHandle == null)
			return null;
		if (itemHandle.hasFullState())
			return itemHandle.getFullState();

		if (itemHandle.getOrigin() instanceof ITeamRepository) {
			ITeamRepository repo= (ITeamRepository) itemHandle.getOrigin();
			return repo.itemManager().getSharedItemIfKnown(itemHandle);
		}

		return null;
	}

} //FavoriteImpl