/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006, 2008. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 *
 * @since 0.5
 * <!-- end-user-doc -->
 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFactory
 * @model kind="package"
 *        annotation="teamModel clientProject='com.ibm.team.foundation.rcp.core' clientSrcFolder='model/src'"
 *        annotation="teamPackage clientBasePackage='com.ibm.team.foundation.rcp.core' clientPackageSuffix='' version='0.1'"
 * @generated
 */
public interface FavoritesPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME= "internal.favorites"; //$NON-NLS-1$

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI= "http:///com/ibm/team/favoritesmodel.ecore"; //$NON-NLS-1$

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX= "com.ibm.team.favoritesmodel"; //$NON-NLS-1$

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	FavoritesPackage eINSTANCE= com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl.init();

	/**
	 * The meta object id for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor <em>Model Accessor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getModelAccessor()
	 * @generated
	 */
	int MODEL_ACCESSOR= 4;

	/**
	 * The meta object id for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesNodeImpl <em>Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesNodeImpl
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getFavoritesNode()
	 * @generated
	 */
	int FAVORITES_NODE= 0;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITES_NODE__PARENT= 0;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITES_NODE__TEXT= 1;

	/**
	 * The feature id for the '<em><b>Sort Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITES_NODE__SORT_ORDER= 2;

	/**
	 * The number of structural features of the '<em>Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITES_NODE_FEATURE_COUNT= 3;

	/**
	 * The meta object id for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.URIFavoriteImpl <em>URI Favorite</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.URIFavoriteImpl
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getURIFavorite()
	 * @generated
	 */
	int URI_FAVORITE= 1;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_FAVORITE__PARENT= FAVORITES_NODE__PARENT;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_FAVORITE__TEXT= FAVORITES_NODE__TEXT;

	/**
	 * The feature id for the '<em><b>Sort Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_FAVORITE__SORT_ORDER= FAVORITES_NODE__SORT_ORDER;

	/**
	 * The feature id for the '<em><b>Details</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_FAVORITE__DETAILS= FAVORITES_NODE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Favorite Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_FAVORITE__FAVORITE_TYPE= FAVORITES_NODE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_FAVORITE__URI= FAVORITES_NODE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>URI Favorite</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_FAVORITE_FEATURE_COUNT= FAVORITES_NODE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesFolderImpl <em>Folder</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesFolderImpl
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getFavoritesFolder()
	 * @generated
	 */
	int FAVORITES_FOLDER= 2;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITES_FOLDER__PARENT= FAVORITES_NODE__PARENT;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITES_FOLDER__TEXT= FAVORITES_NODE__TEXT;

	/**
	 * The feature id for the '<em><b>Sort Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITES_FOLDER__SORT_ORDER= FAVORITES_NODE__SORT_ORDER;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITES_FOLDER__CHILDREN= FAVORITES_NODE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Folder</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITES_FOLDER_FEATURE_COUNT= FAVORITES_NODE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoriteImpl <em>Favorite</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoriteImpl
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getFavorite()
	 * @generated
	 */
	int FAVORITE= 3;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITE__PARENT= FAVORITES_NODE__PARENT;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITE__TEXT= FAVORITES_NODE__TEXT;

	/**
	 * The feature id for the '<em><b>Sort Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITE__SORT_ORDER= FAVORITES_NODE__SORT_ORDER;

	/**
	 * The feature id for the '<em><b>Item</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITE__ITEM= FAVORITES_NODE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Repository Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITE__REPOSITORY_URL= FAVORITES_NODE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Favorite</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAVORITE_FEATURE_COUNT= FAVORITES_NODE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Model Accessor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_ACCESSOR_FEATURE_COUNT= 0;

	/**
	 * The meta object id for the '{@link com.ibm.team.foundation.rcp.core.IModelAccessor <em>Model Accessor Facade</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.ibm.team.foundation.rcp.core.IModelAccessor
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getModelAccessorFacade()
	 * @generated
	 */
	int MODEL_ACCESSOR_FACADE= 5;

	/**
	 * The number of structural features of the '<em>Model Accessor Facade</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_ACCESSOR_FACADE_FEATURE_COUNT= 0;

	/**
	 * Returns the meta object for class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Node</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode
	 * @generated
	 */
	EClass getFavoritesNode();

	/**
	 * Returns the meta object for the reference '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parent</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getParent()
	 * @see #getFavoritesNode()
	 * @generated
	 */
	EReference getFavoritesNode_Parent();

	/**
	 * Returns the meta object for the attribute '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getText()
	 * @see #getFavoritesNode()
	 * @generated
	 */
	EAttribute getFavoritesNode_Text();

	/**
	 * Returns the meta object for the attribute '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getSortOrder <em>Sort Order</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sort Order</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getSortOrder()
	 * @see #getFavoritesNode()
	 * @generated
	 */
	EAttribute getFavoritesNode_SortOrder();

	/**
	 * Returns the meta object for class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite <em>URI Favorite</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>URI Favorite</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite
	 * @generated
	 */
	EClass getURIFavorite();

	/**
	 * Returns the meta object for the attribute '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getDetails <em>Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Details</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getDetails()
	 * @see #getURIFavorite()
	 * @generated
	 */
	EAttribute getURIFavorite_Details();

	/**
	 * Returns the meta object for the attribute '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getFavoriteType <em>Favorite Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Favorite Type</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getFavoriteType()
	 * @see #getURIFavorite()
	 * @generated
	 */
	EAttribute getURIFavorite_FavoriteType();

	/**
	 * Returns the meta object for the attribute '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getUri <em>Uri</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uri</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getUri()
	 * @see #getURIFavorite()
	 * @generated
	 */
	EAttribute getURIFavorite_Uri();

	/**
	 * Returns the meta object for class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder <em>Folder</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Folder</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder
	 * @generated
	 */
	EClass getFavoritesFolder();

	/**
	 * Returns the meta object for the containment reference list '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Children</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder#getChildren()
	 * @see #getFavoritesFolder()
	 * @generated
	 */
	EReference getFavoritesFolder_Children();

	/**
	 * Returns the meta object for class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite <em>Favorite</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Favorite</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.Favorite
	 * @generated
	 */
	EClass getFavorite();

	/**
	 * Returns the meta object for the containment reference '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getItem <em>Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Item</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getItem()
	 * @see #getFavorite()
	 * @generated
	 */
	EReference getFavorite_Item();

	/**
	 * Returns the meta object for the attribute '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getRepositoryUrl <em>Repository Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Repository Url</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getRepositoryUrl()
	 * @see #getFavorite()
	 * @generated
	 */
	EAttribute getFavorite_RepositoryUrl();

	/**
	 * Returns the meta object for class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor <em>Model Accessor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model Accessor</em>'.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor
	 * @generated
	 */
	EClass getModelAccessor();

	/**
	 * Returns the meta object for class '{@link com.ibm.team.foundation.rcp.core.IModelAccessor <em>Model Accessor Facade</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model Accessor Facade</em>'.
	 * @see com.ibm.team.foundation.rcp.core.IModelAccessor
	 * @model instanceClass="com.ibm.team.foundation.rcp.core.IModelAccessor"
	 *        annotation="teamClass facadeForClass='ModelAccessor'"
	 * @generated
	 */
	EClass getModelAccessorFacade();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	FavoritesFactory getFavoritesFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesNodeImpl <em>Node</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesNodeImpl
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getFavoritesNode()
		 * @generated
		 */
		EClass FAVORITES_NODE= eINSTANCE.getFavoritesNode();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FAVORITES_NODE__PARENT= eINSTANCE.getFavoritesNode_Parent();

		/**
		 * The meta object literal for the '<em><b>Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FAVORITES_NODE__TEXT= eINSTANCE.getFavoritesNode_Text();

		/**
		 * The meta object literal for the '<em><b>Sort Order</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FAVORITES_NODE__SORT_ORDER= eINSTANCE.getFavoritesNode_SortOrder();

		/**
		 * The meta object literal for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.URIFavoriteImpl <em>URI Favorite</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.URIFavoriteImpl
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getURIFavorite()
		 * @generated
		 */
		EClass URI_FAVORITE= eINSTANCE.getURIFavorite();

		/**
		 * The meta object literal for the '<em><b>Details</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute URI_FAVORITE__DETAILS= eINSTANCE.getURIFavorite_Details();

		/**
		 * The meta object literal for the '<em><b>Favorite Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute URI_FAVORITE__FAVORITE_TYPE= eINSTANCE.getURIFavorite_FavoriteType();

		/**
		 * The meta object literal for the '<em><b>Uri</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute URI_FAVORITE__URI= eINSTANCE.getURIFavorite_Uri();

		/**
		 * The meta object literal for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesFolderImpl <em>Folder</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesFolderImpl
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getFavoritesFolder()
		 * @generated
		 */
		EClass FAVORITES_FOLDER= eINSTANCE.getFavoritesFolder();

		/**
		 * The meta object literal for the '<em><b>Children</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FAVORITES_FOLDER__CHILDREN= eINSTANCE.getFavoritesFolder_Children();

		/**
		 * The meta object literal for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoriteImpl <em>Favorite</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoriteImpl
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getFavorite()
		 * @generated
		 */
		EClass FAVORITE= eINSTANCE.getFavorite();

		/**
		 * The meta object literal for the '<em><b>Item</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FAVORITE__ITEM= eINSTANCE.getFavorite_Item();

		/**
		 * The meta object literal for the '<em><b>Repository Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FAVORITE__REPOSITORY_URL= eINSTANCE.getFavorite_RepositoryUrl();

		/**
		 * The meta object literal for the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor <em>Model Accessor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getModelAccessor()
		 * @generated
		 */
		EClass MODEL_ACCESSOR= eINSTANCE.getModelAccessor();

		/**
		 * The meta object literal for the '{@link com.ibm.team.foundation.rcp.core.IModelAccessor <em>Model Accessor Facade</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.ibm.team.foundation.rcp.core.IModelAccessor
		 * @see com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesPackageImpl#getModelAccessorFacade()
		 * @generated
		 */
		EClass MODEL_ACCESSOR_FACADE= eINSTANCE.getModelAccessorFacade();

	}

} //FavoritesPackage
