/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy.notification;

import com.ibm.team.filesystem.client.daemon.OrderlyShutdownNotification;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.IExternalManager;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMarshallingException;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.Notification;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationMarshaller;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerNotificationChannel
implements IServerNotificationChannel,
IExternalManager {
    private static final Log log = LogFactory.getLog((String)ServerNotificationChannel.class.getName());
    private final Queue<Channel> uninitializedChannels = new ConcurrentLinkedQueue<Channel>();
    private final Map<Channel, Object> channels = new ConcurrentHashMap<Channel, Object>();
    private boolean hasActiveChannels = false;
    private final Object isActiveLock = new Object();
    private final LinkedList<Notification<?>> pendingNotifications = new LinkedList();
    private final Job notificationJob = new Job("FSD Notifier"){

        protected IStatus run(IProgressMonitor monitor) {
            return ServerNotificationChannel.this.runNotify(monitor);
        }
    };
    NotificationMarshaller marshaller = new NotificationMarshaller();
    private final FSDaemon fsd;

    public ServerNotificationChannel(FSDaemon fsd) {
        this.fsd = fsd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manage(HttpRequest rq, HttpResponse rp) throws IOException {
        rp.setExternallyManaged(this);
        Channel ch = new Channel(rp);
        Object object = this.isActiveLock;
        synchronized (object) {
            this.uninitializedChannels.add(ch);
            this.hasActiveChannels = true;
        }
        this.notificationJob.schedule();
    }

    @Override
    public void shutdown() {
        this.notificationJob.schedule();
    }

    @Override
    public void remoteClosed() {
        this.notificationJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueNotification(String key, String type, IParameterWrapper notification) {
        LinkedList<Notification<?>> linkedList = this.isActiveLock;
        synchronized (linkedList) {
            if (!this.hasActiveChannels) {
                return;
            }
        }
        linkedList = this.pendingNotifications;
        synchronized (linkedList) {
            this.pendingNotifications.add(new Notification<IParameterWrapper>(key, type, notification));
        }
        this.notificationJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus runNotify(IProgressMonitor monitor) {
        Notification<?> notification;
        this.writeHeadersOnNewChannels();
        while ((notification = this.nextNotification()) != null) {
            this.sendNotification(notification);
        }
        this.closeConnectionsPendingShutDown();
        Object object = this.isActiveLock;
        synchronized (object) {
            this.hasActiveChannels = !this.uninitializedChannels.isEmpty() || !this.channels.isEmpty();
        }
        return Status.OK_STATUS;
    }

    /*
     * Unable to fully structure code
     */
    private void writeHeadersOnNewChannels() {
        if (!this.uninitializedChannels.isEmpty()) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            try {
                channel.rp.setCode(ResponseCode.OK.getCode(), ResponseCode.OK.getDefaultText());
                channel.rp.writeHeader("Content-Type", "application/vnd.ibm.jazz-json-notification-1.0");
                stream = channel.rp.getResponseStream();
                stream.flush();
                this.channels.put(channel, channel);
                continue;
            }
            catch (IOException v0) {
                channel.rp.setIgnoreWriteErrors(true);
                channel.rp.close();
            }
lbl14:
            // 3 sources

            ** while ((channel = this.uninitializedChannels.poll()) != null)
        }
lbl15:
        // 1 sources

    }

    private void closeConnectionsPendingShutDown() {
        Iterator<Channel> i = this.channels.keySet().iterator();
        while (i.hasNext()) {
            Channel channel = i.next();
            if (!channel.isDone()) continue;
            if (channel.rp.shouldShutdown() && channel.rp.isClientConnected()) {
                try {
                    this.writeNotification(this.marshallNotification(new Notification<OrderlyShutdownNotification>("orderlyShutdown", OrderlyShutdownNotification.TYPE, new OrderlyShutdownNotification())), channel);
                }
                catch (IOException iOException) {
                    channel.rp.setIgnoreWriteErrors(true);
                }
            }
            i.remove();
            channel.rp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Notification<?> nextNotification() {
        LinkedList<Notification<?>> linkedList = this.pendingNotifications;
        synchronized (linkedList) {
            block4: {
                if (!this.pendingNotifications.isEmpty()) break block4;
                return null;
            }
            return this.pendingNotifications.remove();
        }
    }

    private void sendNotification(Notification<?> notification) {
        byte[] bytes = this.marshallNotification(notification);
        if (bytes == null) {
            return;
        }
        Iterator<Channel> i = this.channels.keySet().iterator();
        while (i.hasNext()) {
            Channel channel = i.next();
            if (channel.isDone()) continue;
            try {
                this.writeNotification(bytes, channel);
            }
            catch (IOException iOException) {
                i.remove();
                channel.rp.setIgnoreWriteErrors(true);
                channel.rp.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private byte[] marshallNotification(Notification<?> notification) {
        buffer = new ByteArrayOutputStream();
        try {
            this.marshaller.write(buffer, notification.getKey(), notification.getType(), (IParameterWrapper)notification.getNotification());
            bytes = buffer.toByteArray();
        }
        catch (RestMarshallingException e) {
            ServerNotificationChannel.log.error((Object)"Could not marshal notification", (Throwable)e);
lbl9:
            // 2 sources

            while (true) {
                try {
                    buffer.close();
                }
                catch (IOException v0) {}
                return null;
            }
        }
        catch (IOException e) {
            try {
                ServerNotificationChannel.log.error((Object)"We should never get an IOException here", (Throwable)e);
                ** continue;
            }
            catch (Throwable var5_6) {
                try {
                    buffer.close();
                }
                catch (IOException v1) {}
                throw var5_6;
            }
        }
        try {
            buffer.close();
        }
        catch (IOException v2) {}
        return bytes;
    }

    private void writeNotification(byte[] bytes, Channel channel) throws IOException {
        OutputStream out = channel.rp.getResponseStream();
        out.write(bytes);
        out.flush();
    }

    @Override
    public void addListener(ILightweightEventListener<NotificationEvent> listener) {
        throw new IllegalStateException("Listeners aren't supported via this interface. See FSDaemon#getNotificationChannel()");
    }

    @Override
    public void removeListener(ILightweightEventListener<NotificationEvent> listener) {
        throw new IllegalStateException("Listeners aren't supported via this interface. See FSDaemon#getNotificationChannel()");
    }

    @Override
    public FSDaemon getFSDaemon() {
        return this.fsd;
    }

    private static class Channel {
        final HttpResponse rp;

        public Channel(HttpResponse rp) {
            this.rp = rp;
        }

        boolean isDone() {
            return this.rp.shouldShutdown() || !this.rp.isClientConnected();
        }
    }
}

