/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.query;

import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopy;
import com.ibm.team.workitem.common.expression.ExpressionChangeEvent;
import com.ibm.team.workitem.common.expression.StatementChangeEvent;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import com.ibm.team.workitem.common.query.IQueryDescriptor;

public class WorkingCopyChangeEvent {
    private final IQueryDescriptorWorkingCopy fWorkingCopy;
    private final String fAttribute;
    private final EventType fType;
    private ExpressionChangeEvent fExpressionEvent;
    private StatementChangeEvent fStatementEvent;

    public WorkingCopyChangeEvent(IQueryDescriptorWorkingCopy workingCopy, EventType type) {
        this(workingCopy, type, "");
    }

    public WorkingCopyChangeEvent(IQueryDescriptorWorkingCopy workingCopy, EventType type, String attribute) {
        this.fWorkingCopy = workingCopy;
        this.fType = type;
        this.fAttribute = attribute;
    }

    public WorkingCopyChangeEvent(IQueryDescriptorWorkingCopy workingCopy, EventType type, ExpressionChangeEvent event) {
        this(workingCopy, type, IQueryDescriptor.EXPRESSION_PROPERTY);
        this.fExpressionEvent = event;
    }

    public WorkingCopyChangeEvent(IQueryDescriptorWorkingCopy workingCopy, EventType type, StatementChangeEvent event) {
        this(workingCopy, type, IQueryDescriptor.EXPRESSION_PROPERTY);
        this.fStatementEvent = event;
    }

    public IQueryDescriptorWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public String getAttribute() {
        return this.fAttribute;
    }

    public EventType getType() {
        return this.fType;
    }

    public boolean affects(String attribute) {
        return this.fAttribute.equals(attribute);
    }

    public boolean affects(EditableExpression expression) {
        return this.fExpressionEvent != null && this.fExpressionEvent.getSource() == expression;
    }

    public boolean affects(EditableStatement statement) {
        return this.fStatementEvent != null && this.fStatementEvent.getSource() == statement;
    }

    public EditableExpression getCondition() {
        if (this.fExpressionEvent != null) {
            return this.fExpressionEvent.getExpression();
        }
        return null;
    }

    public ExpressionChangeEvent.Type getExpressionChangeEventType() {
        if (this.fExpressionEvent != null) {
            return this.fExpressionEvent.getType();
        }
        return null;
    }

    public StatementChangeEvent getStatementChangeEvent() {
        return this.fStatementEvent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        EXPRESSION_CHANGED,
        STATEMENT_CHANGED,
        QUERY_ATTRIBUTE_CHANGED,
        QUERY_SAVED,
        QUERY_DELETED;

    }
}

