/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.util.ThreadCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class EventDispatcher {
    private static final boolean LOG_REENTRANT_NOTIFICATION = false;
    private static final ThreadLocal<Integer> REENTRANCE_COUNT = new ThreadLocal();
    private String fName;
    private boolean fFork;
    private boolean fResponsive;
    private AtomicInteger fEntranceCount = new AtomicInteger();
    private List<ISafeRunnable> fQueue = new ArrayList<ISafeRunnable>();
    private Job fJob = null;
    private IProgressMonitor fProgressMonitor = null;

    public EventDispatcher(boolean responsive) {
        this("", false, responsive);
    }

    public EventDispatcher(String name, boolean fork, boolean responsive) {
        this.fName = name;
        this.fFork = fork;
        this.fResponsive = responsive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final ISafeRunnable runnable) {
        if (!this.fFork) {
            this.enterNotification();
            try {
                if (!this.fResponsive || ThreadCheck.longOpsProhibited()) {
                    SafeRunner.run((ISafeRunnable)runnable);
                } else {
                    ThreadCheck.runProhibitingLongOps((Runnable)new Runnable(){

                        public void run() {
                            SafeRunner.run((ISafeRunnable)runnable);
                        }
                    });
                }
            }
            finally {
                this.leaveNotification();
            }
            return;
        }
        List<ISafeRunnable> list = this.fQueue;
        synchronized (list) {
            this.fQueue.add(runnable);
            if (this.fJob == null) {
                this.fJob = new InternalJob();
                this.fJob.schedule();
            }
        }
    }

    private void enterNotification() {
        this.fEntranceCount.incrementAndGet();
        Integer count = REENTRANCE_COUNT.get();
        if (count == null) {
            REENTRANCE_COUNT.set(1);
        } else {
            REENTRANCE_COUNT.set(count + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveNotification() {
        Integer count = REENTRANCE_COUNT.get();
        if (count <= 1) {
            REENTRANCE_COUNT.remove();
        } else {
            REENTRANCE_COUNT.set(count - 1);
        }
        int entranceCount = this.fEntranceCount.decrementAndGet();
        if (entranceCount == 0) {
            AtomicInteger atomicInteger = this.fEntranceCount;
            synchronized (atomicInteger) {
                this.fEntranceCount.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void join() {
        if (!this.fFork) {
            AtomicInteger atomicInteger = this.fEntranceCount;
            synchronized (atomicInteger) {
                while (true) {
                    if (this.fEntranceCount.get() <= 0) {
                        return;
                    }
                    try {
                        this.fEntranceCount.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        List<ISafeRunnable> list = this.fQueue;
        synchronized (list) {
            while (true) {
                if (this.fJob == null) {
                    return;
                }
                try {
                    this.fQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    private class InternalJob
    extends FoundationJob {
        public InternalJob() {
            super(EventDispatcher.this.fName);
            this.setPriority(20);
            this.setSystem(true);
        }

        protected IStatus runProtected(final IProgressMonitor monitor) {
            if (!EventDispatcher.this.fResponsive) {
                this.internalRun(monitor);
            } else {
                ThreadCheck.runProhibitingLongOps((Runnable)new Runnable(){

                    public void run() {
                        InternalJob.this.internalRun(monitor);
                    }
                });
            }
            return Status.OK_STATUS;
        }

        private void internalRun(final IProgressMonitor monitor) {
            final boolean[] run = new boolean[]{true};
            while (run[0]) {
                run[0] = false;
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() throws Exception {
                        InternalJob.this.runQueue(monitor);
                    }

                    public void handleException(Throwable exception) {
                        run[0] = true;
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runQueue(IProgressMonitor monitor) {
            while (true) {
                ISafeRunnable runnable;
                List list = EventDispatcher.this.fQueue;
                synchronized (list) {
                    if (monitor.isCanceled() || EventDispatcher.this.fQueue.isEmpty()) {
                        EventDispatcher.this.fJob = null;
                        EventDispatcher.this.fQueue.notifyAll();
                        break;
                    }
                    runnable = (ISafeRunnable)EventDispatcher.this.fQueue.remove(0);
                }
                EventDispatcher.this.fProgressMonitor = monitor;
                SafeRunner.run((ISafeRunnable)runnable);
                EventDispatcher.this.fProgressMonitor = null;
            }
        }
    }
}

