/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.query;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.ClientEvaluationContext;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IQueryListener;
import com.ibm.team.workitem.client.QueryChangeEvent;
import com.ibm.team.workitem.client.internal.query.Messages;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopy;
import com.ibm.team.workitem.client.query.IWorkingCopyListener;
import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionChangeEvent;
import com.ibm.team.workitem.common.expression.IExpressionListener;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.expression.StatementChangeEvent;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.internal.util.EMFListener;
import com.ibm.team.workitem.common.query.IAssociation;
import com.ibm.team.workitem.common.query.IAssociations;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDescriptorWorkingCopy
implements IQueryDescriptorWorkingCopy {
    private final IQueryDescriptor fQueryDescriptor;
    private final ChangeNotifier fChangeNotifier;
    private IQueryDescriptor fSharedItem;
    private EditableStatement fEditableStatement;
    private int fReferenceCount;
    private boolean fIsDirty;

    QueryDescriptorWorkingCopy(IQueryDescriptor queryDescriptor) {
        Assert.isNotNull((Object)queryDescriptor);
        Assert.isTrue((!queryDescriptor.isWorkingCopy() || queryDescriptor.isNewItem() ? 1 : 0) != 0);
        this.fQueryDescriptor = queryDescriptor.isNewItem() ? queryDescriptor : (IQueryDescriptor)queryDescriptor.getWorkingCopy();
        this.fSharedItem = queryDescriptor.isNewItem() ? null : queryDescriptor;
        this.fChangeNotifier = new ChangeNotifier();
        this.fReferenceCount = 0;
        this.fIsDirty = queryDescriptor.isNewItem();
    }

    @Override
    public IQueryDescriptor getQueryDescriptor() {
        return this.fQueryDescriptor;
    }

    @Override
    public EditableStatement getEditableStatement() {
        return this.fEditableStatement;
    }

    public IQueryDescriptor getSharedItem() {
        return this.fSharedItem;
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = this.getClientLibrary(IAuditableClient.class);
        auditableClient.fetchCurrentAuditable((IAuditableHandle)this.fQueryDescriptor, IQueryDescriptor.FULL_PROFILE, monitor);
    }

    @Override
    public void save(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtils.getProgressMonitor(monitor);
        try {
            monitor.beginTask(Messages.QueryDescriptorWorkingCopy_SAVE_QUERY, 100);
            this.fChangeNotifier.startQueuing();
            this.fQueryDescriptor.setExpression((Expression)this.fEditableStatement.createStatement());
            monitor.worked(10);
            IQueryClient queryClient = this.getClientLibrary(IQueryClient.class);
            this.fSharedItem = queryClient.save(this.fQueryDescriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            EMFHelper.merge((EObject)((EObject)this.fQueryDescriptor), (EObject)((EObject)this.fSharedItem.getWorkingCopy()));
            this.setDirty(false);
        }
        finally {
            this.fChangeNotifier.stopQueuing();
            this.fChangeNotifier.notifySaved();
            monitor.done();
        }
    }

    @Override
    public IQueryDescriptorHandle saveCopy(String name, boolean copyAssociations, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtils.getProgressMonitor(monitor);
        try {
            monitor.beginTask(Messages.QueryDescriptorWorkingCopy_SAVE_QUERY, 100);
            this.fChangeNotifier.startQueuing();
            IQueryClient queryClient = this.getClientLibrary(IQueryClient.class);
            Statement statement = this.fEditableStatement.createStatement();
            IQueryDescriptor copy = queryClient.createQuery(this.fQueryDescriptor.getProjectArea(), this.fQueryDescriptor.getQueryType(), name, (Expression)statement);
            if (copyAssociations) {
                IAssociations copiedAssociations = copy.getAssociations();
                List publicAssociations = this.fQueryDescriptor.getAssociations().getPublicContents();
                for (IAssociation association : publicAssociations) {
                    IAssociation copied = copiedAssociations.createAssociation(association.getTarget());
                    copiedAssociations.associate(copied);
                }
            }
            monitor.worked(10);
            IQueryDescriptor saved = queryClient.save(copy, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            IQueryDescriptorHandle iQueryDescriptorHandle = (IQueryDescriptorHandle)saved.getItemHandle();
            return iQueryDescriptorHandle;
        }
        finally {
            this.fChangeNotifier.stopQueuing();
            monitor.done();
        }
    }

    @Override
    public void addListener(IWorkingCopyListener listener) {
        this.fChangeNotifier.addListener(listener);
    }

    @Override
    public void removeListener(IWorkingCopyListener listener) {
        this.fChangeNotifier.removeListener(listener);
    }

    public void connect() {
        if (this.fReferenceCount == 0) {
            this.connectListeners();
        }
        ++this.fReferenceCount;
    }

    public void disconnect() {
        --this.fReferenceCount;
        if (this.fReferenceCount == 0) {
            this.disconnectListeners();
        }
    }

    public boolean isReferenced() {
        return this.fReferenceCount > 0;
    }

    @Override
    public boolean isDirty() {
        return this.fIsDirty;
    }

    private void setDirty(boolean isDirty) {
        this.fIsDirty = isDirty;
    }

    private void connectListeners() {
        Assert.isNotNull((Object)this.fEditableStatement);
        IQueryClient queryClient = this.getClientLibrary(IQueryClient.class);
        queryClient.addQueryListener("com.ibm.team.workitem.query.event.QueryDeleted", this.fChangeNotifier);
        ((EObject)this.fQueryDescriptor).eAdapters().add((Object)this.fChangeNotifier);
        this.fEditableStatement.addListener((IExpressionListener)this.fChangeNotifier);
    }

    private void disconnectListeners() {
        Assert.isNotNull((Object)this.fEditableStatement);
        IQueryClient queryClient = this.getClientLibrary(IQueryClient.class);
        queryClient.removeQueryListener("com.ibm.team.workitem.query.event.QueryDeleted", this.fChangeNotifier);
        ((EObject)this.fQueryDescriptor).eAdapters().remove((Object)this.fChangeNotifier);
        this.fEditableStatement.removeListener((IExpressionListener)this.fChangeNotifier);
    }

    void initialize(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtils.getProgressMonitor(monitor);
        try {
            monitor.beginTask(Messages.QueryDescriptorWorkingCopy_INITALIZE_QUERY, 100);
            ClientEvaluationContext context = new ClientEvaluationContext(this.fQueryDescriptor.getProjectArea());
            Expression migrated = QueryUtils.migrateWorkItemQuery((IEvaluationContext)context, (Expression)this.fQueryDescriptor.getExpression(), (IProgressMonitor)monitor);
            monitor.worked(50);
            this.fEditableStatement = EditableStatement.createEditableStatement((Expression)migrated, (IEvaluationContext)context, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        finally {
            monitor.done();
        }
    }

    private <T> T getClientLibrary(Class<T> clazz) {
        return (T)this.getRepository().getClientLibrary(clazz);
    }

    private ITeamRepository getRepository() {
        return (ITeamRepository)this.fQueryDescriptor.getOrigin();
    }

    private class ChangeNotifier
    extends EMFListener
    implements IQueryListener,
    IExpressionListener {
        private final ListenerList fListeners = new ListenerList();
        private LinkedList<WorkingCopyChangeEvent> fQueue;

        private ChangeNotifier() {
        }

        public void addListener(IWorkingCopyListener listener) {
            this.fListeners.add((Object)listener);
        }

        public void removeListener(IWorkingCopyListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void startQueuing() {
            this.fQueue = new LinkedList();
        }

        public void stopQueuing() {
            LinkedList<WorkingCopyChangeEvent> queue = this.fQueue;
            this.fQueue = null;
            for (WorkingCopyChangeEvent event : queue) {
                this.notifyListeners(event);
            }
        }

        public void handleEvents(List events) {
            for (Object object : events) {
                QueryChangeEvent event = (QueryChangeEvent)object;
                if (!QueryDescriptorWorkingCopy.this.fQueryDescriptor.sameItemId((IItemHandle)event.getQueryDescriptor())) continue;
                this.queryDescriptorChanged(event);
            }
        }

        protected void featureChanged(Object notifier, EStructuralFeature feature, Object oldValue, Object newValue, int position) {
            if (this.hasChanged(oldValue, newValue)) {
                WorkingCopyChangeEvent event = new WorkingCopyChangeEvent((IQueryDescriptorWorkingCopy)QueryDescriptorWorkingCopy.this, WorkingCopyChangeEvent.EventType.QUERY_ATTRIBUTE_CHANGED, feature.getName());
                this.notifyChanged(event);
            }
        }

        public void expressionChanged(ExpressionChangeEvent expressionEvent) {
            WorkingCopyChangeEvent event = new WorkingCopyChangeEvent((IQueryDescriptorWorkingCopy)QueryDescriptorWorkingCopy.this, WorkingCopyChangeEvent.EventType.EXPRESSION_CHANGED, expressionEvent);
            this.notifyChanged(event);
        }

        public void statementChanged(StatementChangeEvent statementEvent) {
            WorkingCopyChangeEvent event = new WorkingCopyChangeEvent((IQueryDescriptorWorkingCopy)QueryDescriptorWorkingCopy.this, WorkingCopyChangeEvent.EventType.EXPRESSION_CHANGED, statementEvent);
            this.notifyChanged(event);
        }

        private void queryDescriptorChanged(QueryChangeEvent event) {
            if ("com.ibm.team.workitem.query.event.QueryDeleted".equals(event.getEventType())) {
                WorkingCopyChangeEvent workingCopyChangeEvent = new WorkingCopyChangeEvent(QueryDescriptorWorkingCopy.this, WorkingCopyChangeEvent.EventType.QUERY_DELETED);
                this.notifyChanged(workingCopyChangeEvent);
            }
        }

        private void notifyChanged(WorkingCopyChangeEvent event) {
            QueryDescriptorWorkingCopy.this.setDirty(true);
            if (this.fQueue != null) {
                this.fQueue.add(event);
            } else {
                this.notifyListeners(event);
            }
        }

        public void notifySaved() {
            WorkingCopyChangeEvent event = new WorkingCopyChangeEvent(QueryDescriptorWorkingCopy.this, WorkingCopyChangeEvent.EventType.QUERY_SAVED);
            this.notifyListeners(event);
        }

        private void notifyListeners(WorkingCopyChangeEvent event) {
            Object[] objectArray = this.fListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IWorkingCopyListener listener = (IWorkingCopyListener)object;
                listener.workingCopyChanged(event);
                ++n2;
            }
        }

        private boolean hasChanged(Object oldValue, Object newValue) {
            if (oldValue == null || newValue == null) {
                return oldValue != newValue;
            }
            if (oldValue instanceof IItemHandle && newValue instanceof IItemHandle) {
                IItemHandle oldHandle = (IItemHandle)oldValue;
                IItemHandle newHandle = (IItemHandle)newValue;
                return oldHandle.sameItemId(newHandle);
            }
            return !oldValue.equals(newValue);
        }
    }
}

