/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableTypesCache {
    private static final ItemProfile<IProjectArea> PROJECT_AREA_PROFILE = ItemProfile.PROJECT_AREA_DEFAULT.createExtension(new String[]{ProcessCommon.getPropertyName(IProjectArea.class, (String)"teamAreaHierarchy")});
    private IAuditableCommon fAuditableCommon;
    private Map<String, InternalCacheValue<String[]>> fCache = new HashMap<String, InternalCacheValue<String[]>>();

    public AvailableTypesCache(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
    }

    public String[] getValid(ITeamAreaHandle teamArea, String oldWorkflowId) {
        InternalCacheValue<String[]> cache = this.getCacheValue(teamArea, oldWorkflowId);
        if (cache != null && cache.isValid()) {
            return cache.getValue();
        }
        return null;
    }

    public String[] getCached(ITeamAreaHandle teamArea, String oldWorkflowId) {
        InternalCacheValue<String[]> cache = this.getCacheValue(teamArea, oldWorkflowId);
        if (cache != null && cache.isPossiblyValid()) {
            return cache.getValue();
        }
        return null;
    }

    private InternalCacheValue<String[]> getCacheValue(ITeamAreaHandle teamArea, String oldWorkflowId) {
        return this.fCache.get(this.getKey(teamArea, oldWorkflowId));
    }

    public void put(ITeamAreaHandle teamArea, String oldWorkflowId, String[] types, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IAuditableHandle> dependencies = new ArrayList<IAuditableHandle>();
        ITeamArea team = (ITeamArea)this.fAuditableCommon.resolveAuditable((IAuditableHandle)teamArea, ItemProfile.TEAM_AREA_DEFAULT, monitor);
        dependencies.add((IAuditableHandle)team.getStateHandle());
        IProjectArea project = (IProjectArea)this.fAuditableCommon.resolveAuditable((IAuditableHandle)team.getProjectArea(), PROJECT_AREA_PROFILE, monitor);
        dependencies.add((IAuditableHandle)project.getStateHandle());
        ITeamAreaHierarchy hierarchy = project.getTeamAreaHierarchy();
        ITeamAreaHandle handle = hierarchy.getParent((ITeamAreaHandle)team);
        while (handle != null) {
            team = (ITeamArea)this.fAuditableCommon.resolveAuditable((IAuditableHandle)teamArea, ItemProfile.TEAM_AREA_DEFAULT, monitor);
            dependencies.add((IAuditableHandle)team.getStateHandle());
            handle = hierarchy.getParent(handle);
        }
        this.fCache.put(this.getKey(teamArea, oldWorkflowId), new InternalCacheValue<String[]>(this.fAuditableCommon, types, dependencies));
    }

    private String getKey(ITeamAreaHandle teamArea, String oldWorkflowId) {
        return String.valueOf(this.toString((IAuditableHandle)this.fAuditableCommon.getUser())) + this.toString((IAuditableHandle)teamArea) + oldWorkflowId;
    }

    private String toString(IAuditableHandle handle) {
        return handle != null ? handle.getItemId().getUuidValue() : "null";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalCacheValue<T> {
        private IAuditableCommon fAuditableCommon;
        private T fValue;
        private List<IAuditableHandle> fDependencies;

        public InternalCacheValue(IAuditableCommon auditableCommon, T value, List<IAuditableHandle> dependencies) {
            this.fAuditableCommon = auditableCommon;
            this.fValue = value;
            this.fDependencies = dependencies;
        }

        public T getValue() {
            return this.fValue;
        }

        public boolean isValid() {
            for (IAuditableHandle handle : this.fDependencies) {
                IAuditable auditable = this.fAuditableCommon.findCachedAuditable(handle, ItemProfile.createProfile((IItemType)handle.getItemType(), (String[])new String[0]));
                if (auditable != null && auditable.sameStateId((IItemHandle)handle)) continue;
                return false;
            }
            return true;
        }

        public boolean isPossiblyValid() {
            for (IAuditableHandle handle : this.fDependencies) {
                IAuditable auditable = this.fAuditableCommon.findCachedAuditable(handle, ItemProfile.createProfile((IItemType)handle.getItemType(), (String[])new String[0]));
                if (auditable == null || auditable.sameStateId((IItemHandle)handle)) continue;
                return false;
            }
            return true;
        }
    }
}

