/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.client.internal.ModelPlugin;
import com.ibm.team.workitem.client.internal.util.InternalContentTypeUtils;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;

public class ArtifactLink {
    private WorkItemWorkingCopy fWorkingCopy;
    private IReference fReference;
    private IFileStore fFileStore;
    private IContent fContent;
    private String fFutureName;
    private IReference fTemporaryReference;
    IItem fSharedItem;

    public ArtifactLink(WorkItemWorkingCopy workingCopy, IReference reference) {
        this.fWorkingCopy = workingCopy;
        this.fReference = reference;
        try {
            if (reference.isURIReference()) {
                this.fFileStore = EFS.getStore((URI)((IURIReference)reference).getURI());
            }
        }
        catch (CoreException x) {
            ModelPlugin.log(Messages.ArtifactLink_EXCEPTION_CREATING_FILE, (Exception)((Object)x));
        }
        this.grabSharedItem();
    }

    public IReference getReference() {
        return this.fReference;
    }

    public String getId() {
        String text = this.getReference().getComment();
        int begin = text.indexOf(58);
        if (begin == -1) {
            return "";
        }
        return text.substring(0, begin).trim();
    }

    public String getName() {
        if (this.fFutureName != null && !"".equals(this.fFutureName)) {
            return this.fFutureName;
        }
        if (this.fFileStore != null) {
            return this.fFileStore.getName();
        }
        String text = this.getReference().getComment();
        int begin = text.indexOf(58);
        if (begin == -1) {
            return Messages.ArtifactLink_UNNAMED_ATTACHMENT_ENTRY;
        }
        return text.substring(begin + 1).trim();
    }

    public void setName(String name) {
        this.fFutureName = name;
        String id = this.getId();
        String text = name;
        if (id.length() > 0) {
            text = String.valueOf(id) + ": " + name;
        }
        if (text.length() > WorkItemLinkTypes.getMaxReferenceCommentLength()) {
            text = String.valueOf(text.substring(0, WorkItemLinkTypes.getMaxReferenceCommentLength() - 3)) + "...";
        }
        Object reference = this.fReference.isItemReference() ? IReferenceFactory.INSTANCE.createReferenceToItem(((IItemReference)this.fReference).getReferencedItem(), text) : IReferenceFactory.INSTANCE.createReferenceFromURI(((IURIReference)this.fReference).getURI(), text);
        this.setReference((IReference)reference);
    }

    public boolean needsUpload() {
        return this.fFileStore != null && this.fContent == null;
    }

    public long getContentLength() {
        if (this.fFileStore != null) {
            return this.fFileStore.fetchInfo().getLength();
        }
        throw new UnsupportedOperationException();
    }

    public void upload(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fFileStore == null || this.fContent != null) {
            return;
        }
        try {
            IContentDescription contentDescription = InternalContentTypeUtils.getContentDescription(this.fFileStore);
            String mime = InternalContentTypeUtils.getMIMEType(this.fFileStore.getName(), contentDescription);
            String charset = InternalContentTypeUtils.getCharSet(contentDescription, mime);
            this.fContent = this.fWorkingCopy.getTeamRepository().contentManager().storeContent(mime, charset, this.fFileStore.openInputStream(0, monitor), null, monitor);
        }
        catch (CoreException x) {
            throw new TeamRepositoryException((Throwable)x);
        }
    }

    public boolean needsUpdate() {
        return this.fFutureName != null && !this.fFutureName.equals("") || this.getReference().isURIReference();
    }

    public IAttachment createUpdatedAttachment(IProgressMonitor monitor) throws TeamRepositoryException {
        IAttachment attachment = this.getAttachmentOfArtifactLink(monitor);
        if (attachment != null) {
            if ((attachment = (IAttachment)attachment.getWorkingCopy()).getDescription() != null && attachment.getDescription().equals(attachment.getName())) {
                attachment.setDescription(this.fFutureName);
            }
            attachment.setName(this.fFutureName);
            attachment.patchProjectArea(this.fWorkingCopy.getWorkItem().getProjectArea());
        } else {
            IWorkItemClient workItemClient = (IWorkItemClient)this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
            String fileName = this.fFutureName != null && !"".equals(this.fFutureName) ? this.fFutureName : this.fFileStore.getName();
            attachment = workItemClient.createAttachment(this.fWorkingCopy.getWorkItem().getProjectArea(), monitor);
            attachment.setName(fileName);
            attachment.setDescription(fileName);
            Assert.isNotNull((Object)this.fContent);
            attachment.setContent(this.fContent);
        }
        this.fTemporaryReference = this.fReference;
        this.setReference((IReference)WorkItemLinkTypes.createAttachmentReference((IAttachment)attachment));
        return attachment;
    }

    public void updateSuccessful() {
        this.fFileStore = null;
        this.fContent = null;
        this.fFutureName = null;
        this.fTemporaryReference = null;
        this.grabSharedItem();
    }

    public void updateFinished() {
        if (this.fTemporaryReference != null) {
            Object reference = this.fTemporaryReference.isItemReference() ? IReferenceFactory.INSTANCE.createReferenceToItem(((IItemReference)this.fTemporaryReference).getReferencedItem(), this.fTemporaryReference.getComment()) : IReferenceFactory.INSTANCE.createReferenceFromURI(((IURIReference)this.fTemporaryReference).getURI(), this.fTemporaryReference.getComment());
            this.setReference((IReference)reference);
            this.fTemporaryReference = null;
        }
    }

    private void setReference(IReference newReference) {
        IWorkItemClient workItemClient = (IWorkItemClient)this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
        try {
            workingCopyManager.beginCompoundWorkItemChange((IWorkItemHandle)this.fWorkingCopy.getWorkItem());
            this.fWorkingCopy.getReferences().remove(this.fReference);
            this.fWorkingCopy.getReferences().add(WorkItemEndPoints.ATTACHMENT, newReference);
            this.fReference = newReference;
        }
        finally {
            workingCopyManager.endCompoundWorkItemChange((IWorkItemHandle)this.fWorkingCopy.getWorkItem());
        }
    }

    private IAttachment getAttachmentOfArtifactLink(IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(((IItemReference)this.getReference()).getReferencedItem() instanceof IAttachmentHandle)) {
            return null;
        }
        IAuditableClient auditableClient = (IAuditableClient)this.fWorkingCopy.getTeamRepository().getClientLibrary(IAuditableClient.class);
        return (IAttachment)auditableClient.resolveAuditable((IAuditableHandle)((IAttachmentHandle)((IItemReference)this.getReference()).getReferencedItem()), IAttachment.DEFAULT_PROFILE, monitor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArtifactLink)) {
            return false;
        }
        return this.getReference().equals(((ArtifactLink)obj).getReference());
    }

    public int hashCode() {
        return this.getReference().hashCode();
    }

    private void grabSharedItem() {
        IReference reference = this.fReference;
        if (reference != null && ((IItemReference)reference).getReferencedItem() != null) {
            ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
            this.fSharedItem = teamRepository.itemManager().getSharedItemIfKnown(((IItemReference)reference).getReferencedItem());
        }
    }
}

