/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker$AllTracked;
import org.osgi.util.tracker.ServiceTracker$Tracked;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer customizer;
    private final String listenerFilter;
    private final String trackClass;
    private final ServiceReference trackReference;
    final boolean noUserFilter;
    private volatile ServiceTracker$Tracked tracked;
    private volatile int trackingCount = -1;
    private volatile ServiceReference cachedReference;
    private volatile Object cachedService;

    public ServiceTracker(BundleContext bundleContext, String string, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = null;
        this.trackClass = string;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        this.listenerFilter = "(objectClass=" + string.toString() + ")";
        this.noUserFilter = true;
        try {
            this.filter = bundleContext.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw (Throwable)new IllegalArgumentException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
        }
    }

    public ServiceTracker(BundleContext bundleContext, Filter filter, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = null;
        this.trackClass = filter instanceof FilterImpl ? ((FilterImpl)filter).getRequiredObjectClass() : null;
        if (this.trackClass != null) {
            this.listenerFilter = FilterImpl.getObjectClassFilterString(this.trackClass);
            this.noUserFilter = this.listenerFilter.equals(filter.toString());
        } else {
            this.listenerFilter = null;
            this.noUserFilter = false;
        }
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer2 = this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        if (bundleContext == null || filter == null) {
            throw (Throwable)new NullPointerException();
        }
    }

    public void open() {
        this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(boolean bl) {
        if (this.tracked != null) {
            return;
        }
        this.tracked = bl ? new ServiceTracker$AllTracked(this) : new ServiceTracker$Tracked(this);
        this.trackingCount = 0;
        ServiceTracker$Tracked serviceTracker$Tracked = this.tracked;
        synchronized (serviceTracker$Tracked) {
            try {
                this.context.addServiceListener(this.tracked, this.listenerFilter);
                ServiceReference[] serviceReferenceArray = this.trackReference != null ? new ServiceReference[]{this.trackReference} : this.getInitialReferences(bl, this.trackClass, this.noUserFilter ? null : this.filter.toString());
                this.tracked.setInitialServices(serviceReferenceArray);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw (Throwable)new RuntimeException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
            }
        }
        this.tracked.trackInitialServices();
    }

    private ServiceReference[] getInitialReferences(boolean bl, String string, String string2) throws InvalidSyntaxException {
        if (bl) {
            return this.context.getAllServiceReferences(string, string2);
        }
        return this.context.getServiceReferences(string, string2);
    }

    public synchronized void close() {
        if (this.tracked == null) {
            return;
        }
        this.tracked.close();
        ServiceReference[] serviceReferenceArray = this.getServiceReferences();
        ServiceTracker$Tracked serviceTracker$Tracked = this.tracked;
        this.tracked = null;
        try {
            this.context.removeServiceListener(serviceTracker$Tracked);
        }
        catch (IllegalStateException illegalStateException) {}
        if (serviceReferenceArray != null) {
            int n = 0;
            while (n < serviceReferenceArray.length) {
                serviceTracker$Tracked.untrack(serviceReferenceArray[n]);
                ++n;
            }
        }
        this.trackingCount = -1;
    }

    public Object addingService(ServiceReference serviceReference) {
        return this.context.getService(serviceReference);
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        this.context.ungetService(serviceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        ServiceTracker$Tracked serviceTracker$Tracked = this.tracked;
        if (serviceTracker$Tracked == null) {
            return null;
        }
        ServiceTracker$Tracked serviceTracker$Tracked2 = serviceTracker$Tracked;
        synchronized (serviceTracker$Tracked2) {
            int n;
            block6: {
                n = serviceTracker$Tracked.size();
                if (n != 0) break block6;
                return null;
            }
            ServiceReference[] serviceReferenceArray = new ServiceReference[n];
            Enumeration enumeration = serviceTracker$Tracked.keys();
            int n2 = 0;
            while (n2 < n) {
                serviceReferenceArray[n2] = (ServiceReference)enumeration.nextElement();
                ++n2;
            }
            return serviceReferenceArray;
        }
    }

    public ServiceReference getServiceReference() {
        int n;
        ServiceReference serviceReference = this.cachedReference;
        if (serviceReference != null) {
            return serviceReference;
        }
        ServiceReference[] serviceReferenceArray = this.getServiceReferences();
        int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
        if (n == 0) {
            return null;
        }
        int n3 = 0;
        if (n > 1) {
            int n4;
            int[] nArray = new int[n];
            int n5 = 0;
            int n6 = Integer.MIN_VALUE;
            int n7 = 0;
            while (n7 < n) {
                Object object = serviceReferenceArray[n7].getProperty("service.ranking");
                nArray[n7] = n4 = object instanceof Integer ? (Integer)object : 0;
                if (n4 > n6) {
                    n3 = n7;
                    n6 = n4;
                    n5 = 1;
                } else if (n4 == n6) {
                    ++n5;
                }
                ++n7;
            }
            if (n5 > 1) {
                long l = Long.MAX_VALUE;
                n4 = 0;
                while (n4 < n) {
                    long l2;
                    if (nArray[n4] == n6 && (l2 = ((Long)serviceReferenceArray[n4].getProperty("service.id")).longValue()) < l) {
                        n3 = n4;
                        l = l2;
                    }
                    ++n4;
                }
            }
        }
        this.cachedReference = serviceReferenceArray[n3];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference serviceReference) {
        ServiceTracker$Tracked serviceTracker$Tracked = this.tracked;
        if (serviceTracker$Tracked == null) {
            return null;
        }
        ServiceTracker$Tracked serviceTracker$Tracked2 = serviceTracker$Tracked;
        synchronized (serviceTracker$Tracked2) {
            return serviceTracker$Tracked.get(serviceReference);
        }
    }

    public Object getService() {
        Object object = this.cachedService;
        if (object != null) {
            return object;
        }
        ServiceReference serviceReference = this.getServiceReference();
        if (serviceReference == null) {
            return null;
        }
        this.cachedService = this.getService(serviceReference);
        return this.cachedService;
    }

    public int getTrackingCount() {
        return this.trackingCount;
    }

    void modified() {
        ++this.trackingCount;
        this.cachedReference = null;
        this.cachedService = null;
    }

    public ServiceTracker(BundleContext bundleContext, ServiceReference serviceReference, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = serviceReference;
        this.trackClass = null;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        this.listenerFilter = "(&(objectClass=" + ((String[])serviceReference.getProperty("objectClass"))[0] + ")(" + "service.id" + "=" + serviceReference.getProperty("service.id").toString() + "))";
        this.noUserFilter = true;
        try {
            this.filter = bundleContext.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw (Throwable)new IllegalArgumentException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long l) throws InterruptedException {
        if (l < 0L) {
            throw (Throwable)new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            ServiceTracker$Tracked serviceTracker$Tracked = this.tracked;
            if (serviceTracker$Tracked == null) {
                return null;
            }
            ServiceTracker$Tracked serviceTracker$Tracked2 = serviceTracker$Tracked;
            synchronized (serviceTracker$Tracked2) {
                if (serviceTracker$Tracked.size() == 0) {
                    serviceTracker$Tracked.wait(l);
                }
            }
            object = this.getService();
            if (l <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        ServiceTracker$Tracked serviceTracker$Tracked = this.tracked;
        if (serviceTracker$Tracked == null) {
            return null;
        }
        ServiceTracker$Tracked serviceTracker$Tracked2 = serviceTracker$Tracked;
        synchronized (serviceTracker$Tracked2) {
            int n;
            ServiceReference[] serviceReferenceArray;
            block6: {
                serviceReferenceArray = this.getServiceReferences();
                int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
                if (n != 0) break block6;
                return null;
            }
            Object[] objectArray = new Object[n];
            int n3 = 0;
            while (n3 < n) {
                objectArray[n3] = this.getService(serviceReferenceArray[n3]);
                ++n3;
            }
            return objectArray;
        }
    }

    public void remove(ServiceReference serviceReference) {
        ServiceTracker$Tracked serviceTracker$Tracked = this.tracked;
        if (serviceTracker$Tracked == null) {
            return;
        }
        serviceTracker$Tracked.untrack(serviceReference);
    }

    public int size() {
        ServiceTracker$Tracked serviceTracker$Tracked = this.tracked;
        if (serviceTracker$Tracked == null) {
            return 0;
        }
        return serviceTracker$Tracked.size();
    }
}

