/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.util.ArrayList;

public class ConditionInfo {
    private String type;
    private String[] args;

    public ConditionInfo(String string, String[] stringArray) {
        this.type = string;
        String[] stringArray2 = this.args = stringArray != null ? stringArray : new String[]{};
        if (string == null) {
            throw (Throwable)new NullPointerException("type is null");
        }
    }

    public ConditionInfo(String string) {
        if (string == null) {
            throw (Throwable)new NullPointerException("missing encoded condition");
        }
        if (string.length() == 0) {
            throw (Throwable)new IllegalArgumentException("empty encoded condition");
        }
        try {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (cArray[n2] != '[') {
                throw (Throwable)new IllegalArgumentException("expecting open bracket");
            }
            ++n2;
            while (Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            int n3 = n2;
            while (!Character.isWhitespace(cArray[n2]) && cArray[n2] != ']') {
                ++n2;
            }
            if (n2 == n3 || cArray[n3] == '\"') {
                throw (Throwable)new IllegalArgumentException("expecting type");
            }
            this.type = new String(cArray, n3, n2 - n3);
            while (Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (cArray[n2] == '\"') {
                n3 = ++n2;
                while (cArray[n2] != '\"') {
                    if (cArray[n2] == '\\') {
                        ++n2;
                    }
                    ++n2;
                }
                arrayList.add(ConditionInfo.unescapeString(cArray, n3, n2));
                if (!Character.isWhitespace(cArray[++n2])) continue;
                while (Character.isWhitespace(cArray[n2])) {
                    ++n2;
                }
            }
            this.args = arrayList.toArray(new String[arrayList.size()]);
            char c = cArray[n2];
            ++n2;
            while (n2 < n && Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (c != ']' || n2 != n) {
                throw (Throwable)new IllegalArgumentException("expecting close bracket");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw (Throwable)new IllegalArgumentException("parsing terminated abruptly");
        }
    }

    public final String getEncoded() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(this.type);
        int n = 0;
        while (n < this.args.length) {
            stringBuffer.append(" \"");
            ConditionInfo.escapeString(this.args[n], stringBuffer);
            stringBuffer.append('\"');
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getEncoded();
    }

    public final String getType() {
        return this.type;
    }

    public final String[] getArgs() {
        return this.args;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConditionInfo)) {
            return false;
        }
        ConditionInfo conditionInfo = (ConditionInfo)object;
        if (!this.type.equals(conditionInfo.type) || this.args.length != conditionInfo.args.length) {
            return false;
        }
        int n = 0;
        while (n < this.args.length) {
            if (!this.args[n].equals(conditionInfo.args[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        int n2 = 0;
        while (n2 < this.args.length) {
            n ^= this.args[n2].hashCode();
            ++n2;
        }
        return n;
    }

    private static void escapeString(String string, StringBuffer stringBuffer) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
    }

    private static String unescapeString(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        int n3 = n;
        while (n3 < n2) {
            int n4 = cArray[n3];
            if (n4 == 92 && ++n3 < n2) {
                n4 = cArray[n3];
                switch (n4) {
                    case 34: 
                    case 92: {
                        break;
                    }
                    case 114: {
                        n4 = 13;
                        break;
                    }
                    case 110: {
                        n4 = 10;
                        break;
                    }
                    default: {
                        n4 = 92;
                        --n3;
                    }
                }
            }
            stringBuffer.append((char)n4);
            ++n3;
        }
        return stringBuffer.toString();
    }
}

