/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.ServicePermissionCollection;

public final class ServicePermission
extends BasicPermission {
    static final long serialVersionUID = -7662148639076511574L;
    public static final String GET = "get";
    public static final String REGISTER = "register";
    private static final int ACTION_GET = 1;
    private static final int ACTION_REGISTER = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private transient int action_mask = 0;
    private String actions = null;

    public ServicePermission(String string, String string2) {
        this(string, ServicePermission.getMask(string2));
    }

    ServicePermission(String string, int n) {
        super(string);
        this.init(n);
    }

    private void init(int n) {
        if (n == 0 || (n & 3) != n) {
            throw (Throwable)new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl33
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 2 || var3_3[var4_4 - 2] != 'g' && var3_3[var4_4 - 2] != 'G' || var3_3[var4_4 - 1] != 'e' && var3_3[var4_4 - 1] != 'E' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 3;
                    var2_2 |= 1;
                } else if (!(var4_4 < 7 || var3_3[var4_4 - 7] != 'r' && var3_3[var4_4 - 7] != 'R' || var3_3[var4_4 - 6] != 'e' && var3_3[var4_4 - 6] != 'E' || var3_3[var4_4 - 5] != 'g' && var3_3[var4_4 - 5] != 'G' || var3_3[var4_4 - 4] != 'i' && var3_3[var4_4 - 4] != 'I' || var3_3[var4_4 - 3] != 's' && var3_3[var4_4 - 3] != 'S' || var3_3[var4_4 - 2] != 't' && var3_3[var4_4 - 2] != 'T' || var3_3[var4_4 - 1] != 'e' && var3_3[var4_4 - 1] != 'E' || var3_3[var4_4] != 'r' && var3_3[var4_4] != 'R')) {
                    var6_6 = 8;
                    var2_2 |= 2;
                } else {
                    throw (Throwable)new IllegalArgumentException("invalid permission: " + var0);
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw (Throwable)new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl33:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw (Throwable)new IllegalArgumentException("invalid permission: " + var0);
        }
        return var2_2;
    }

    public boolean implies(Permission permission) {
        if (permission instanceof ServicePermission) {
            ServicePermission servicePermission = (ServicePermission)permission;
            return (this.action_mask & servicePermission.action_mask) == servicePermission.action_mask && super.implies(permission);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if ((this.action_mask & 1) == 1) {
                stringBuffer.append(GET);
                bl = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(REGISTER);
            }
            this.actions = stringBuffer.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new ServicePermissionCollection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)object;
        return this.action_mask == servicePermission.action_mask && this.getName().equals(servicePermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(ServicePermission.getMask(this.actions));
    }
}

