/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.BundlePermissionCollection;

public final class BundlePermission
extends BasicPermission {
    private static final long serialVersionUID = 3257846601685873716L;
    public static final String PROVIDE = "provide";
    public static final String REQUIRE = "require";
    public static final String HOST = "host";
    public static final String FRAGMENT = "fragment";
    private static final int ACTION_PROVIDE = 1;
    private static final int ACTION_REQUIRE = 2;
    private static final int ACTION_HOST = 4;
    private static final int ACTION_FRAGMENT = 8;
    private static final int ACTION_ALL = 15;
    private static final int ACTION_NONE = 0;
    private transient int action_mask = 0;
    private String actions = null;

    public BundlePermission(String string, String string2) {
        this(string, BundlePermission.getMask(string2));
    }

    BundlePermission(String string, int n) {
        super(string);
        this.init(n);
    }

    private void init(int n) {
        if (n == 0 || (n & 0xF) != n) {
            throw (Throwable)new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl41
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'p' && var3_3[var4_4 - 6] != 'P' || var3_3[var4_4 - 5] != 'r' && var3_3[var4_4 - 5] != 'R' || var3_3[var4_4 - 4] != 'o' && var3_3[var4_4 - 4] != 'O' || var3_3[var4_4 - 3] != 'v' && var3_3[var4_4 - 3] != 'V' || var3_3[var4_4 - 2] != 'i' && var3_3[var4_4 - 2] != 'I' || var3_3[var4_4 - 1] != 'd' && var3_3[var4_4 - 1] != 'D' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 3;
                } else if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'r' && var3_3[var4_4 - 6] != 'R' || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 'q' && var3_3[var4_4 - 4] != 'Q' || var3_3[var4_4 - 3] != 'u' && var3_3[var4_4 - 3] != 'U' || var3_3[var4_4 - 2] != 'i' && var3_3[var4_4 - 2] != 'I' || var3_3[var4_4 - 1] != 'r' && var3_3[var4_4 - 1] != 'R' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 2;
                } else if (!(var4_4 < 3 || var3_3[var4_4 - 3] != 'h' && var3_3[var4_4 - 3] != 'H' || var3_3[var4_4 - 2] != 'o' && var3_3[var4_4 - 2] != 'O' || var3_3[var4_4 - 1] != 's' && var3_3[var4_4 - 1] != 'S' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 4;
                    var2_2 |= 4;
                } else if (!(var4_4 < 7 || var3_3[var4_4 - 7] != 'f' && var3_3[var4_4 - 7] != 'F' || var3_3[var4_4 - 6] != 'r' && var3_3[var4_4 - 6] != 'R' || var3_3[var4_4 - 5] != 'a' && var3_3[var4_4 - 5] != 'A' || var3_3[var4_4 - 4] != 'g' && var3_3[var4_4 - 4] != 'G' || var3_3[var4_4 - 3] != 'm' && var3_3[var4_4 - 3] != 'M' || var3_3[var4_4 - 2] != 'e' && var3_3[var4_4 - 2] != 'E' || var3_3[var4_4 - 1] != 'n' && var3_3[var4_4 - 1] != 'N' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 8;
                    var2_2 |= 8;
                } else {
                    throw (Throwable)new IllegalArgumentException("invalid permission: " + var0);
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw (Throwable)new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl41:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw (Throwable)new IllegalArgumentException("invalid permission: " + var0);
        }
        return var2_2;
    }

    public boolean implies(Permission permission) {
        if (permission instanceof BundlePermission) {
            BundlePermission bundlePermission = (BundlePermission)permission;
            return (this.action_mask & bundlePermission.action_mask) == bundlePermission.action_mask && super.implies(permission);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if ((this.action_mask & 1) == 1) {
                stringBuffer.append(PROVIDE);
                bl = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(REQUIRE);
                bl = true;
            }
            if ((this.action_mask & 4) == 4) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(HOST);
                bl = true;
            }
            if ((this.action_mask & 8) == 8) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(FRAGMENT);
            }
            this.actions = stringBuffer.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new BundlePermissionCollection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BundlePermission)) {
            return false;
        }
        BundlePermission bundlePermission = (BundlePermission)object;
        return this.action_mask == bundlePermission.action_mask && this.getName().equals(bundlePermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(BundlePermission.getMask(this.actions));
    }
}

