/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storagemanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.security.AccessController;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.Locker;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileInputStream;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileOutputStream;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.storagemanager.ManagedOutputStream;
import org.eclipse.osgi.storagemanager.StorageManager$$Cold;
import org.eclipse.osgi.storagemanager.StorageManager$Entry;

public final class StorageManager {
    private static final int FILETYPE_STANDARD = 0;
    private static final int FILETYPE_RELIABLEFILE = 1;
    private static final SecureAction secure = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    private static boolean tempCleanup = Boolean.valueOf(secure.getProperty("osgi.embedded.cleanTempFiles"));
    private static boolean openCleanup = Boolean.valueOf(secure.getProperty("osgi.embedded.cleanupOnOpen"));
    private static final String MANAGER_FOLDER = ".manager";
    private static final String TABLE_FILE = ".fileTable";
    private static final String LOCK_FILE = ".fileTableLock";
    private static final int MAX_LOCK_WAIT = 5000;
    private File base;
    private File managerRoot;
    private String lockMode = null;
    private File tableFile = null;
    private File lockFile;
    private Locker locker;
    private File instanceFile = null;
    private Locker instanceLocker = null;
    private boolean readOnly;
    private boolean open;
    private int tableStamp = -1;
    private Properties table = new Properties();
    private boolean useReliableFiles = Boolean.valueOf(secure.getProperty("osgi.useReliableFiles"));

    public StorageManager(File file, String string) {
        this(file, string, false);
    }

    public StorageManager(File file, String string, boolean bl) {
        this.base = file;
        this.lockMode = string;
        this.managerRoot = new File(file, MANAGER_FOLDER);
        if (!bl) {
            this.managerRoot.mkdirs();
        }
        this.tableFile = new File(this.managerRoot, TABLE_FILE);
        this.lockFile = new File(this.managerRoot, LOCK_FILE);
        this.readOnly = bl;
        this.open = false;
    }

    private void initializeInstanceFile() throws IOException {
        if (this.instanceFile != null || this.readOnly) {
            return;
        }
        this.instanceFile = File.createTempFile(".tmp", ".instance", this.managerRoot);
        this.instanceFile.deleteOnExit();
        this.instanceLocker = BasicLocation.createLocker(this.instanceFile, this.lockMode);
        this.instanceLocker.lock();
    }

    private String getAbsolutePath(String string) {
        return new File(this.base, string).getAbsolutePath();
    }

    public void add(String string) throws IOException {
        this.add(string, 0);
    }

    private void add(String string, int n) throws IOException {
        if (!this.open) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_notOpen);
        }
        if (this.readOnly) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_illegalInReadOnlyMode);
        }
        if (!this.lock(true)) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
        }
        try {
            this.updateTable();
            StorageManager$Entry storageManager$Entry = (StorageManager$Entry)this.table.get(string);
            if (storageManager$Entry == null) {
                storageManager$Entry = new StorageManager$Entry(this, 0, 1, n);
                this.table.put(string, storageManager$Entry);
                int n2 = this.findOldestGeneration(string);
                if (n2 != 0) {
                    storageManager$Entry.setWriteId(n2 + 1);
                }
                this.save();
            } else if (storageManager$Entry.getFileType() != n) {
                storageManager$Entry.setFileType(n);
                this.updateTable();
                this.save();
            }
        }
        finally {
            this.release();
        }
    }

    private int findOldestGeneration(String string) {
        String[] stringArray = this.base.list();
        int n = 0;
        if (stringArray != null) {
            String string2 = String.valueOf(string) + '.';
            int n2 = string2.length();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].startsWith(string2)) {
                    try {
                        int n4 = Integer.parseInt(stringArray[n3].substring(n2));
                        if (n4 > n) {
                            n = n4;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++n3;
            }
        }
        return n;
    }

    public void update(String[] stringArray, String[] stringArray2) throws IOException {
        if (!this.open) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_notOpen);
        }
        if (this.readOnly) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_illegalInReadOnlyMode);
        }
        if (!this.lock(true)) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
        }
        try {
            this.updateTable();
            int[] nArray = new int[stringArray.length];
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                nArray[n] = this.getId(stringArray[n]);
                if (!this.update(stringArray[n], stringArray2[n])) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                n = 0;
                while (n < stringArray.length) {
                    StorageManager$Entry storageManager$Entry = (StorageManager$Entry)this.table.get(stringArray[n]);
                    storageManager$Entry.setReadId(nArray[n]);
                    ++n;
                }
                throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_updateFailed);
            }
            this.save();
        }
        finally {
            this.release();
        }
    }

    public File getBase() {
        return this.base;
    }

    public int getId(String string) {
        if (!this.open) {
            return -1;
        }
        StorageManager$Entry storageManager$Entry = (StorageManager$Entry)this.table.get(string);
        if (storageManager$Entry == null) {
            return -1;
        }
        return storageManager$Entry.getReadId();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private boolean lock(boolean bl) throws IOException {
        long l;
        boolean bl2;
        if (this.readOnly) {
            return false;
        }
        if (this.locker == null) {
            this.locker = BasicLocation.createLocker(this.lockFile, this.lockMode);
            if (this.locker == null) {
                throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
            }
        }
        if ((bl2 = this.locker.lock()) || !bl) {
            return bl2;
        }
        long l2 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            bl2 = this.locker.lock();
            if (!bl2) continue;
            return true;
        } while ((l = System.currentTimeMillis() - l2) <= 5000L);
        return false;
    }

    public File lookup(String string, boolean bl) throws IOException {
        if (!this.open) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_notOpen);
        }
        StorageManager$Entry storageManager$Entry = (StorageManager$Entry)this.table.get(string);
        if (storageManager$Entry == null) {
            if (bl) {
                this.add(string);
                storageManager$Entry = (StorageManager$Entry)this.table.get(string);
            } else {
                return null;
            }
        }
        return new File(this.getAbsolutePath(String.valueOf(string) + '.' + storageManager$Entry.getReadId()));
    }

    private boolean move(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists() || file2.exists()) {
            return false;
        }
        return file.renameTo(file2);
    }

    private void release() {
        if (this.locker == null) {
            return;
        }
        this.locker.release();
    }

    private void updateTable() throws IOException {
        Object object;
        int n = ReliableFile.lastModifiedVersion(this.tableFile);
        if (n == this.tableStamp || n == -1) {
            return;
        }
        Properties properties = new Properties();
        try {
            object = new ReliableFileInputStream(this.tableFile);
            try {
                properties.load((InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            throw (Throwable)iOException;
        }
        this.tableStamp = n;
        object = properties.keys();
        while (object.hasMoreElements()) {
            int n2;
            int n3;
            String string = (String)object.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            StorageManager$Entry storageManager$Entry = (StorageManager$Entry)this.table.get(string);
            int n4 = string2.indexOf(44);
            if (n4 != -1) {
                n3 = Integer.parseInt(string2.substring(0, n4));
                n2 = Integer.parseInt(string2.substring(n4 + 1));
            } else {
                n3 = Integer.parseInt(string2);
                n2 = 0;
            }
            if (storageManager$Entry == null) {
                this.table.put(string, new StorageManager$Entry(this, n3, n3 + 1, n2));
                continue;
            }
            storageManager$Entry.setWriteId(n3 + 1);
        }
    }

    private void save() throws IOException {
        if (this.readOnly) {
            return;
        }
        this.updateTable();
        Properties properties = new Properties();
        Object object = this.table.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            StorageManager$Entry storageManager$Entry = (StorageManager$Entry)this.table.get(string);
            String string2 = storageManager$Entry.getFileType() != 0 ? String.valueOf(Integer.toString(storageManager$Entry.getWriteId() - 1)) + ',' + Integer.toString(storageManager$Entry.getFileType()) : Integer.toString(storageManager$Entry.getWriteId() - 1);
            properties.put(string, string2);
        }
        object = new ReliableFileOutputStream(this.tableFile);
        try {
            boolean bl = true;
            try {
                properties.store((OutputStream)object, "safe table");
                ((ReliableFileOutputStream)object).close();
                bl = false;
            }
            finally {
                if (bl) {
                    ((ReliableFileOutputStream)object).abort();
                }
            }
        }
        catch (IOException iOException) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_couldNotSave);
        }
        this.tableStamp = ReliableFile.lastModifiedVersion(this.tableFile);
    }

    private boolean update(String string, String string2) throws IOException {
        StorageManager$Entry storageManager$Entry = (StorageManager$Entry)this.table.get(string);
        if (storageManager$Entry == null) {
            this.add(string);
        }
        int n = storageManager$Entry.getWriteId();
        boolean bl = this.move(this.getAbsolutePath(string2), String.valueOf(this.getAbsolutePath(string)) + '.' + n);
        if (!bl) {
            n = this.findOldestGeneration(string) + 1;
            bl = this.move(this.getAbsolutePath(string2), String.valueOf(this.getAbsolutePath(string)) + '.' + n);
        }
        if (!bl) {
            return false;
        }
        storageManager$Entry.setReadId(n);
        storageManager$Entry.setWriteId(n + 1);
        return true;
    }

    /*
     * Exception decompiling
     */
    private void cleanup() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteCopies(String string, String string2) {
        String string3 = String.valueOf(string) + '.' + string2;
        String[] stringArray = this.base.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(String.valueOf(string) + '.') && !stringArray[n].equals(string3)) {
                new File(this.base, stringArray[n]).delete();
            }
            ++n;
        }
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.readOnly) {
            return;
        }
        try {
            this.cleanup();
        }
        catch (IOException iOException) {}
        if (this.instanceLocker != null) {
            this.instanceLocker.release();
        }
        if (this.instanceFile != null) {
            this.instanceFile.delete();
        }
    }

    public void open(boolean bl) throws IOException {
        boolean bl2;
        if (openCleanup) {
            this.cleanup();
        }
        if (!this.readOnly && !(bl2 = this.lock(bl)) && bl) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
        }
        try {
            this.initializeInstanceFile();
            this.updateTable();
            this.open = true;
        }
        finally {
            this.release();
        }
    }

    public File createTempFile(String string) throws IOException {
        if (this.readOnly) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_illegalInReadOnlyMode);
        }
        File file = File.createTempFile(string, ".tmp", this.base);
        file.deleteOnExit();
        return file;
    }

    public InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, 0);
    }

    private InputStream getInputStream(String string, int n) throws IOException {
        if (this.useReliableFiles) {
            int n2 = this.getId(string);
            if (n2 == -1) {
                return null;
            }
            return new ReliableFileInputStream(new File(this.getBase(), string), n2, n);
        }
        File file = this.lookup(string, false);
        if (file == null) {
            return null;
        }
        return new FileInputStream(file);
    }

    public ManagedOutputStream getOutputStream(String string) throws IOException {
        if (this.useReliableFiles) {
            ReliableFileOutputStream reliableFileOutputStream = new ReliableFileOutputStream(new File(this.getBase(), string));
            return new ManagedOutputStream(reliableFileOutputStream, this, string, null);
        }
        File file = this.createTempFile(string);
        return new ManagedOutputStream(new FileOutputStream(file), this, string, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void closeOutputStream(ManagedOutputStream managedOutputStream) throws IOException {
        String[] stringArray;
        Object object;
        ManagedOutputStream[] managedOutputStreamArray;
        if (managedOutputStream.getState() != 0) {
            return;
        }
        ManagedOutputStream[] managedOutputStreamArray2 = managedOutputStream.getStreamSet();
        if (managedOutputStream.getOutputFile() == null) {
            managedOutputStreamArray = (ReliableFileOutputStream)managedOutputStream.getOutputStream();
            object = managedOutputStreamArray.closeIntermediateFile();
            managedOutputStream.setState(1);
            stringArray = managedOutputStream.getTarget();
            if (managedOutputStreamArray2 == null) {
                this.add((String)stringArray, 1);
                this.update(new String[]{managedOutputStream.getTarget()}, new String[]{((File)object).getName()});
                ReliableFile.fileUpdated(new File(this.getBase(), managedOutputStream.getTarget()));
            }
        } else {
            managedOutputStreamArray = managedOutputStream.getOutputStream();
            managedOutputStreamArray.flush();
            try {
                ((FileOutputStream)managedOutputStreamArray).getFD().sync();
            }
            catch (SyncFailedException syncFailedException) {}
            managedOutputStreamArray.close();
            managedOutputStream.setState(1);
            object = managedOutputStream.getTarget();
            if (managedOutputStreamArray2 == null) {
                this.add((String)object, 0);
                this.update(new String[]{object}, new String[]{managedOutputStream.getOutputFile().getName()});
            }
        }
        if (managedOutputStreamArray2 == null) return;
        managedOutputStreamArray = managedOutputStreamArray2;
        synchronized (managedOutputStreamArray2) {
            int n = 0;
            while (n < managedOutputStreamArray2.length) {
                if (managedOutputStreamArray2[n].getState() == 0) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                ++n;
            }
            String[] stringArray2 = new String[managedOutputStreamArray2.length];
            stringArray = new String[managedOutputStreamArray2.length];
            int n2 = 0;
            while (n2 < managedOutputStreamArray2.length) {
                managedOutputStream = managedOutputStreamArray2[n2];
                stringArray2[n2] = managedOutputStream.getTarget();
                File file = managedOutputStream.getOutputFile();
                if (file == null) {
                    this.add(managedOutputStream.getTarget(), 1);
                    ReliableFileOutputStream reliableFileOutputStream = (ReliableFileOutputStream)managedOutputStream.getOutputStream();
                    File file2 = reliableFileOutputStream.closeIntermediateFile();
                    stringArray[n2] = file2.getName();
                    ReliableFile.fileUpdated(new File(this.getBase(), managedOutputStream.getTarget()));
                } else {
                    this.add(managedOutputStream.getTarget(), 0);
                    stringArray[n2] = file.getName();
                }
                ++n2;
            }
            this.update(stringArray2, stringArray);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String[] getManagedFiles() {
        if (!this.open) {
            return null;
        }
        Set<Object> set = this.table.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = new String(stringArray[n]);
            ++n;
        }
        return stringArray2;
    }

    public void remove(String string) throws IOException {
        if (!this.open) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_notOpen);
        }
        if (this.readOnly) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_illegalInReadOnlyMode);
        }
        if (!this.lock(true)) {
            throw (Throwable)new IOException(EclipseAdaptorMsg.fileManager_cannotLock);
        }
        try {
            this.updateTable();
            this.table.remove(string);
            this.save();
        }
        finally {
            this.release();
        }
    }

    public InputStream[] getInputStreamSet(String[] stringArray) throws IOException {
        InputStream[] inputStreamArray = new InputStream[stringArray.length];
        int n = 0;
        while (n < inputStreamArray.length) {
            inputStreamArray[n] = this.getInputStream(stringArray[n], 1);
            ++n;
        }
        return inputStreamArray;
    }

    public ManagedOutputStream[] getOutputStreamSet(String[] stringArray) throws IOException {
        return StorageManager$$Cold.getOutputStreamSet(this, stringArray);
    }

    void abortOutputStream(ManagedOutputStream managedOutputStream) throws  {
        StorageManager$$Cold.abortOutputStream(this, managedOutputStream);
    }
}

