/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.service.resolver;

import org.osgi.framework.Version;

public class VersionRange {
    private static final Version versionMax = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final VersionRange emptyRange = new VersionRange(null);
    private Version minVersion;
    private boolean includeMin;
    private Version maxVersion;
    private boolean includeMax;

    public VersionRange(Version version, boolean bl, Version version2, boolean bl2) {
        this.minVersion = version;
        this.includeMin = bl;
        this.maxVersion = version2;
        this.includeMax = bl2;
    }

    public VersionRange(String string) {
        if (string == null || string.length() == 0) {
            this.minVersion = Version.emptyVersion;
            this.includeMin = true;
            this.maxVersion = versionMax;
            this.includeMax = true;
            return;
        }
        if ((string = string.trim()).charAt(0) == '[' || string.charAt(0) == '(') {
            int n = string.indexOf(44);
            if (n < 0) {
                throw (Throwable)new IllegalArgumentException();
            }
            char c = string.charAt(string.length() - 1);
            if (c != ']' && c != ')') {
                throw (Throwable)new IllegalArgumentException();
            }
            this.minVersion = Version.parseVersion(string.substring(1, n).trim());
            this.includeMin = string.charAt(0) == '[';
            this.maxVersion = Version.parseVersion(string.substring(n + 1, string.length() - 1).trim());
            this.includeMax = c == ']';
        } else {
            this.minVersion = Version.parseVersion(string.trim());
            this.includeMin = true;
            this.maxVersion = versionMax;
            this.includeMax = true;
        }
    }

    public Version getMinimum() {
        return this.minVersion;
    }

    public boolean getIncludeMinimum() {
        return this.includeMin;
    }

    public Version getMaximum() {
        return this.maxVersion;
    }

    public boolean getIncludeMaximum() {
        return this.includeMax;
    }

    public boolean isIncluded(Version version) {
        int n;
        Version version2 = this.getMinimum();
        if (version2 == null) {
            return true;
        }
        if (version == null) {
            return false;
        }
        Version version3 = this.getMaximum() == null ? versionMax : this.getMaximum();
        int n2 = this.includeMin ? 0 : 1;
        int n3 = n = this.includeMax ? 0 : -1;
        return version.compareTo(version2) >= n2 && version.compareTo(version3) <= n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof VersionRange)) {
            return false;
        }
        VersionRange versionRange = (VersionRange)object;
        if (this.minVersion == null || versionRange.getMinimum() == null) return this.minVersion == versionRange.getMinimum();
        if (!this.minVersion.equals(versionRange.getMinimum()) || this.includeMin != versionRange.includeMin) return false;
        if (this.maxVersion == null || versionRange.getMaximum() == null) return this.maxVersion == versionRange.getMaximum();
        if (!this.maxVersion.equals(versionRange.getMaximum()) || this.includeMax != versionRange.includeMax) return false;
        return true;
    }

    public String toString() {
        if (this.minVersion == null) {
            return Version.emptyVersion.toString();
        }
        if (versionMax.equals(this.maxVersion)) {
            return this.minVersion.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.includeMin ? (char)'[' : '(');
        stringBuffer.append(this.minVersion);
        stringBuffer.append(',');
        stringBuffer.append(this.maxVersion);
        stringBuffer.append(this.includeMax ? (char)']' : ')');
        return stringBuffer.toString();
    }
}

