/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.security.Security;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory;
import org.eclipse.osgi.internal.verifier.DefaultTrustAuthority;
import org.eclipse.osgi.internal.verifier.JarVerifierConstant;
import org.eclipse.osgi.internal.verifier.SignedBundleFile;
import org.eclipse.osgi.internal.verifier.SignedBundleHook$$Cold;
import org.eclipse.osgi.internal.verifier.SignedStorageHook;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class SignedBundleHook
implements AdaptorHook,
BundleFileWrapperFactoryHook,
HookConfigurator,
CertificateVerifierFactory {
    static final int VERIFY_CERTIFICATE = 1;
    static final int VERIFY_TRUST = 2;
    static final int VERIFY_RUNTIME = 4;
    static final int VERIFY_ALL = 7;
    private static String SUPPORT_CERTIFICATE = "certificate";
    private static String SUPPORT_TRUST = "trust";
    private static String SUPPORT_RUNTIME = "runtime";
    private static String SUPPORT_ALL = "all";
    private static String SUPPORT_TRUE = "true";
    private static ServiceTracker trustAuthorityTracker;
    private static BaseAdaptor ADAPTOR;
    private static String SIGNED_BUNDLE_SUPPORT;
    private static int supportSignedBundles;
    private static CertificateTrustAuthority trustAuthority;
    private ServiceRegistration certVerifierReg;
    private ServiceRegistration trustAuthorityReg;
    static Class class$0;
    static Class class$1;

    static {
        SIGNED_BUNDLE_SUPPORT = "osgi.support.signature.verify";
        trustAuthority = new DefaultTrustAuthority(7);
    }

    public void initialize(BaseAdaptor baseAdaptor) {
        ADAPTOR = baseAdaptor;
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        this.certVerifierReg = bundleContext.registerService(clazz.getName(), (Object)this, null);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(7);
        hashtable.put("service.ranking", new Integer(Integer.MIN_VALUE));
        hashtable.put("osgi.certificate.trust.authority", JarVerifierConstant.DEFAULT_TRUST_AUTHORITY);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        this.trustAuthorityReg = bundleContext.registerService(clazz2.getName(), (Object)trustAuthority, (Dictionary)hashtable);
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        if (this.certVerifierReg != null) {
            this.certVerifierReg.unregister();
            this.certVerifierReg = null;
        }
        if (this.trustAuthorityReg != null) {
            this.trustAuthorityReg.unregister();
            this.trustAuthorityReg = null;
        }
        if (trustAuthorityTracker != null) {
            trustAuthorityTracker.close();
            trustAuthorityTracker = null;
        }
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable throwable) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook(this);
        String[] stringArray = ManifestElement.getArrayFromList(FrameworkProperties.getProperty(SIGNED_BUNDLE_SUPPORT), ",");
        int n = 0;
        while (n < stringArray.length) {
            if (SUPPORT_CERTIFICATE.equals(stringArray[n])) {
                supportSignedBundles |= 1;
            } else if (SUPPORT_TRUST.equals(stringArray[n])) {
                supportSignedBundles |= 3;
            } else if (SUPPORT_RUNTIME.equals(stringArray[n])) {
                supportSignedBundles |= 5;
            } else if (SUPPORT_TRUE.equals(stringArray[n]) || SUPPORT_ALL.equals(stringArray[n])) {
                supportSignedBundles |= 7;
            }
            ++n;
        }
        if ((supportSignedBundles & 1) != 0) {
            hookRegistry.addStorageHook(new SignedStorageHook());
            hookRegistry.addBundleFileWrapperFactoryHook(this);
        }
    }

    static BundleContext getContext() {
        if (ADAPTOR == null) {
            return null;
        }
        return ADAPTOR.getContext();
    }

    public boolean matchDNChain(String string, String[] stringArray) throws  {
        return SignedBundleHook$$Cold.matchDNChain(this, string, stringArray);
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object object, BaseData baseData, boolean bl) {
        try {
            if (bundleFile != null) {
                SignedBundleFile signedBundleFile;
                SignedStorageHook signedStorageHook = (SignedStorageHook)baseData.getStorageHook(SignedStorageHook.KEY);
                if (bl && signedStorageHook != null) {
                    if (signedStorageHook.signedBundleFile == null) {
                        signedStorageHook.signedBundleFile = new SignedBundleFile();
                    }
                    signedBundleFile = signedStorageHook.signedBundleFile;
                } else {
                    signedBundleFile = new SignedBundleFile();
                }
                signedBundleFile.setBundleFile(bundleFile, supportSignedBundles);
                if (signedBundleFile.isSigned()) {
                    bundleFile = signedBundleFile;
                } else if (bl) {
                    signedStorageHook.signedBundleFile = null;
                }
            }
        }
        catch (IOException iOException) {}
        return bundleFile;
    }

    public CertificateVerifier getVerifier(File file) throws IOException {
        return SignedBundleHook$$Cold.getVerifier(this, file);
    }

    public CertificateVerifier getVerifier(Bundle bundle) throws IOException {
        return SignedBundleHook$$Cold.getVerifier(this, bundle);
    }

    static void log(String string, int n, Throwable throwable) {
        if (ADAPTOR == null) {
            System.err.println(string);
            throwable.printStackTrace();
            return;
        }
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", n, 0, string, 0, throwable, null);
        ADAPTOR.getFrameworkLog().log(frameworkLogEntry);
    }

    static CertificateTrustAuthority getTrustAuthority() {
        BundleContext bundleContext = SignedBundleHook.getContext();
        if (bundleContext == null) {
            return trustAuthority;
        }
        if (trustAuthorityTracker == null) {
            String string = Security.getProperty("osgi.certificate.trust.authority");
            Filter filter = null;
            if (string != null) {
                try {
                    StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                        }
                    }
                    filter = FrameworkUtil.createFilter(stringBuffer.append(clazz.getName()).append(")(").append("osgi.certificate.trust.authority").append("=").append(string).append("))").toString());
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    invalidSyntaxException.printStackTrace();
                }
            }
            if (filter != null) {
                trustAuthorityTracker = new ServiceTracker(bundleContext, filter, null);
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                trustAuthorityTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            }
            trustAuthorityTracker.open();
        }
        return (CertificateTrustAuthority)trustAuthorityTracker.getService();
    }
}

