/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.verifier.DNChainMatching;
import org.eclipse.osgi.internal.verifier.SignedBundleFile;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;
import org.eclipse.osgi.internal.verifier.SignedStorageHook;
import org.osgi.framework.Bundle;

public class SignedBundleHook$$Cold {
    public static CertificateVerifier getVerifier(SignedBundleHook signedBundleHook, File file) {
        if (file == null) {
            throw (Throwable)new IllegalArgumentException("null content");
        }
        BundleFile bundleFile = file.isDirectory() ? new DirBundleFile(file) : new ZipBundleFile(file, null);
        SignedBundleFile signedBundleFile = new SignedBundleFile();
        signedBundleFile.setBundleFile(bundleFile, 7);
        return signedBundleFile;
    }

    public static CertificateVerifier getVerifier(SignedBundleHook signedBundleHook, Bundle bundle) {
        SignedBundleFile signedBundleFile;
        BundleData bundleData = ((AbstractBundle)bundle).getBundleData();
        if (!(bundleData instanceof BaseData)) {
            throw (Throwable)new IllegalArgumentException("Invalid bundle object.  No BaseData found.");
        }
        SignedStorageHook signedStorageHook = (SignedStorageHook)((BaseData)bundleData).getStorageHook(SignedStorageHook.KEY);
        SignedBundleFile signedBundleFile2 = signedBundleFile = signedStorageHook != null ? signedStorageHook.signedBundleFile : null;
        if (signedBundleFile != null) {
            return signedBundleFile;
        }
        return signedBundleHook.getVerifier(((BaseData)bundleData).getBundleFile().getBaseFile());
    }

    public static boolean matchDNChain(SignedBundleHook signedBundleHook, String string, String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (DNChainMatching.match(stringArray[n], string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }
}

