/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.internal.verifier.JarVerifierConstant;
import org.eclipse.osgi.internal.verifier.JarVerifierMessages;
import org.eclipse.osgi.internal.verifier.PKCS7Processor;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;

public class PKCS7DateParser {
    static Date parseDate(PKCS7Processor pKCS7Processor) throws IOException {
        return PKCS7DateParser.hasTimeStamp(pKCS7Processor);
    }

    private static Date hasTimeStamp(PKCS7Processor pKCS7Processor) throws IOException {
        byte[] byArray;
        Map map = pKCS7Processor.getUnsignedAttrs();
        if (map != null && (byArray = PKCS7DateParser.retrieveTimeStampConstruct(map)) != null) {
            try {
                PKCS7Processor pKCS7Processor2 = new PKCS7Processor(byArray, 0, byArray.length);
                pKCS7Processor2.validateCerts();
                pKCS7Processor.setTSACertificates(pKCS7Processor2.getCertificates());
                return pKCS7Processor2.getSigningTime();
            }
            catch (CertificateException certificateException) {
                SignedBundleHook.log(certificateException.getMessage(), 4, certificateException);
                throw (Throwable)new IOException(JarVerifierMessages.PKCS7_Parse_Signing_Time);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SignedBundleHook.log(noSuchAlgorithmException.getMessage(), 4, noSuchAlgorithmException);
                throw (Throwable)new SecurityException(JarVerifierMessages.No_Such_Algorithm_Excep);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw (Throwable)new IOException("InvalidKeyException occurs when verifying the certs from tsa certificates: " + invalidKeyException.getMessage());
            }
            catch (SignatureException signatureException) {
                throw (Throwable)new IOException(JarVerifierMessages.Signature_Not_Verify);
            }
        }
        return null;
    }

    private static byte[] retrieveTimeStampConstruct(Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int[] nArray = (int[])iterator.next();
            if (!Arrays.equals(JarVerifierConstant.TIMESTAMP_OID, nArray)) continue;
            return (byte[])map.get(nArray);
        }
        return null;
    }
}

