/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class StateWriter {
    private Map objectTable = new HashMap();
    private ArrayList forcedWrite = new ArrayList();

    StateWriter() {
    }

    private int addToObjectTable(Object object) {
        Integer n = (Integer)this.objectTable.get(object);
        if (n != null) {
            return n;
        }
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Object v;
        if (this.objectTable != null && (v = this.objectTable.get(object)) != null) {
            return (Integer)v;
        }
        return -1;
    }

    private boolean writePrefix(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (this.writeIndex(object, dataOutputStream)) {
            return true;
        }
        int n = this.addToObjectTable(object);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeInt(n);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void saveState(StateImpl var1_1, File var2_2, File var3_3) throws IOException {
        block39: {
            var4_4 = null;
            var5_5 = null;
            var6_6 = null;
            var7_7 = null;
            var8_8 = var1_1.getBundles();
            StateHelperImpl.getInstance().sortBundles(var8_8);
            var9_9 = 0;
            while (var9_9 < var8_8.length) {
                this.addToObjectTable(var8_8[var9_9]);
                ++var9_9;
            }
            var6_6 = new FileOutputStream(var3_3);
            var4_4 = new DataOutputStream(new BufferedOutputStream(var6_6));
            var9_9 = 0;
            while (var9_9 < var8_8.length) {
                this.writeBundleDescriptionLazyData(var8_8[var9_9], var4_4);
                ++var9_9;
            }
            var7_7 = new FileOutputStream(var2_2);
            var5_5 = new DataOutputStream(new BufferedOutputStream(var7_7));
            var5_5.write(26);
            if (!this.writePrefix(var1_1, var5_5)) break block39;
            while (true) {
                if (var4_4 != null) {
                    try {
                        var4_4.flush();
                        var6_6.getFD().sync();
                    }
                    catch (IOException v0) {}
                    try {
                        var4_4.close();
                    }
                    catch (IOException v1) {}
                }
                if (var5_5 != null) {
                    try {
                        var5_5.flush();
                        var7_7.getFD().sync();
                    }
                    catch (IOException v2) {}
                    try {
                        var5_5.close();
                    }
                    catch (IOException v3) {}
                }
                return;
            }
        }
        try {
            var5_5.writeLong(var1_1.getTimeStamp());
            var9_10 = var1_1.getPlatformPropertyKeys();
            this.writePlatformProp(var9_10, var5_5);
            var10_11 = var1_1.getPlatformProperties();
            var5_5.writeInt(var10_11.length);
            var11_12 = 0;
            while (var11_12 < var10_11.length) {
                var12_13 = var10_11[var11_12];
                var5_5.writeInt(var9_10.length);
                var13_14 = 0;
                while (var13_14 < var9_10.length) {
                    this.writePlatformProp(var12_13.get(var9_10[var13_14]), var5_5);
                    ++var13_14;
                }
                ++var11_12;
            }
            var5_5.writeInt(var8_8.length);
            if (var8_8.length == 0) ** continue;
            var11_12 = 0;
            while (var11_12 < var8_8.length) {
                this.writeBundleDescription(var8_8[var11_12], var5_5, true);
                ++var11_12;
            }
            var5_5.writeBoolean(var1_1.isResolved());
        }
        catch (Throwable var14_15) {
            if (var4_4 != null) {
                try {
                    var4_4.flush();
                    var6_6.getFD().sync();
                }
                catch (IOException v4) {}
                try {
                    var4_4.close();
                }
                catch (IOException v5) {}
            }
            if (var5_5 != null) {
                try {
                    var5_5.flush();
                    var7_7.getFD().sync();
                }
                catch (IOException v6) {}
                try {
                    var5_5.close();
                }
                catch (IOException v7) {}
            }
            throw var14_15;
        }
        if (var4_4 != null) {
            try {
                var4_4.flush();
                var6_6.getFD().sync();
            }
            catch (IOException v8) {}
            try {
                var4_4.close();
            }
            catch (IOException v9) {}
        }
        if (var5_5 != null) {
            try {
                var5_5.flush();
                var7_7.getFD().sync();
            }
            catch (IOException v10) {}
            try {
                var5_5.close();
            }
            catch (IOException v11) {}
        }
    }

    private void writePlatformProp(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            if (object instanceof String) {
                dataOutputStream.writeInt(1);
                this.writeStringOrNull((String)object, dataOutputStream);
            } else {
                String[] stringArray = (String[])object;
                dataOutputStream.writeInt(stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    this.writeStringOrNull(stringArray[n], dataOutputStream);
                    ++n;
                }
            }
        }
    }

    private void writeBundleDescription(BundleDescription bundleDescription, DataOutputStream dataOutputStream, boolean bl) throws IOException {
        if (bl && !this.forcedWrite.contains(bundleDescription)) {
            int n = this.addToObjectTable(bundleDescription);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(n);
            this.forcedWrite.add(bundleDescription);
        } else if (this.writePrefix(bundleDescription, dataOutputStream)) {
            return;
        }
        dataOutputStream.writeLong(bundleDescription.getBundleId());
        this.writeBaseDescription(bundleDescription, dataOutputStream);
        dataOutputStream.writeInt(((BundleDescriptionImpl)bundleDescription).getLazyDataOffset());
        dataOutputStream.writeInt(((BundleDescriptionImpl)bundleDescription).getLazyDataSize());
        dataOutputStream.writeBoolean(bundleDescription.isResolved());
        dataOutputStream.writeBoolean(bundleDescription.isSingleton());
        dataOutputStream.writeBoolean(bundleDescription.hasDynamicImports());
        dataOutputStream.writeBoolean(bundleDescription.attachFragments());
        dataOutputStream.writeBoolean(bundleDescription.dynamicFragments());
        this.writeHostSpec((HostSpecificationImpl)bundleDescription.getHost(), dataOutputStream, bl);
        List list = ((BundleDescriptionImpl)bundleDescription).getBundleDependencies();
        dataOutputStream.writeInt(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.writeBundleDescription((BundleDescription)iterator.next(), dataOutputStream, bl);
        }
    }

    private void writeBundleDescriptionLazyData(BundleDescription bundleDescription, DataOutputStream dataOutputStream) throws IOException {
        Object object;
        Object object2;
        int n = dataOutputStream.size();
        int n2 = this.getFromObjectTable(bundleDescription);
        ((BundleDescriptionImpl)bundleDescription).setLazyDataOffset(dataOutputStream.size());
        dataOutputStream.writeInt(n2);
        this.writeStringOrNull(bundleDescription.getLocation(), dataOutputStream);
        this.writeStringOrNull(bundleDescription.getPlatformFilter(), dataOutputStream);
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getExportPackages();
        dataOutputStream.writeInt(exportPackageDescriptionArray.length);
        int n3 = 0;
        while (n3 < exportPackageDescriptionArray.length) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)exportPackageDescriptionArray[n3], dataOutputStream);
            ++n3;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = bundleDescription.getImportPackages();
        dataOutputStream.writeInt(importPackageSpecificationArray.length);
        int n4 = 0;
        while (n4 < importPackageSpecificationArray.length) {
            this.writeImportPackageSpec(importPackageSpecificationArray[n4], dataOutputStream);
            ++n4;
        }
        BundleSpecification[] bundleSpecificationArray = bundleDescription.getRequiredBundles();
        dataOutputStream.writeInt(bundleSpecificationArray.length);
        int n5 = 0;
        while (n5 < bundleSpecificationArray.length) {
            this.writeBundleSpec((BundleSpecificationImpl)bundleSpecificationArray[n5], dataOutputStream);
            ++n5;
        }
        ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getSelectedExports();
        if (exportPackageDescriptionArray2 == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(exportPackageDescriptionArray2.length);
            int n6 = 0;
            while (n6 < exportPackageDescriptionArray2.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)exportPackageDescriptionArray2[n6], dataOutputStream);
                ++n6;
            }
        }
        ExportPackageDescription[] exportPackageDescriptionArray3 = bundleDescription.getResolvedImports();
        if (exportPackageDescriptionArray3 == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(exportPackageDescriptionArray3.length);
            int n7 = 0;
            while (n7 < exportPackageDescriptionArray3.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)exportPackageDescriptionArray3[n7], dataOutputStream);
                ++n7;
            }
        }
        BundleDescription[] bundleDescriptionArray = bundleDescription.getResolvedRequires();
        if (bundleDescriptionArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(bundleDescriptionArray.length);
            int n8 = 0;
            while (n8 < bundleDescriptionArray.length) {
                this.writeBundleDescription(bundleDescriptionArray[n8], dataOutputStream, false);
                ++n8;
            }
        }
        String[] stringArray = bundleDescription.getExecutionEnvironments();
        dataOutputStream.writeInt(stringArray.length);
        int n9 = 0;
        while (n9 < stringArray.length) {
            this.writeStringOrNull(stringArray[n9], dataOutputStream);
            ++n9;
        }
        HashMap hashMap = ((BundleDescriptionImpl)bundleDescription).getDynamicStamps();
        if (hashMap == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(hashMap.size());
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.writeStringOrNull((String)object, dataOutputStream);
                dataOutputStream.writeLong((Long)hashMap.get(object));
            }
        }
        object2 = bundleDescription.getGenericCapabilities();
        if (object2 == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(((Object)object2).length);
            int n10 = 0;
            while (n10 < ((Object)object2).length) {
                this.writeGenericDescription((GenericDescription)object2[n10], dataOutputStream);
                ++n10;
            }
        }
        object = bundleDescription.getGenericRequires();
        if (object == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(((GenericSpecification[])object).length);
            int n11 = 0;
            while (n11 < ((GenericSpecification[])object).length) {
                this.writeGenericSpecification(object[n11], dataOutputStream);
                ++n11;
            }
        }
        ((BundleDescriptionImpl)bundleDescription).setLazyDataSize(dataOutputStream.size() - n);
    }

    private void writeBundleSpec(BundleSpecificationImpl bundleSpecificationImpl, DataOutputStream dataOutputStream) throws IOException {
        this.writeVersionConstraint(bundleSpecificationImpl, dataOutputStream);
        this.writeBundleDescription((BundleDescription)bundleSpecificationImpl.getSupplier(), dataOutputStream, false);
        dataOutputStream.writeBoolean(bundleSpecificationImpl.isExported());
        dataOutputStream.writeBoolean(bundleSpecificationImpl.isOptional());
    }

    private void writeExportPackageDesc(ExportPackageDescriptionImpl exportPackageDescriptionImpl, DataOutputStream dataOutputStream) throws IOException {
        if (this.writePrefix(exportPackageDescriptionImpl, dataOutputStream)) {
            return;
        }
        this.writeBaseDescription(exportPackageDescriptionImpl, dataOutputStream);
        dataOutputStream.writeBoolean(exportPackageDescriptionImpl.isRoot());
        this.writeMap(dataOutputStream, exportPackageDescriptionImpl.getAttributes());
        this.writeMap(dataOutputStream, exportPackageDescriptionImpl.getDirectives());
    }

    private void writeMap(DataOutputStream dataOutputStream, Map map) throws IOException {
        if (map == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(map.size());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = map.get(string);
                this.writeStringOrNull(string, dataOutputStream);
                if (v instanceof String) {
                    dataOutputStream.writeByte(0);
                    this.writeStringOrNull((String)v, dataOutputStream);
                    continue;
                }
                if (v instanceof String[]) {
                    dataOutputStream.writeByte(1);
                    this.writeList(dataOutputStream, (String[])v);
                    continue;
                }
                if (v instanceof Boolean) {
                    dataOutputStream.writeByte(2);
                    dataOutputStream.writeBoolean((Boolean)v);
                    continue;
                }
                if (v instanceof Integer) {
                    dataOutputStream.writeByte(3);
                    dataOutputStream.writeInt((Integer)v);
                    continue;
                }
                if (v instanceof Long) {
                    dataOutputStream.writeByte(4);
                    dataOutputStream.writeLong((Long)v);
                    continue;
                }
                if (v instanceof Double) {
                    dataOutputStream.writeByte(5);
                    dataOutputStream.writeDouble((Double)v);
                    continue;
                }
                if (v instanceof Version) {
                    dataOutputStream.writeByte(6);
                    this.writeVersion((Version)v, dataOutputStream);
                    continue;
                }
                if (!"java.net.URI".equals(v.getClass().getName())) continue;
                dataOutputStream.writeByte(7);
                this.writeStringOrNull(v.toString(), dataOutputStream);
            }
        }
    }

    private void writeList(DataOutputStream dataOutputStream, String[] stringArray) throws IOException {
        if (stringArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.writeStringOrNull(stringArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private void writeBaseDescription(BaseDescription baseDescription, DataOutputStream dataOutputStream) throws IOException {
        this.writeStringOrNull(baseDescription.getName(), dataOutputStream);
        this.writeVersion(baseDescription.getVersion(), dataOutputStream);
    }

    private void writeImportPackageSpec(ImportPackageSpecification importPackageSpecification, DataOutputStream dataOutputStream) throws IOException {
        this.writeVersionConstraint(importPackageSpecification, dataOutputStream);
        if (importPackageSpecification.getBundle().isResolved()) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)importPackageSpecification.getSupplier(), dataOutputStream);
        } else {
            dataOutputStream.writeByte(0);
        }
        this.writeStringOrNull(importPackageSpecification.getBundleSymbolicName(), dataOutputStream);
        this.writeVersionRange(importPackageSpecification.getBundleVersionRange(), dataOutputStream);
        this.writeMap(dataOutputStream, importPackageSpecification.getAttributes());
        this.writeMap(dataOutputStream, importPackageSpecification.getDirectives());
    }

    private void writeHostSpec(HostSpecificationImpl hostSpecificationImpl, DataOutputStream dataOutputStream, boolean bl) throws IOException {
        if (hostSpecificationImpl == null) {
            dataOutputStream.writeByte(0);
            return;
        }
        dataOutputStream.writeByte(1);
        this.writeVersionConstraint(hostSpecificationImpl, dataOutputStream);
        BundleDescription[] bundleDescriptionArray = hostSpecificationImpl.getHosts();
        if (bundleDescriptionArray == null) {
            dataOutputStream.writeInt(0);
            return;
        }
        dataOutputStream.writeInt(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.writeBundleDescription(bundleDescriptionArray[n], dataOutputStream, bl);
            ++n;
        }
    }

    private void writeVersionConstraint(VersionConstraint versionConstraint, DataOutputStream dataOutputStream) throws IOException {
        this.writeStringOrNull(versionConstraint.getName(), dataOutputStream);
        this.writeVersionRange(versionConstraint.getVersionRange(), dataOutputStream);
    }

    private void writeVersion(Version version, DataOutputStream dataOutputStream) throws IOException {
        if (version == null || version.equals(Version.emptyVersion)) {
            dataOutputStream.writeByte(0);
            return;
        }
        dataOutputStream.writeByte(1);
        dataOutputStream.writeInt(version.getMajor());
        dataOutputStream.writeInt(version.getMinor());
        dataOutputStream.writeInt(version.getMicro());
        this.writeQualifier(version.getQualifier(), dataOutputStream);
    }

    private void writeVersionRange(VersionRange versionRange, DataOutputStream dataOutputStream) throws IOException {
        if (versionRange == null || versionRange.equals(VersionRange.emptyRange)) {
            dataOutputStream.writeByte(0);
            return;
        }
        dataOutputStream.writeByte(1);
        this.writeVersion(versionRange.getMinimum(), dataOutputStream);
        dataOutputStream.writeBoolean(versionRange.getIncludeMinimum());
        this.writeVersion(versionRange.getMaximum(), dataOutputStream);
        dataOutputStream.writeBoolean(versionRange.getIncludeMaximum());
    }

    private boolean writeIndex(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
            return true;
        }
        int n = this.getFromObjectTable(object);
        if (n == -1) {
            return false;
        }
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n);
        return true;
    }

    private void writeStringOrNull(String string, DataOutputStream dataOutputStream) throws IOException {
        if (string == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string);
        }
    }

    private void writeQualifier(String string, DataOutputStream dataOutputStream) throws IOException {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.writeStringOrNull(string, dataOutputStream);
    }

    private void writeStateDeprecated(StateImpl stateImpl, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(26);
        if (this.writePrefix(stateImpl, dataOutputStream)) {
            return;
        }
        dataOutputStream.writeLong(stateImpl.getTimeStamp());
        String[] stringArray = stateImpl.getPlatformPropertyKeys();
        this.writePlatformProp(stringArray, dataOutputStream);
        Dictionary[] dictionaryArray = stateImpl.getPlatformProperties();
        dataOutputStream.writeInt(dictionaryArray.length);
        int n = 0;
        while (n < dictionaryArray.length) {
            Dictionary dictionary = dictionaryArray[n];
            dataOutputStream.writeInt(stringArray.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.writePlatformProp(dictionary.get(stringArray[n2]), dataOutputStream);
                ++n2;
            }
            ++n;
        }
        BundleDescription[] bundleDescriptionArray = stateImpl.getBundles();
        StateHelperImpl.getInstance().sortBundles(bundleDescriptionArray);
        dataOutputStream.writeInt(bundleDescriptionArray.length);
        if (bundleDescriptionArray.length == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < bundleDescriptionArray.length) {
            this.writeBundleDescription(bundleDescriptionArray[n3], dataOutputStream, false);
            ++n3;
        }
        dataOutputStream.writeBoolean(stateImpl.isResolved());
        dataOutputStream.writeInt(dataOutputStream.size());
        n3 = 0;
        while (n3 < bundleDescriptionArray.length) {
            this.writeBundleDescriptionLazyData(bundleDescriptionArray[n3], dataOutputStream);
            ++n3;
        }
    }

    private void writeGenericDescription(GenericDescription genericDescription, DataOutputStream dataOutputStream) throws IOException {
        if (this.writePrefix(genericDescription, dataOutputStream)) {
            return;
        }
        this.writeBaseDescription(genericDescription, dataOutputStream);
        this.writeStringOrNull(genericDescription.getType() == "generic" ? null : genericDescription.getType(), dataOutputStream);
        Dictionary dictionary = genericDescription.getAttributes();
        HashMap hashMap = new HashMap(dictionary.size());
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if ("version".equals(k)) continue;
            hashMap.put(k, dictionary.get(k));
        }
        this.writeMap(dataOutputStream, hashMap);
    }

    private void writeGenericSpecification(GenericSpecification genericSpecification, DataOutputStream dataOutputStream) throws IOException {
        this.writeVersionConstraint(genericSpecification, dataOutputStream);
        this.writeStringOrNull(genericSpecification.getType() == "generic" ? null : genericSpecification.getType(), dataOutputStream);
        GenericDescription[] genericDescriptionArray = genericSpecification.getSuppliers();
        dataOutputStream.writeInt(genericDescriptionArray == null ? 0 : genericDescriptionArray.length);
        if (genericDescriptionArray != null) {
            int n = 0;
            while (n < genericDescriptionArray.length) {
                this.writeGenericDescription(genericDescriptionArray[n], dataOutputStream);
                ++n;
            }
        }
        dataOutputStream.writeInt(genericSpecification.getResolution());
        this.writeStringOrNull(genericSpecification.getMatchingFilter(), dataOutputStream);
    }

    public void saveStateDeprecated(StateImpl stateImpl, DataOutputStream dataOutputStream) throws IOException {
        try {
            this.writeStateDeprecated(stateImpl, dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
    }
}

