/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class StateHelperImpl$$Cold {
    public static Map getExportedPackageMap(StateHelperImpl stateHelperImpl, State state) {
        HashMap<String, HashSet<ExportPackageDescription>> hashMap = new HashMap<String, HashSet<ExportPackageDescription>>(11);
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            ExportPackageDescription[] exportPackageDescriptionArray = bundleDescriptionArray[n].getExportPackages();
            int n2 = 0;
            while (n2 < exportPackageDescriptionArray.length) {
                ExportPackageDescription exportPackageDescription = exportPackageDescriptionArray[n2];
                HashSet<ExportPackageDescription> hashSet = (HashSet<ExportPackageDescription>)hashMap.get(exportPackageDescription.getName());
                if (hashSet == null) {
                    hashSet = new HashSet<ExportPackageDescription>(1);
                    hashMap.put(exportPackageDescription.getName(), hashSet);
                }
                hashSet.add(exportPackageDescription);
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    public static Map getGenericsMap(StateHelperImpl stateHelperImpl, State state, boolean bl) {
        HashMap<String, HashSet<GenericDescription>> hashMap = new HashMap<String, HashSet<GenericDescription>>(11);
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (!bl || bundleDescriptionArray[n].isResolved()) {
                GenericDescription[] genericDescriptionArray = bundleDescriptionArray[n].getGenericCapabilities();
                int n2 = 0;
                while (n2 < genericDescriptionArray.length) {
                    GenericDescription genericDescription = genericDescriptionArray[n2];
                    HashSet<GenericDescription> hashSet = (HashSet<GenericDescription>)hashMap.get(genericDescription.getName());
                    if (hashSet == null) {
                        hashSet = new HashSet<GenericDescription>(1);
                        hashMap.put(genericDescription.getName(), hashSet);
                    }
                    hashSet.add(genericDescription);
                    ++n2;
                }
            }
            ++n;
        }
        return hashMap;
    }

    public static boolean isBundleConstraintResolvable(StateHelperImpl stateHelperImpl, VersionConstraint versionConstraint) {
        BundleDescription[] bundleDescriptionArray = versionConstraint.getBundle().getContainingState().getBundles(versionConstraint.getName());
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].isResolved() && versionConstraint.isSatisfiedBy(bundleDescriptionArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isFriend(StateHelperImpl stateHelperImpl, String string, ExportPackageDescription exportPackageDescription, boolean bl) {
        if (!bl) {
            return true;
        }
        String[] stringArray = (String[])exportPackageDescription.getDirective("x-friends");
        if (stringArray == null) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isResolvable(StateHelperImpl stateHelperImpl, ImportPackageSpecification importPackageSpecification) {
        ExportPackageDescription[] exportPackageDescriptionArray = importPackageSpecification.getBundle().getContainingState().getExportedPackages();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (importPackageSpecification.isSatisfiedBy(exportPackageDescriptionArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isSystemExport(StateHelperImpl stateHelperImpl, ExportPackageDescription exportPackageDescription, int n) {
        if ((n & 1) != 0) {
            return false;
        }
        return (Integer)exportPackageDescription.getDirective("x-equinox-ee") >= 0;
    }
}

