/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateMsg;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

class StateBuilder {
    static final String[] DEFINED_MATCHING_ATTRS = new String[]{"bundle-symbolic-name", "bundle-version", "specification-version", "version"};
    static final String[] DEFINED_OSGI_VALIDATE_HEADERS = new String[]{"Import-Package", "DynamicImport-Package", "Export-Package", "Fragment-Host", "Bundle-SymbolicName", "Reexport-Package", "Require-Bundle"};
    static final String GENERIC_REQUIRE = "Eclipse-GenericRequire";
    static final String GENERIC_CAPABILITY = "Eclipse-GenericCapability";
    private static final String ATTR_TYPE_STRING = "string";
    private static final String ATTR_TYPE_VERSION = "version";
    private static final String ATTR_TYPE_URI = "uri";
    private static final String ATTR_TYPE_LONG = "long";
    private static final String ATTR_TYPE_DOUBLE = "double";
    private static final String ATTR_TYPE_SET = "set";
    private static final String OPTIONAL_ATTR = "optional";
    private static final String MULTIPLE_ATTR = "multiple";
    private static final String TRUE = "true";
    static Class class$0;

    StateBuilder() {
    }

    static BundleDescription createBundleDescription(StateImpl stateImpl, Dictionary dictionary, String string) throws BundleException {
        ManifestElement[] manifestElementArray;
        ManifestElement[] manifestElementArray2;
        int n;
        BundleDescriptionImpl bundleDescriptionImpl;
        block11: {
            Object object;
            String string2;
            bundleDescriptionImpl = new BundleDescriptionImpl();
            String string3 = (String)dictionary.get("Bundle-ManifestVersion");
            boolean bl = TRUE.equals(dictionary.get("Eclipse-JREBundle"));
            n = 1;
            if (string3 != null) {
                n = Integer.parseInt(string3);
            }
            if (n >= 2) {
                StateBuilder.validateHeaders(dictionary, bl);
            }
            if ((string2 = (String)dictionary.get("Bundle-SymbolicName")) != null && ((ManifestElement[])(object = ManifestElement.parseHeader("Bundle-SymbolicName", string2))).length > 0) {
                bundleDescriptionImpl.setSymbolicName(object[0].getValue());
                manifestElementArray2 = object[0].getDirective("singleton");
                if (manifestElementArray2 == null) {
                    manifestElementArray2 = object[0].getAttribute("singleton");
                }
                bundleDescriptionImpl.setStateBit(2, TRUE.equals(manifestElementArray2));
                manifestElementArray = object[0].getDirective("fragment-attachment");
                if (manifestElementArray != null) {
                    if (manifestElementArray.equals("resolve-time")) {
                        bundleDescriptionImpl.setStateBit(64, true);
                        bundleDescriptionImpl.setStateBit(128, false);
                    } else if (manifestElementArray.equals("never")) {
                        bundleDescriptionImpl.setStateBit(64, false);
                        bundleDescriptionImpl.setStateBit(128, false);
                    }
                }
            }
            object = (String)dictionary.get("Bundle-Version");
            try {
                bundleDescriptionImpl.setVersion(object != null ? Version.parseVersion((String)object) : Version.emptyVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (n < 2) break block11;
                throw (Throwable)new BundleException(illegalArgumentException.getMessage());
            }
        }
        bundleDescriptionImpl.setLocation(string);
        bundleDescriptionImpl.setPlatformFilter((String)dictionary.get("Eclipse-PlatformFilter"));
        bundleDescriptionImpl.setExecutionEnvironments(ManifestElement.getArrayFromList((String)dictionary.get("Bundle-RequiredExecutionEnvironment")));
        manifestElementArray2 = ManifestElement.parseHeader("Fragment-Host", (String)dictionary.get("Fragment-Host"));
        if (manifestElementArray2 != null) {
            bundleDescriptionImpl.setHost(StateBuilder.createHostSpecification(manifestElementArray2[0]));
        }
        manifestElementArray = ManifestElement.parseHeader("Export-Package", (String)dictionary.get("Export-Package"));
        ManifestElement[] manifestElementArray3 = ManifestElement.parseHeader("Reexport-Package", (String)dictionary.get("Reexport-Package"));
        ManifestElement[] manifestElementArray4 = ManifestElement.parseHeader("Provide-Package", (String)dictionary.get("Provide-Package"));
        boolean bl = stateImpl != null && stateImpl.inStrictMode();
        ArrayList arrayList = new ArrayList(manifestElementArray4 == null ? 0 : manifestElementArray4.length);
        bundleDescriptionImpl.setExportPackages(StateBuilder.createExportPackages(manifestElementArray, manifestElementArray3, manifestElementArray4, arrayList, n, bl));
        ManifestElement[] manifestElementArray5 = ManifestElement.parseHeader("Import-Package", (String)dictionary.get("Import-Package"));
        ManifestElement[] manifestElementArray6 = ManifestElement.parseHeader("DynamicImport-Package", (String)dictionary.get("DynamicImport-Package"));
        bundleDescriptionImpl.setImportPackages(StateBuilder.createImportPackages(bundleDescriptionImpl.getExportPackages(), arrayList, manifestElementArray5, manifestElementArray6, n));
        ManifestElement[] manifestElementArray7 = ManifestElement.parseHeader("Require-Bundle", (String)dictionary.get("Require-Bundle"));
        bundleDescriptionImpl.setRequiredBundles(StateBuilder.createRequiredBundles(manifestElementArray7));
        String[][] stringArray = StateBuilder.getGenericAliases(stateImpl);
        ManifestElement[] manifestElementArray8 = StateBuilder.getGenericRequires(dictionary, stringArray);
        bundleDescriptionImpl.setGenericRequires(StateBuilder.createGenericRequires(manifestElementArray8));
        ManifestElement[] manifestElementArray9 = StateBuilder.getGenericCapabilities(dictionary, stringArray);
        bundleDescriptionImpl.setGenericCapabilities(StateBuilder.createGenericCapabilities(manifestElementArray9));
        return bundleDescriptionImpl;
    }

    private static ManifestElement[] getGenericRequires(Dictionary dictionary, String[][] stringArray) throws BundleException {
        int n;
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader(GENERIC_REQUIRE, (String)dictionary.get(GENERIC_REQUIRE));
        ArrayList<ManifestElement> arrayList = null;
        if (stringArray.length > 0) {
            arrayList = new ArrayList<ManifestElement>(manifestElementArray == null ? 0 : manifestElementArray.length);
            n = 0;
            while (n < stringArray.length) {
                ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader(stringArray[n][1], (String)dictionary.get(stringArray[n][1]));
                if (manifestElementArray2 != null) {
                    int n2 = 0;
                    while (n2 < manifestElementArray2.length) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(manifestElementArray2[n2].getValue()).append(':').append(stringArray[n][2]);
                        String string = manifestElementArray2[n2].getAttribute("selection-filter");
                        if (string != null) {
                            stringBuffer.append("; ").append("selection-filter").append(string).append("=\"").append(string).append("\"");
                        }
                        ManifestElement[] manifestElementArray3 = ManifestElement.parseHeader(stringArray[n][1], stringBuffer.toString());
                        arrayList.add(manifestElementArray3[0]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return manifestElementArray;
        }
        if (manifestElementArray != null) {
            n = 0;
            while (n < manifestElementArray.length) {
                arrayList.add(manifestElementArray[n]);
                ++n;
            }
        }
        return arrayList.toArray(new ManifestElement[arrayList.size()]);
    }

    private static ManifestElement[] getGenericCapabilities(Dictionary dictionary, String[][] stringArray) throws BundleException {
        int n;
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader(GENERIC_CAPABILITY, (String)dictionary.get(GENERIC_CAPABILITY));
        ArrayList<ManifestElement> arrayList = null;
        if (stringArray.length > 0) {
            arrayList = new ArrayList<ManifestElement>(manifestElementArray == null ? 0 : manifestElementArray.length);
            n = 0;
            while (n < stringArray.length) {
                ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader(stringArray[n][0], (String)dictionary.get(stringArray[n][0]));
                if (manifestElementArray2 != null) {
                    int n2 = 0;
                    while (n2 < manifestElementArray2.length) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(manifestElementArray2[n2].getValue()).append(':').append(stringArray[n][2]);
                        ManifestElement[] manifestElementArray3 = manifestElementArray2[n2].getKeys();
                        while (manifestElementArray3 != null && manifestElementArray3.hasMoreElements()) {
                            String string = (String)manifestElementArray3.nextElement();
                            stringBuffer.append("; ").append(string).append("=\"").append(manifestElementArray2[n2].getAttribute(string)).append("\"");
                        }
                        manifestElementArray3 = ManifestElement.parseHeader(stringArray[n][0], stringBuffer.toString());
                        arrayList.add(manifestElementArray3[0]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return manifestElementArray;
        }
        if (manifestElementArray != null) {
            n = 0;
            while (n < manifestElementArray.length) {
                arrayList.add(manifestElementArray[n]);
                ++n;
            }
        }
        return arrayList.toArray(new ManifestElement[arrayList.size()]);
    }

    private static String[][] getGenericAliases(StateImpl stateImpl) {
        String string;
        Dictionary[] dictionaryArray = stateImpl == null ? null : stateImpl.getPlatformProperties();
        String string2 = string = dictionaryArray == null || dictionaryArray.length == 0 ? null : (String)dictionaryArray[0].get("osgi.genericAliases");
        if (string == null) {
            return new String[0][0];
        }
        String[] stringArray = ManifestElement.getArrayFromList(string, ",");
        String[][] stringArray2 = new String[stringArray.length][];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = ManifestElement.getArrayFromList(stringArray[n], ":");
            ++n;
        }
        return stringArray2;
    }

    private static void validateHeaders(Dictionary dictionary, boolean bl) throws BundleException {
        int n = 0;
        while (n < DEFINED_OSGI_VALIDATE_HEADERS.length) {
            String string = (String)dictionary.get(DEFINED_OSGI_VALIDATE_HEADERS[n]);
            if (string != null) {
                ManifestElement[] manifestElementArray = ManifestElement.parseHeader(DEFINED_OSGI_VALIDATE_HEADERS[n], string);
                StateBuilder.checkForDuplicateDirectives(manifestElementArray);
                if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "Reexport-Package") {
                    StateBuilder.checkForUsesDirective(manifestElementArray);
                }
                if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "Import-Package") {
                    StateBuilder.checkImportExportSyntax(manifestElementArray, false, false, bl);
                }
                if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "DynamicImport-Package") {
                    StateBuilder.checkImportExportSyntax(manifestElementArray, false, true, bl);
                }
                if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "Export-Package") {
                    StateBuilder.checkImportExportSyntax(manifestElementArray, true, false, bl);
                }
                if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "Fragment-Host") {
                    StateBuilder.checkExtensionBundle(manifestElementArray);
                }
            } else if (DEFINED_OSGI_VALIDATE_HEADERS[n] == "Bundle-SymbolicName") {
                throw (Throwable)new BundleException(NLS.bind(StateMsg.HEADER_REQUIRED, "Bundle-SymbolicName"));
            }
            ++n;
        }
    }

    private static BundleSpecification[] createRequiredBundles(ManifestElement[] manifestElementArray) {
        if (manifestElementArray == null) {
            return null;
        }
        BundleSpecification[] bundleSpecificationArray = new BundleSpecification[manifestElementArray.length];
        int n = 0;
        while (n < manifestElementArray.length) {
            bundleSpecificationArray[n] = StateBuilder.createRequiredBundle(manifestElementArray[n]);
            ++n;
        }
        return bundleSpecificationArray;
    }

    private static BundleSpecification createRequiredBundle(ManifestElement manifestElement) {
        BundleSpecificationImpl bundleSpecificationImpl = new BundleSpecificationImpl();
        bundleSpecificationImpl.setName(manifestElement.getValue());
        bundleSpecificationImpl.setVersionRange(StateBuilder.getVersionRange(manifestElement.getAttribute("bundle-version")));
        bundleSpecificationImpl.setExported("reexport".equals(manifestElement.getDirective("visibility")) || TRUE.equals(manifestElement.getAttribute("reprovide")));
        bundleSpecificationImpl.setOptional(OPTIONAL_ATTR.equals(manifestElement.getDirective("resolution")) || TRUE.equals(manifestElement.getAttribute(OPTIONAL_ATTR)));
        return bundleSpecificationImpl;
    }

    private static ImportPackageSpecification[] createImportPackages(ExportPackageDescription[] exportPackageDescriptionArray, ArrayList arrayList, ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2, int n) throws BundleException {
        int n2;
        ArrayList<ImportPackageSpecificationImpl> arrayList2 = null;
        if (n < 2) {
            if (exportPackageDescriptionArray.length == 0 && manifestElementArray == null && manifestElementArray2 == null) {
                return null;
            }
            arrayList2 = new ArrayList(exportPackageDescriptionArray.length + (manifestElementArray == null ? 0 : manifestElementArray.length));
            n2 = 0;
            while (n2 < exportPackageDescriptionArray.length) {
                if (!arrayList.contains(exportPackageDescriptionArray[n2].getName())) {
                    ImportPackageSpecificationImpl importPackageSpecificationImpl = new ImportPackageSpecificationImpl();
                    importPackageSpecificationImpl.setName(exportPackageDescriptionArray[n2].getName());
                    importPackageSpecificationImpl.setVersionRange(StateBuilder.getVersionRange(exportPackageDescriptionArray[n2].getVersion().toString()));
                    importPackageSpecificationImpl.setDirective("resolution", "static");
                    arrayList2.add(importPackageSpecificationImpl);
                }
                ++n2;
            }
        } else {
            arrayList2 = new ArrayList<ImportPackageSpecificationImpl>(manifestElementArray == null ? 0 : manifestElementArray.length);
        }
        if (manifestElementArray2 != null) {
            n2 = 0;
            while (n2 < manifestElementArray2.length) {
                StateBuilder.addImportPackages(manifestElementArray2[n2], arrayList2, n, true);
                ++n2;
            }
        }
        if (manifestElementArray != null) {
            n2 = 0;
            while (n2 < manifestElementArray.length) {
                StateBuilder.addImportPackages(manifestElementArray[n2], arrayList2, n, false);
                ++n2;
            }
        }
        return arrayList2.toArray(new ImportPackageSpecification[arrayList2.size()]);
    }

    private static void addImportPackages(ManifestElement manifestElement, ArrayList arrayList, int n, boolean bl) throws BundleException {
        String[] stringArray = manifestElement.getValueComponents();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Object object;
            if (n < 2) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    if (!stringArray[n2].equals(((ImportPackageSpecification)object.next()).getName())) continue;
                    object.remove();
                }
            }
            object = new ImportPackageSpecificationImpl();
            ((VersionConstraintImpl)object).setName(stringArray[n2]);
            String string = manifestElement.getAttribute(ATTR_TYPE_VERSION);
            if (string == null) {
                string = manifestElement.getAttribute("specification-version");
            }
            ((VersionConstraintImpl)object).setVersionRange(StateBuilder.getVersionRange(string));
            ((ImportPackageSpecificationImpl)object).setBundleSymbolicName(manifestElement.getAttribute("bundle-symbolic-name"));
            ((ImportPackageSpecificationImpl)object).setBundleVersionRange(StateBuilder.getVersionRange(manifestElement.getAttribute("bundle-version")));
            if (n >= 2) {
                ((ImportPackageSpecificationImpl)object).setAttributes(StateBuilder.getAttributes(manifestElement, DEFINED_MATCHING_ATTRS));
            }
            if (bl) {
                ((ImportPackageSpecificationImpl)object).setDirective("resolution", "dynamic");
            } else {
                ((ImportPackageSpecificationImpl)object).setDirective("resolution", StateBuilder.getResolution(manifestElement.getDirective("resolution")));
            }
            arrayList.add(object);
            ++n2;
        }
    }

    private static String getResolution(String string) {
        String string2 = "static";
        if (OPTIONAL_ATTR.equals(string)) {
            string2 = OPTIONAL_ATTR;
        }
        return string2;
    }

    static ExportPackageDescription[] createExportPackages(ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2, ManifestElement[] manifestElementArray3, ArrayList arrayList, int n, boolean bl) throws BundleException {
        int n2;
        int n3 = (manifestElementArray == null ? 0 : manifestElementArray.length) + (manifestElementArray2 == null ? 0 : manifestElementArray2.length) + (manifestElementArray3 == null ? 0 : manifestElementArray3.length);
        if (n3 == 0) {
            return null;
        }
        ArrayList arrayList2 = new ArrayList(n3);
        if (manifestElementArray != null) {
            n2 = 0;
            while (n2 < manifestElementArray.length) {
                StateBuilder.addExportPackages(manifestElementArray[n2], arrayList2, n, false, bl);
                ++n2;
            }
        }
        if (manifestElementArray2 != null) {
            n2 = 0;
            while (n2 < manifestElementArray2.length) {
                StateBuilder.addExportPackages(manifestElementArray2[n2], arrayList2, n, true, bl);
                ++n2;
            }
        }
        if (manifestElementArray3 != null) {
            StateBuilder.addProvidePackages(manifestElementArray3, arrayList2, arrayList);
        }
        return arrayList2.toArray(new ExportPackageDescription[arrayList2.size()]);
    }

    private static void addExportPackages(ManifestElement manifestElement, ArrayList arrayList, int n, boolean bl, boolean bl2) throws BundleException {
        String[] stringArray = manifestElement.getValueComponents();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!bl2 || !TRUE.equals(manifestElement.getDirective("x-internal"))) {
                ExportPackageDescriptionImpl exportPackageDescriptionImpl = new ExportPackageDescriptionImpl();
                exportPackageDescriptionImpl.setName(stringArray[n2]);
                String string = manifestElement.getAttribute(ATTR_TYPE_VERSION);
                if (string == null) {
                    string = manifestElement.getAttribute("specification-version");
                }
                if (string != null) {
                    exportPackageDescriptionImpl.setVersion(Version.parseVersion(string));
                }
                exportPackageDescriptionImpl.setDirective("uses", ManifestElement.getArrayFromList(manifestElement.getDirective("uses")));
                exportPackageDescriptionImpl.setDirective("include", manifestElement.getDirective("include"));
                exportPackageDescriptionImpl.setDirective("exclude", manifestElement.getDirective("exclude"));
                exportPackageDescriptionImpl.setDirective("x-friends", ManifestElement.getArrayFromList(manifestElement.getDirective("x-friends")));
                exportPackageDescriptionImpl.setDirective("x-internal", Boolean.valueOf(manifestElement.getDirective("x-internal")));
                exportPackageDescriptionImpl.setDirective("mandatory", ManifestElement.getArrayFromList(manifestElement.getDirective("mandatory")));
                exportPackageDescriptionImpl.setAttributes(StateBuilder.getAttributes(manifestElement, DEFINED_MATCHING_ATTRS));
                exportPackageDescriptionImpl.setRoot(!bl);
                arrayList.add(exportPackageDescriptionImpl);
            }
            ++n2;
        }
    }

    private static void addProvidePackages(ManifestElement[] manifestElementArray, ArrayList arrayList, ArrayList arrayList2) throws BundleException {
        ExportPackageDescription[] exportPackageDescriptionArray = arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
        int n = 0;
        while (n < manifestElementArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < exportPackageDescriptionArray.length) {
                if (manifestElementArray[n].getValue().equals(exportPackageDescriptionArray[n2].getName())) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                ExportPackageDescriptionImpl exportPackageDescriptionImpl = new ExportPackageDescriptionImpl();
                exportPackageDescriptionImpl.setName(manifestElementArray[n].getValue());
                exportPackageDescriptionImpl.setRoot(true);
                arrayList.add(exportPackageDescriptionImpl);
            }
            arrayList2.add(manifestElementArray[n].getValue());
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Map getAttributes(ManifestElement var0, String[] var1_1) {
        var2_2 = var0.getKeys();
        var3_3 = null;
        if (var2_2 != null) ** GOTO lbl62
        return null;
lbl-1000:
        // 1 sources

        {
            var4_4 = false;
            var5_5 = (String)var2_2.nextElement();
            var6_7 = 0;
            while (var6_7 < var1_1.length) {
                if (var1_1[var6_7].equals(var5_5)) {
                    var4_4 = true;
                    break;
                }
                ++var6_7;
            }
            var6_6 = var0.getAttribute(var5_5);
            var7_8 = var5_5.indexOf(58);
            var8_9 = "string";
            if (var7_8 > 0) {
                var8_9 = var5_5.substring(var7_8 + 1);
                var5_5 = var5_5.substring(0, var7_8);
            }
            if (var4_4) continue;
            if (var3_3 == null) {
                var3_3 = new HashMap<String, String>();
            }
            var9_10 /* !! */  = var6_6;
            if ("string".equals(var8_9)) {
                var9_10 /* !! */  = var6_6;
            } else if ("double".equals(var8_9)) {
                var9_10 /* !! */  = new Double(var6_6);
            } else if ("long".equals(var8_9)) {
                var9_10 /* !! */  = new Long(var6_6);
            } else if ("uri".equals(var8_9)) {
                try {
                    var10_11 = Class.forName("java.net.URI");
                    v0 = new Class[1];
                    v1 = StateBuilder.class$0;
                    if (v1 == null) {
                        try {
                            v1 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException v2) {
                            throw (Throwable)new NoClassDefFoundError(((Throwable)v2).getMessage());
                        }
                    }
                    v0[0] = v1;
                    var11_13 = var10_11.getConstructor(v0);
                    var9_10 /* !! */  = var11_13.newInstance(new Object[]{var6_6});
                }
                catch (ClassNotFoundException v3) {
                    var9_10 /* !! */  = var6_6;
                }
                catch (Exception var10_12) {
                    if (var10_12 instanceof RuntimeException) {
                        throw (Throwable)var10_12;
                    }
                    throw (Throwable)new RuntimeException(var10_12.getMessage());
                }
            } else if ("version".equals(var8_9)) {
                var9_10 /* !! */  = new Version(var6_6);
            } else if ("set".equals(var8_9)) {
                var9_10 /* !! */  = ManifestElement.getArrayFromList(var6_6, ",");
            }
            var3_3.put(var5_5, (String)var9_10 /* !! */ );
lbl62:
            // 3 sources

            ** while (var2_2.hasMoreElements())
        }
lbl63:
        // 1 sources

        return var3_3;
    }

    private static HostSpecification createHostSpecification(ManifestElement manifestElement) {
        if (manifestElement == null) {
            return null;
        }
        HostSpecificationImpl hostSpecificationImpl = new HostSpecificationImpl();
        hostSpecificationImpl.setName(manifestElement.getValue());
        hostSpecificationImpl.setVersionRange(StateBuilder.getVersionRange(manifestElement.getAttribute("bundle-version")));
        hostSpecificationImpl.setIsMultiHost(TRUE.equals(manifestElement.getDirective("multiple-hosts")));
        return hostSpecificationImpl;
    }

    private static GenericSpecification[] createGenericRequires(ManifestElement[] manifestElementArray) throws BundleException {
        if (manifestElementArray == null) {
            return null;
        }
        ArrayList<GenericSpecificationImpl> arrayList = new ArrayList<GenericSpecificationImpl>(manifestElementArray.length);
        int n = 0;
        while (n < manifestElementArray.length) {
            String[] stringArray = manifestElementArray[n].getValueComponents();
            int n2 = 0;
            while (n2 < stringArray.length) {
                GenericSpecificationImpl genericSpecificationImpl = new GenericSpecificationImpl();
                int n3 = stringArray[n2].indexOf(58);
                if (n3 > 0) {
                    genericSpecificationImpl.setName(stringArray[n2].substring(0, n3));
                    genericSpecificationImpl.setType(stringArray[n2].substring(n3 + 1));
                } else {
                    genericSpecificationImpl.setName(stringArray[n2]);
                }
                try {
                    genericSpecificationImpl.setMatchingFilter(manifestElementArray[n].getAttribute("selection-filter"));
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    throw (Throwable)new BundleException("selection-filter", invalidSyntaxException);
                }
                String string = manifestElementArray[n].getAttribute(OPTIONAL_ATTR);
                String string2 = manifestElementArray[n].getAttribute(MULTIPLE_ATTR);
                int n4 = 0;
                if (TRUE.equals(string)) {
                    n4 |= 1;
                }
                if (TRUE.equals(string2)) {
                    n4 |= 2;
                }
                genericSpecificationImpl.setResolution(n4);
                arrayList.add(genericSpecificationImpl);
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new GenericSpecification[arrayList.size()]);
    }

    private static GenericDescription[] createGenericCapabilities(ManifestElement[] manifestElementArray) {
        if (manifestElementArray == null) {
            return null;
        }
        ArrayList<GenericDescriptionImpl> arrayList = new ArrayList<GenericDescriptionImpl>(manifestElementArray.length);
        int n = 0;
        while (n < manifestElementArray.length) {
            String[] stringArray = manifestElementArray[n].getValueComponents();
            int n2 = 0;
            while (n2 < stringArray.length) {
                Map map;
                Object var9_9;
                GenericDescriptionImpl genericDescriptionImpl = new GenericDescriptionImpl();
                int n3 = stringArray[n2].indexOf(58);
                if (n3 > 0) {
                    genericDescriptionImpl.setName(stringArray[n2].substring(0, n3));
                    genericDescriptionImpl.setType(stringArray[n2].substring(n3 + 1));
                } else {
                    genericDescriptionImpl.setName(stringArray[n2]);
                }
                String string = manifestElementArray[n].getAttribute(ATTR_TYPE_VERSION);
                if (string != null) {
                    genericDescriptionImpl.setVersion(Version.parseVersion(string));
                }
                Object v0 = var9_9 = (map = StateBuilder.getAttributes(manifestElementArray[n], new String[]{ATTR_TYPE_VERSION})) == null ? null : map.remove(ATTR_TYPE_VERSION);
                if (var9_9 instanceof Version) {
                    genericDescriptionImpl.setVersion(var9_9);
                }
                Hashtable hashtable = new Hashtable();
                if (map != null) {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        ((Dictionary)hashtable).put(k, map.get(k));
                    }
                }
                genericDescriptionImpl.setAttributes(hashtable);
                arrayList.add(genericDescriptionImpl);
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new GenericDescription[arrayList.size()]);
    }

    private static VersionRange getVersionRange(String string) {
        if (string == null) {
            return null;
        }
        return new VersionRange(string);
    }

    private static void checkImportExportSyntax(ManifestElement[] manifestElementArray, boolean bl, boolean bl2, boolean bl3) throws BundleException {
        if (manifestElementArray == null) {
            return;
        }
        int n = manifestElementArray.length;
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string;
            String[] stringArray = manifestElementArray[n2].getValueComponents();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!bl && !bl2 && hashSet.contains(stringArray[n3])) {
                    throw (Throwable)new BundleException(NLS.bind(StateMsg.HEADER_PACKAGE_DUPLICATES, stringArray[n3]));
                }
                if (!bl3 && stringArray[n3].startsWith("java.")) {
                    throw (Throwable)new BundleException(NLS.bind(StateMsg.HEADER_PACKAGE_JAVA, stringArray[n3]));
                }
                hashSet.add(stringArray[n3]);
                ++n3;
            }
            String string2 = manifestElementArray[n2].getAttribute(ATTR_TYPE_VERSION);
            if (string2 != null && (string = manifestElementArray[n2].getAttribute("specification-version")) != null && !string.equals(string2)) {
                throw (Throwable)new BundleException(NLS.bind(StateMsg.HEADER_VERSION_ERROR, ATTR_TYPE_VERSION, "specification-version"));
            }
            if (bl) {
                if (manifestElementArray[n2].getAttribute("bundle-symbolic-name") != null) {
                    throw (Throwable)new BundleException(NLS.bind(StateMsg.HEADER_EXPORT_ATTR_ERROR, "bundle-symbolic-name", "Export-Package"));
                }
                if (manifestElementArray[n2].getAttribute("bundle-version") != null) {
                    throw (Throwable)new BundleException(NLS.bind(StateMsg.HEADER_EXPORT_ATTR_ERROR, "bundle-version", "Export-Package"));
                }
            }
            ++n2;
        }
    }

    private static void checkForDuplicateDirectives(ManifestElement[] manifestElementArray) throws BundleException {
        int n = 0;
        while (n < manifestElementArray.length) {
            Enumeration enumeration = manifestElementArray[n].getDirectiveKeys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String[] stringArray = manifestElementArray[n].getDirectives(string);
                    if (stringArray.length <= 1) continue;
                    throw (Throwable)new BundleException(NLS.bind(StateMsg.HEADER_DIRECTIVE_DUPLICATES, string));
                }
            }
            ++n;
        }
    }

    private static void checkForUsesDirective(ManifestElement[] manifestElementArray) throws BundleException {
        int n = 0;
        while (n < manifestElementArray.length) {
            if (manifestElementArray[n].getDirective("uses") != null) {
                throw (Throwable)new BundleException(NLS.bind(StateMsg.HEADER_REEXPORT_USES, "uses", "Reexport-Package"));
            }
            ++n;
        }
    }

    private static void checkExtensionBundle(ManifestElement[] manifestElementArray) throws BundleException {
        if (manifestElementArray.length == 0 || manifestElementArray[0].getDirective("extension") == null) {
            return;
        }
        String string = manifestElementArray[0].getValue();
        if (!string.equals("system.bundle") && !string.equals(Constants.getInternalSymbolicName())) {
            throw (Throwable)new BundleException(NLS.bind(StateMsg.HEADER_EXTENSION_ERROR, string));
        }
    }
}

