/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.GroupingChecker;
import org.eclipse.osgi.internal.module.GroupingChecker$PackageRoots;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.PermissionChecker;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImpl$$Cold;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionHashMap;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class ResolverImpl
implements Resolver {
    private static final String RESOLVER = "org.eclipse.osgi/resolver";
    private static final String OPTION_DEBUG = "org.eclipse.osgi/resolver/debug";
    private static final String OPTION_WIRING = "org.eclipse.osgi/resolver/wiring";
    private static final String OPTION_IMPORTS = "org.eclipse.osgi/resolver/imports";
    private static final String OPTION_REQUIRES = "org.eclipse.osgi/resolver/requires";
    private static final String OPTION_GENERICS = "org.eclipse.osgi/resolver/generics";
    private static final String OPTION_GROUPING = "org.eclipse.osgi/resolver/grouping";
    private static final String OPTION_CYCLES = "org.eclipse.osgi/resolver/cycles";
    public static boolean DEBUG = false;
    public static boolean DEBUG_WIRING = false;
    public static boolean DEBUG_IMPORTS = false;
    public static boolean DEBUG_REQUIRES = false;
    public static boolean DEBUG_GENERICS = false;
    public static boolean DEBUG_GROUPING = false;
    public static boolean DEBUG_CYCLES = false;
    private static int MAX_MULTIPLE_SUPPLIERS_MERGE = 10;
    private static long MAX_COMBINATIONS = 1000000L;
    private static String[][] CURRENT_EES;
    private State state;
    private PermissionChecker permissionChecker;
    private MappedList removalPending = new MappedList();
    private boolean initialized = false;
    private VersionHashMap resolverExports = null;
    private VersionHashMap resolverBundles = null;
    private VersionHashMap resolverGenerics = null;
    private ArrayList unresolvedBundles = null;
    private HashMap bundleMapping = null;
    private GroupingChecker groupingChecker;
    private Comparator selectionPolicy;
    private boolean developmentMode = false;

    public ResolverImpl(BundleContext bundleContext, boolean bl) {
        this.permissionChecker = new PermissionChecker(bundleContext, bl, this);
    }

    PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    private void initialize() {
        this.resolverExports = new VersionHashMap(this);
        this.resolverBundles = new VersionHashMap(this);
        this.resolverGenerics = new VersionHashMap(this);
        this.unresolvedBundles = new ArrayList();
        this.bundleMapping = new HashMap();
        BundleDescription[] bundleDescriptionArray = this.state.getBundles();
        this.groupingChecker = new GroupingChecker();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.initResolverBundle(bundleDescriptionArray[n], arrayList, false);
            ++n;
        }
        Object[] objectArray = this.removalPending.getAllValues();
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.initResolverBundle((BundleDescription)objectArray[n2], arrayList, true);
            ++n2;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            BundleDescription[] bundleDescriptionArray2 = ((HostSpecification)resolverBundle.getHost().getVersionConstraint()).getHosts();
            int n3 = 0;
            while (n3 < bundleDescriptionArray2.length) {
                ResolverBundle resolverBundle2 = (ResolverBundle)this.bundleMapping.get(bundleDescriptionArray2[n3]);
                if (resolverBundle2 != null) {
                    resolverBundle2.attachFragment(resolverBundle, false);
                }
                ++n3;
            }
        }
        this.rewireBundles();
        this.setDebugOptions();
        this.initialized = true;
    }

    private void initResolverBundle(BundleDescription bundleDescription, ArrayList arrayList, boolean bl) {
        ResolverBundle resolverBundle = new ResolverBundle(bundleDescription, this);
        this.bundleMapping.put(bundleDescription, resolverBundle);
        if (!bl || bundleDescription.isResolved()) {
            this.resolverExports.put(resolverBundle.getExportPackages());
            this.resolverBundles.put(resolverBundle.getName(), resolverBundle);
            this.resolverGenerics.put(resolverBundle.getGenericCapabilities());
        }
        if (bundleDescription.isResolved()) {
            resolverBundle.setState(2);
            if (bundleDescription.getHost() != null) {
                arrayList.add(resolverBundle);
            }
        } else if (!bl) {
            this.unresolvedBundles.add(resolverBundle);
        }
    }

    private void rewireBundles() {
        ArrayList arrayList = new ArrayList(this.bundleMapping.size());
        Iterator iterator = this.bundleMapping.values().iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            if (!resolverBundle.getBundle().isResolved() || resolverBundle.isFragment()) continue;
            this.rewireBundle(resolverBundle, arrayList);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isResolvable(BundleDescription bundleDescription, Dictionary[] dictionaryArray, ArrayList arrayList) {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        if (arrayList.contains(bundleDescription)) {
            return false;
        }
        if (bundleDescription.isSingleton() && (objectArray = this.resolverBundles.get(bundleDescription.getName())).length > 1) {
            n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3] != bundleDescription && ((ResolverBundle)objectArray[n3]).getBundle().isSingleton() && ((ResolverBundle)objectArray[n3]).getBundle().isResolved()) {
                    arrayList.add(bundleDescription);
                    return false;
                }
                ++n3;
            }
        }
        int n4 = n3 = (objectArray = bundleDescription.getExecutionEnvironments()).length == 0 ? 1 : 0;
        if (n3 == 0) {
            int n5 = 0;
            while (n5 < objectArray.length && n3 == 0) {
                n2 = 0;
                while (n2 < CURRENT_EES.length && n3 == 0) {
                    n = 0;
                    while (n < CURRENT_EES[n2].length && n3 == 0) {
                        if (CURRENT_EES[n2][n].equals(objectArray[n5])) {
                            ((BundleDescriptionImpl)bundleDescription).setEquinoxEE(n2);
                            n3 = 1;
                        }
                        ++n;
                    }
                    ++n2;
                }
                ++n5;
            }
        }
        if (n3 == 0) {
            StringBuffer stringBuffer = new StringBuffer("Bundle-RequiredExecutionEnvironment".length() + 20);
            stringBuffer.append("Bundle-RequiredExecutionEnvironment").append(": ");
            n2 = 0;
            while (n2 < objectArray.length) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((String)objectArray[n2]);
                ++n2;
            }
            this.state.addResolverError(bundleDescription, 16384, stringBuffer.toString(), null);
            return false;
        }
        String string = bundleDescription.getPlatformFilter();
        if (string == null) {
            return true;
        }
        if (dictionaryArray == null) {
            return false;
        }
        try {
            Filter filter = FrameworkUtil.createFilter(string);
            n = 0;
            while (n < dictionaryArray.length) {
                if (filter.matchCase(dictionaryArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.state.addResolverError(bundleDescription, 8192, string, null);
        return false;
    }

    private void attachFragment(ResolverBundle resolverBundle, ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2.contains(resolverBundle.getName())) {
            return;
        }
        arrayList2.add(resolverBundle.getName());
        Object[] objectArray = this.resolverBundles.get(resolverBundle.getName());
        int n = 0;
        while (n < objectArray.length) {
            ResolverBundle resolverBundle2 = (ResolverBundle)objectArray[n];
            if (!resolverBundle2.isResolved()) {
                this.attachFragment0(resolverBundle2, arrayList);
            }
            ++n;
        }
    }

    private void attachFragment0(ResolverBundle resolverBundle, ArrayList arrayList) {
        if (!resolverBundle.isFragment() || !resolverBundle.isResolvable() || arrayList.contains(resolverBundle.getBundle())) {
            return;
        }
        boolean bl = false;
        BundleConstraint bundleConstraint = resolverBundle.getHost();
        Object[] objectArray = this.resolverBundles.get(bundleConstraint.getVersionConstraint().getName());
        int n = 0;
        while (n < objectArray.length) {
            if (((ResolverBundle)objectArray[n]).isResolvable() && bundleConstraint.isSatisfiedBy((VersionSupplier)objectArray[n])) {
                bl = true;
                this.resolverExports.put(((ResolverBundle)objectArray[n]).attachFragment(resolverBundle, true));
            }
            ++n;
        }
        if (!bl) {
            this.state.addResolverError(resolverBundle.getBundle(), 4, resolverBundle.getHost().getVersionConstraint().toString(), resolverBundle.getHost().getVersionConstraint());
        }
    }

    public synchronized void resolve(BundleDescription[] bundleDescriptionArray, Dictionary[] dictionaryArray) {
        Object[] objectArray;
        if (DEBUG) {
            ResolverImpl.log("*** BEGIN RESOLUTION ***");
        }
        if (this.state == null) {
            throw (Throwable)new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        this.developmentMode = dictionaryArray.length == 0 ? false : "development".equals(dictionaryArray[0].get("osgi.resolverMode"));
        if ((bundleDescriptionArray = this.addDevConstraints(bundleDescriptionArray)) != null) {
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                ResolverBundle resolverBundle = (ResolverBundle)this.bundleMapping.get(bundleDescriptionArray[n]);
                if (resolverBundle != null) {
                    this.unresolveBundle(resolverBundle, false);
                }
                ++n;
            }
        }
        this.resolverExports.reorder();
        this.resolverBundles.reorder();
        this.resolverGenerics.reorder();
        this.getCurrentEEs(dictionaryArray);
        ArrayList arrayList = new ArrayList();
        boolean bl = dictionaryArray.length == 0 ? false : "true".equals(dictionaryArray[0].get("osgi.resolveOptional"));
        ResolverBundle[] resolverBundleArray = null;
        if (bl) {
            objectArray = this.state.getResolvedBundles();
            resolverBundleArray = new ResolverBundle[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                resolverBundleArray[n] = (ResolverBundle)this.bundleMapping.get(objectArray[n]);
                ++n;
            }
        }
        objectArray = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
        this.resolveBundles((ResolverBundle[])objectArray, dictionaryArray, arrayList);
        if (this.selectSingletons((ResolverBundle[])objectArray, arrayList)) {
            objectArray = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            this.resolveBundles((ResolverBundle[])objectArray, dictionaryArray, arrayList);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            BundleDescription bundleDescription = (BundleDescription)iterator.next();
            BundleDescription bundleDescription2 = this.state.getBundle(bundleDescription.getSymbolicName(), null);
            this.state.addResolverError(bundleDescription, 8, bundleDescription2.toString(), null);
        }
        if (bl) {
            this.resolveOptionalConstraints(resolverBundleArray);
        }
        if (DEBUG) {
            ResolverImpl.log("*** END RESOLUTION ***");
        }
    }

    private BundleDescription[] addDevConstraints(BundleDescription[] bundleDescriptionArray) {
        if (!this.developmentMode) {
            return bundleDescriptionArray;
        }
        HashSet<BundleDescription> hashSet = new HashSet<BundleDescription>();
        ResolverBundle[] resolverBundleArray = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
        int n = 0;
        while (n < resolverBundleArray.length) {
            this.addUnresolvedWithDependents(resolverBundleArray[n], hashSet);
            this.addHostsFromFragmentConstraints(resolverBundleArray[n], hashSet);
            ++n;
        }
        if (hashSet.size() == 0) {
            return bundleDescriptionArray;
        }
        if (bundleDescriptionArray != null) {
            n = 0;
            while (n < bundleDescriptionArray.length) {
                hashSet.add(bundleDescriptionArray[n]);
                ++n;
            }
        }
        return hashSet.toArray(new BundleDescription[hashSet.size()]);
    }

    private void getCurrentEEs(Dictionary[] dictionaryArray) {
        CURRENT_EES = new String[dictionaryArray.length][];
        int n = 0;
        while (n < dictionaryArray.length) {
            String string = (String)dictionaryArray[n].get("org.osgi.framework.executionenvironment");
            ResolverImpl.CURRENT_EES[n] = ManifestElement.getArrayFromList(string, ",");
            ++n;
        }
    }

    private void resolveBundles(ResolverBundle[] resolverBundleArray, Dictionary[] dictionaryArray, ArrayList arrayList) {
        int n = 0;
        while (n < resolverBundleArray.length) {
            this.state.removeResolverErrors(resolverBundleArray[n].getBundle());
            resolverBundleArray[n].setResolvable(this.isResolvable(resolverBundleArray[n].getBundle(), dictionaryArray, arrayList) || this.developmentMode);
            resolverBundleArray[n].clearRefs();
            ++n;
        }
        this.resolveBundles0(resolverBundleArray, dictionaryArray, arrayList);
        if (DEBUG_WIRING) {
            this.printWirings();
        }
        this.stateResolveBundles(resolverBundleArray);
    }

    private void resolveBundles0(ResolverBundle[] resolverBundleArray, Dictionary[] dictionaryArray, ArrayList arrayList) {
        if (this.developmentMode) {
            Arrays.sort(resolverBundleArray);
        }
        ArrayList arrayList2 = new ArrayList(resolverBundleArray.length);
        int n = 0;
        while (n < resolverBundleArray.length) {
            this.attachFragment(resolverBundleArray[n], arrayList, arrayList2);
            ++n;
        }
        ArrayList arrayList3 = new ArrayList(1);
        int n2 = 0;
        while (n2 < resolverBundleArray.length) {
            if (DEBUG) {
                ResolverImpl.log("** RESOLVING " + resolverBundleArray[n2] + " **");
            }
            arrayList3.clear();
            this.resolveBundle(resolverBundleArray[n2], arrayList3);
            this.checkCycle(arrayList3);
            ++n2;
        }
        if (this.unresolvedBundles.size() > 0) {
            ResolverBundle[] resolverBundleArray2 = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            int n3 = 0;
            while (n3 < resolverBundleArray2.length) {
                this.resolveFragment(resolverBundleArray2[n3]);
                ++n3;
            }
        }
        this.checkUsesConstraints(resolverBundleArray, dictionaryArray, arrayList);
    }

    private void checkUsesConstraints(ResolverBundle[] resolverBundleArray, Dictionary[] dictionaryArray, ArrayList arrayList) {
        ArrayList arrayList2 = this.findBestCombination(resolverBundleArray);
        HashSet<ResolverBundle> hashSet = null;
        if (arrayList2 != null) {
            Object object = arrayList2.iterator();
            while (object.hasNext()) {
                ResolverConstraint resolverConstraint = (ResolverConstraint)object.next();
                if (resolverConstraint.isOptional()) {
                    resolverConstraint.clearPossibleSuppliers();
                    continue;
                }
                hashSet = new HashSet<ResolverBundle>(arrayList2.size());
                ResolverBundle resolverBundle = resolverConstraint.isFromFragment() ? (ResolverBundle)this.bundleMapping.get(resolverConstraint.getVersionConstraint().getBundle()) : resolverConstraint.getBundle();
                if (resolverBundle == null) continue;
                hashSet.add(resolverBundle);
                int n = resolverConstraint instanceof ResolverImport ? 32 : 64;
                this.state.addResolverError(resolverBundle.getBundle(), n, resolverConstraint.getVersionConstraint().toString(), resolverConstraint.getVersionConstraint());
                resolverBundle.setResolvable(false);
                resolverBundle.clearRefs();
                this.setBundleUnresolved(resolverBundle, false, this.developmentMode);
            }
            if (hashSet != null && hashSet.size() > 0) {
                object = new ArrayList();
                int n = 0;
                while (n < resolverBundleArray.length) {
                    if (!hashSet.contains(resolverBundleArray[n])) {
                        this.setBundleUnresolved(resolverBundleArray[n], false, this.developmentMode);
                        ((ArrayList)object).add(resolverBundleArray[n]);
                    }
                    ++n;
                }
                this.resolveBundles0(((ArrayList)object).toArray(new ResolverBundle[((ArrayList)object).size()]), dictionaryArray, arrayList);
            }
        }
    }

    private ArrayList findBestCombination(ResolverBundle[] resolverBundleArray) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ArrayList arrayList = this.getConflicts(resolverBundleArray, hashSet, hashSet2);
        if (arrayList == null) {
            this.groupingChecker.clear();
            return null;
        }
        ResolverConstraint[][] resolverConstraintArray = this.getMultipleSuppliers(resolverBundleArray, hashSet, hashSet2);
        ArrayList arrayList2 = null;
        if (resolverConstraintArray.length > 0 && this.getNumCombinations(resolverConstraintArray) < MAX_COMBINATIONS) {
            int[] nArray = new int[resolverConstraintArray.length];
            arrayList2 = this.findBestCombination(resolverBundleArray, resolverConstraintArray, nArray, arrayList);
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < resolverConstraintArray[n].length) {
                    resolverConstraintArray[n][n2].setSelectedSupplier(nArray[n]);
                    ++n2;
                }
                ++n;
            }
        } else {
            arrayList2 = arrayList;
        }
        this.groupingChecker.clear();
        return arrayList2;
    }

    private ArrayList getConflicts(ResolverBundle[] resolverBundleArray, HashSet hashSet, HashSet hashSet2) {
        this.groupingChecker.clear();
        ArrayList arrayList = null;
        int n = 0;
        while (n < resolverBundleArray.length) {
            arrayList = this.addConflicts(resolverBundleArray[n], hashSet, hashSet2, arrayList);
            ++n;
        }
        return arrayList;
    }

    private ArrayList addConflicts(ResolverBundle resolverBundle, HashSet hashSet, HashSet hashSet2, ArrayList arrayList) {
        Object object;
        boolean bl = false;
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            ResolverBundle resolverBundle2 = (ResolverBundle)bundleConstraintArray[n].getSelectedSupplier();
            GroupingChecker$PackageRoots[][] groupingChecker$PackageRootsArray = object = resolverBundle2 == null ? null : this.groupingChecker.isConsistent(resolverBundle, resolverBundle2);
            if (object != null) {
                this.addConflictNames((GroupingChecker$PackageRoots[][])object, hashSet, hashSet2);
                if (!bl) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<BundleConstraint>(1);
                    }
                    arrayList.add(bundleConstraintArray[n]);
                    bl = !bundleConstraintArray[n].isOptional();
                }
            }
            ++n;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            GroupingChecker$PackageRoots[][] groupingChecker$PackageRootsArray;
            object = (ResolverExport)resolverImportArray[n2].getSelectedSupplier();
            GroupingChecker$PackageRoots[][] groupingChecker$PackageRootsArray2 = groupingChecker$PackageRootsArray = object == null ? null : this.groupingChecker.isConsistent(resolverBundle, (ResolverExport)object);
            if (groupingChecker$PackageRootsArray != null) {
                this.addConflictNames(groupingChecker$PackageRootsArray, hashSet, hashSet2);
                if (!bl) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(1);
                    }
                    arrayList.add((BundleConstraint)((Object)resolverImportArray[n2]));
                    bl = !resolverImportArray[n2].isOptional();
                }
            }
            ++n2;
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    private void checkCycle(ArrayList var1_1) {
        var2_2 = var1_1.size();
        if (var2_2 == 0) {
            return;
        }
        var3_3 = var1_1.iterator();
        while (var3_3.hasNext()) {
            block12: {
                var4_7 = (ResolverBundle)var3_3.next();
                if (!var4_7.isResolvable()) {
                    var3_3.remove();
                    continue;
                }
                var5_9 = var4_7.getImportPackages();
                var6_10 = 0;
                break block12;
                while ((var7_11 = (ResolverExport)var5_9[var6_10].getSelectedSupplier()).isDropped()) {
                    var5_9[var6_10].selectNextSupplier();
lbl16:
                    // 2 sources

                    ** while (var5_9[var6_10].getSelectedSupplier() == null)
lbl17:
                    // 1 sources

                }
lbl18:
                // 2 sources

                if (!var5_9[var6_10].isDynamic() && !var5_9[var6_10].isOptional() && var5_9[var6_10].getSelectedSupplier() == null) {
                    var4_7.setResolvable(false);
                    var4_7.clearRefs();
                    this.state.addResolverError(var5_9[var6_10].getVersionConstraint().getBundle(), 1, var5_9[var6_10].getVersionConstraint().toString(), var5_9[var6_10].getVersionConstraint());
                    var3_3.remove();
                    continue;
                }
                ++var6_10;
            }
            if (var6_10 < var5_9.length) ** GOTO lbl16
        }
        if (var1_1.size() != var2_2) {
            var3_4 = 0;
            while (var3_4 < var1_1.size()) {
                var4_7 = (ResolverBundle)var1_1.get(var3_4);
                var4_7.clearWires();
                var4_7.clearRefs();
                ++var3_4;
            }
            var3_5 = new ArrayList<E>(var1_1.size());
            var4_8 = 0;
            while (var4_8 < var1_1.size()) {
                this.resolveBundle((ResolverBundle)var1_1.get(var4_8), var3_5);
                ++var4_8;
            }
            this.checkCycle(var3_5);
        } else {
            var3_6 = 0;
            while (var3_6 < var1_1.size()) {
                if (ResolverImpl.DEBUG || ResolverImpl.DEBUG_CYCLES) {
                    ResolverImpl.log("Pushing " + var1_1.get(var3_6) + " to RESOLVED");
                }
                this.setBundleResolved((ResolverBundle)var1_1.get(var3_6));
                ++var3_6;
            }
        }
    }

    private boolean selectSingletons(ResolverBundle[] resolverBundleArray, ArrayList arrayList) {
        if (this.developmentMode) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < resolverBundleArray.length) {
            Object[] objectArray;
            BundleDescription bundleDescription = resolverBundleArray[n].getBundle();
            if (bundleDescription.isSingleton() && bundleDescription.isResolved() && !arrayList.contains(bundleDescription) && (objectArray = this.resolverBundles.get(bundleDescription.getName())).length > 1) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    BundleDescription bundleDescription2 = ((VersionSupplier)objectArray[n2]).getBundle();
                    ResolverBundle resolverBundle = (ResolverBundle)objectArray[n2];
                    if (objectArray[n2] != resolverBundleArray[n] && bundleDescription2.isSingleton() && bundleDescription2.isResolved() && !arrayList.contains(bundleDescription2)) {
                        bl = true;
                        boolean bl2 = this.selectionPolicy != null ? this.selectionPolicy.compare(bundleDescription2, bundleDescription) < 0 : bundleDescription2.getVersion().compareTo(bundleDescription.getVersion()) > 0;
                        int n3 = resolverBundle.getRefs();
                        int n4 = resolverBundleArray[n].getRefs();
                        if (n3 == n4 && bl2 || n3 > n4) {
                            if (arrayList.contains(resolverBundleArray[n].getBundle())) break;
                            arrayList.add(resolverBundleArray[n].getBundle());
                            break;
                        }
                        if (!arrayList.contains(bundleDescription2)) {
                            arrayList.add(bundleDescription2);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(iterator.next()), false);
        }
        return bl;
    }

    private void resolveFragment(ResolverBundle resolverBundle) {
        if (!resolverBundle.isFragment()) {
            return;
        }
        if (!(resolverBundle.getHost().getNumPossibleSuppliers() <= 0 || this.developmentMode && this.state.getResolverErrors(resolverBundle.getBundle()).length != 0)) {
            this.setBundleResolved(resolverBundle);
        }
    }

    private boolean resolveBundle(ResolverBundle resolverBundle, ArrayList arrayList) {
        int n;
        ResolverConstraint[] resolverConstraintArray;
        if (resolverBundle.isFragment()) {
            return false;
        }
        if (!resolverBundle.isResolvable()) {
            if (DEBUG) {
                ResolverImpl.log("  - " + resolverBundle + " is unresolvable");
            }
            return false;
        }
        switch (resolverBundle.getState()) {
            case 2: {
                if (DEBUG) {
                    ResolverImpl.log("  - " + resolverBundle + " already resolved");
                }
                return true;
            }
            case 0: {
                resolverBundle.clearWires();
                this.setBundleResolving(resolverBundle);
                break;
            }
            case 1: {
                if (!arrayList.contains(resolverBundle)) break;
                return true;
            }
        }
        boolean bl = false;
        if (!bl) {
            resolverConstraintArray = resolverBundle.getGenericRequires();
            n = 0;
            while (n < resolverConstraintArray.length) {
                if (!this.resolveGenericReq((GenericConstraint)resolverConstraintArray[n], arrayList)) {
                    if (DEBUG || DEBUG_GENERICS) {
                        ResolverImpl.log("** GENERICS " + resolverConstraintArray[n].getVersionConstraint().getName() + "[" + resolverConstraintArray[n].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(resolverConstraintArray[n].getVersionConstraint().getBundle(), 32768, resolverConstraintArray[n].getVersionConstraint().toString(), resolverConstraintArray[n].getVersionConstraint());
                    if (resolverConstraintArray[n].isFromFragment()) {
                        if (!this.developmentMode) {
                            this.resolverExports.remove(resolverBundle.detachFragment((ResolverBundle)this.bundleMapping.get(resolverConstraintArray[n].getVersionConstraint().getBundle()), null));
                        }
                    } else if (!this.developmentMode) {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            resolverConstraintArray = resolverBundle.getRequires();
            n = 0;
            while (n < resolverConstraintArray.length) {
                if (!this.resolveRequire((BundleConstraint)resolverConstraintArray[n], arrayList)) {
                    if (DEBUG || DEBUG_REQUIRES) {
                        ResolverImpl.log("** REQUIRE " + resolverConstraintArray[n].getVersionConstraint().getName() + "[" + resolverConstraintArray[n].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(resolverConstraintArray[n].getVersionConstraint().getBundle(), 2, resolverConstraintArray[n].getVersionConstraint().toString(), resolverConstraintArray[n].getVersionConstraint());
                    if (resolverConstraintArray[n].isFromFragment()) {
                        if (!this.developmentMode) {
                            this.resolverExports.remove(resolverBundle.detachFragment((ResolverBundle)this.bundleMapping.get(resolverConstraintArray[n].getVersionConstraint().getBundle()), resolverConstraintArray[n]));
                        }
                    } else if (!this.developmentMode) {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            resolverConstraintArray = resolverBundle.getImportPackages();
            n = 0;
            while (n < resolverConstraintArray.length) {
                if (!((ResolverImport)resolverConstraintArray[n]).isDynamic() && !this.resolveImport((ResolverImport)resolverConstraintArray[n], arrayList)) {
                    if (DEBUG || DEBUG_IMPORTS) {
                        ResolverImpl.log("** IMPORT " + ((ResolverImport)resolverConstraintArray[n]).getName() + "[" + resolverConstraintArray[n].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(resolverConstraintArray[n].getVersionConstraint().getBundle(), 1, resolverConstraintArray[n].getVersionConstraint().toString(), resolverConstraintArray[n].getVersionConstraint());
                    if (resolverConstraintArray[n].isFromFragment()) {
                        if (!this.developmentMode) {
                            this.resolverExports.remove(resolverBundle.detachFragment((ResolverBundle)this.bundleMapping.get(resolverConstraintArray[n].getVersionConstraint().getBundle()), resolverConstraintArray[n]));
                        }
                    } else if (!this.developmentMode) {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        this.checkFragmentConstraints(resolverBundle);
        if (this.developmentMode && !bl && this.state.getResolverErrors(resolverBundle.getBundle()).length > 0) {
            bl = true;
        }
        if (bl) {
            this.setBundleUnresolved(resolverBundle, false, this.developmentMode);
            if (DEBUG) {
                ResolverImpl.log(resolverBundle + " NOT RESOLVED");
            }
        } else if (!arrayList.contains(resolverBundle)) {
            this.setBundleResolved(resolverBundle);
            if (DEBUG) {
                ResolverImpl.log(resolverBundle + " RESOLVED");
            }
        }
        if (resolverBundle.getState() == 0) {
            resolverBundle.setResolvable(false);
        }
        return resolverBundle.getState() != 0;
    }

    private void checkFragmentConstraints(ResolverBundle resolverBundle) {
        ResolverBundle[] resolverBundleArray = resolverBundle.getFragments();
        int n = 0;
        while (n < resolverBundleArray.length) {
            BundleDescription bundleDescription = resolverBundleArray[n].getBundle();
            if (resolverBundle.constraintsConflict(bundleDescription, bundleDescription.getImportPackages(), bundleDescription.getRequiredBundles(), bundleDescription.getGenericRequires()) && !this.developmentMode) {
                this.resolverExports.remove(resolverBundle.detachFragment(resolverBundleArray[n], null));
            }
            ++n;
        }
    }

    private boolean resolveRequire(BundleConstraint bundleConstraint, ArrayList arrayList) {
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + bundleConstraint.getBundle() + ", " + bundleConstraint.getVersionConstraint());
        }
        if (bundleConstraint.getSelectedSupplier() != null) {
            if (!arrayList.contains(bundleConstraint.getBundle())) {
                arrayList.add(bundleConstraint.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log("require-bundle cycle: " + bundleConstraint.getBundle() + " -> " + bundleConstraint.getSelectedSupplier());
                }
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        Object[] objectArray = this.resolverBundles.get(bundleConstraint.getVersionConstraint().getName());
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            ResolverBundle resolverBundle = (ResolverBundle)objectArray[n];
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("CHECKING: " + resolverBundle.getBundle());
            }
            if (bundleConstraint.isSatisfiedBy(resolverBundle)) {
                resolverBundle.addRef(bundleConstraint.getBundle());
                bundleConstraint.addPossibleSupplier(resolverBundle);
                if (bundleConstraint.getBundle() != resolverBundle && resolverBundle.getState() != 2 && !this.resolveBundle(resolverBundle, arrayList) && !this.developmentMode) {
                    bundleConstraint.removePossibleSupplier(resolverBundle);
                } else {
                    if (bundleConstraint.getBundle() != resolverBundle && resolverBundle.getState() == 1 && !arrayList.contains(bundleConstraint.getBundle())) {
                        arrayList.add(bundleConstraint.getBundle());
                        if (DEBUG_CYCLES) {
                            ResolverImpl.log("require-bundle cycle: " + bundleConstraint.getBundle() + " -> " + bundleConstraint.getSelectedSupplier());
                        }
                    }
                    if (DEBUG_REQUIRES) {
                        ResolverImpl.log("Found match: " + resolverBundle.getBundle() + ". Wiring");
                    }
                    bl = true;
                }
            }
            ++n;
        }
        return bl || bundleConstraint.isOptional();
    }

    private boolean resolveImport(ResolverImport resolverImport, ArrayList arrayList) {
        if (DEBUG_IMPORTS) {
            ResolverImpl.log("Trying to resolve: " + resolverImport.getBundle() + ", " + resolverImport.getName());
        }
        if (resolverImport.getSelectedSupplier() != null) {
            if (!arrayList.contains(resolverImport.getBundle())) {
                arrayList.add(resolverImport.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log("import-package cycle: " + resolverImport.getBundle() + " -> " + resolverImport.getSelectedSupplier() + " from " + resolverImport.getSelectedSupplier().getBundle());
                }
            }
            if (DEBUG_IMPORTS) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        boolean bl = false;
        Object[] objectArray = this.resolverExports.get(resolverImport.getName());
        int n = 0;
        while (n < objectArray.length) {
            block23: {
                ResolverExport resolverExport;
                block25: {
                    block24: {
                        resolverExport = (ResolverExport)objectArray[n];
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log("CHECKING: " + resolverExport.getExporter().getBundle() + ", " + resolverExport.getName());
                        }
                        if (!resolverImport.isSatisfiedBy(resolverExport)) break block23;
                        int n2 = resolverExport.getExporter().getState();
                        if (resolverImport.isDynamic() && n2 != 2 || resolverImport.getBundle() == resolverExport.getExporter() && !resolverExport.getExportPackageDescription().isRoot()) break block23;
                        if (resolverImport.getSelectedSupplier() != null && ((ResolverExport)resolverImport.getSelectedSupplier()).getExporter() == resolverImport.getBundle()) break;
                        resolverExport.getExporter().addRef(resolverImport.getBundle());
                        resolverImport.addPossibleSupplier(resolverExport);
                        ResolverExport[] resolverExportArray = null;
                        if (resolverImport.getBundle() == resolverExport.getExporter()) break block24;
                        resolverExportArray = resolverImport.getBundle().getExports(resolverImport.getName());
                        int n3 = 0;
                        while (n3 < resolverExportArray.length) {
                            if (!resolverExportArray[n3].getExportPackageDescription().isRoot() || resolverExport.getExportPackageDescription().isRoot()) {
                                if (resolverExportArray[n3].getExportPackageDescription().isRoot()) {
                                    this.resolverExports.remove(resolverExportArray[n3]);
                                }
                                ++n3;
                                continue;
                            }
                            break block23;
                        }
                        if (n2 != 2 && !this.resolveBundle(resolverExport.getExporter(), arrayList) && !this.developmentMode || resolverExport.isDropped()) {
                            resolverImport.removePossibleSupplier(resolverExport);
                            n3 = 0;
                            while (n3 < resolverExportArray.length) {
                                this.resolverExports.put(resolverExportArray[n3].getName(), resolverExportArray[n3]);
                                ++n3;
                            }
                        }
                        break block25;
                        break block23;
                    }
                    if (resolverExport.isDropped()) break block23;
                }
                if (resolverImport.getBundle() != resolverExport.getExporter() && resolverExport.getExporter().getState() == 1 && !arrayList.contains(resolverImport.getBundle())) {
                    arrayList.add(resolverImport.getBundle());
                    if (DEBUG_CYCLES) {
                        ResolverImpl.log("import-package cycle: " + resolverImport.getBundle() + " -> " + resolverImport.getSelectedSupplier() + " from " + resolverImport.getSelectedSupplier().getBundle());
                    }
                }
                if (DEBUG_IMPORTS) {
                    ResolverImpl.log("Found match: " + resolverExport.getExporter() + ". Wiring " + resolverImport.getBundle() + ":" + resolverImport.getName());
                }
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return true;
        }
        if (this.resolveImportReprovide(resolverImport, arrayList)) {
            return true;
        }
        return resolverImport.isOptional();
    }

    private boolean resolveImportReprovide(ResolverImport resolverImport, ArrayList arrayList) {
        String string = ((ImportPackageSpecification)resolverImport.getVersionConstraint()).getBundleSymbolicName();
        if (string == null) {
            return false;
        }
        if (DEBUG_IMPORTS) {
            ResolverImpl.log("Checking reprovides: " + resolverImport.getName());
        }
        Object[] objectArray = this.resolverBundles.get(string);
        int n = 0;
        while (n < objectArray.length) {
            if (this.resolveBundle((ResolverBundle)objectArray[n], arrayList) && this.resolveImportReprovide0(resolverImport, (ResolverBundle)objectArray[n], (ResolverBundle)objectArray[n], arrayList, new ArrayList(5))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void setBundleUnresolved(ResolverBundle resolverBundle, boolean bl, boolean bl2) {
        if (resolverBundle.getState() == 0 && !this.developmentMode) {
            return;
        }
        if (bl || !bl2) {
            this.resolverExports.remove(resolverBundle.getExportPackages());
            this.resolverGenerics.remove(resolverBundle.getGenericCapabilities());
            resolverBundle.detachAllFragments();
            resolverBundle.initialize(false);
            if (!bl) {
                this.resolverExports.put(resolverBundle.getExportPackages());
                this.resolverGenerics.put(resolverBundle.getGenericCapabilities());
            }
        }
        if (!(bl || this.developmentMode && this.unresolvedBundles.contains(resolverBundle))) {
            this.unresolvedBundles.add(resolverBundle);
        }
        resolverBundle.setState(0);
    }

    private void setBundleResolved(ResolverBundle resolverBundle) {
        if (resolverBundle.getState() == 2) {
            return;
        }
        this.unresolvedBundles.remove(resolverBundle);
        resolverBundle.setState(2);
    }

    private void setBundleResolving(ResolverBundle resolverBundle) {
        if (resolverBundle.getState() == 1) {
            return;
        }
        this.unresolvedBundles.remove(resolverBundle);
        resolverBundle.setState(1);
    }

    private void stateResolveBundles(ResolverBundle[] resolverBundleArray) {
        int n = 0;
        while (n < resolverBundleArray.length) {
            if (!resolverBundleArray[n].getBundle().isResolved()) {
                this.stateResolveBundle(resolverBundleArray[n]);
            }
            ++n;
        }
    }

    private void stateResolveConstraints(ResolverBundle resolverBundle) {
        GenericCapability[] genericCapabilityArray;
        Object object;
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            ResolverExport resolverExport = (ResolverExport)resolverImportArray[n].getSelectedSupplier();
            object = resolverExport == null ? null : resolverExport.getExportPackageDescription();
            this.state.resolveConstraint(resolverImportArray[n].getVersionConstraint(), (BaseDescription)object);
            ++n;
        }
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            object = (ResolverBundle)bundleConstraintArray[n2].getSelectedSupplier();
            genericCapabilityArray = object == null ? null : ((ResolverBundle)object).getBundle();
            this.state.resolveConstraint(bundleConstraintArray[n2].getVersionConstraint(), (BaseDescription)genericCapabilityArray);
            ++n2;
        }
        GenericConstraint[] genericConstraintArray = resolverBundle.getGenericRequires();
        int n3 = 0;
        while (n3 < genericConstraintArray.length) {
            genericCapabilityArray = genericConstraintArray[n3].getMatchingCapabilities();
            if (genericCapabilityArray == null) {
                this.state.resolveConstraint(genericConstraintArray[n3].getVersionConstraint(), null);
            } else {
                int n4 = 0;
                while (n4 < genericCapabilityArray.length) {
                    this.state.resolveConstraint(genericConstraintArray[n3].getVersionConstraint(), genericCapabilityArray[n4].getBaseDescription());
                    ++n4;
                }
            }
            ++n3;
        }
    }

    private void stateResolveFragConstraints(ResolverBundle resolverBundle) {
        Object object;
        ResolverExport resolverExport;
        ResolverBundle resolverBundle2 = (ResolverBundle)resolverBundle.getHost().getSelectedSupplier();
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle.getBundle().getImportPackages();
        int n = 0;
        while (n < importPackageSpecificationArray.length) {
            ResolverImport resolverImport = resolverBundle2 == null ? null : resolverBundle2.getImport(importPackageSpecificationArray[n].getName());
            resolverExport = (ResolverExport)(resolverImport == null ? null : resolverImport.getSelectedSupplier());
            object = resolverExport == null ? null : resolverExport.getExportPackageDescription();
            this.state.resolveConstraint(importPackageSpecificationArray[n], (BaseDescription)object);
            ++n;
        }
        BundleSpecification[] bundleSpecificationArray = resolverBundle.getBundle().getRequiredBundles();
        int n2 = 0;
        while (n2 < bundleSpecificationArray.length) {
            resolverExport = resolverBundle2 == null ? null : resolverBundle2.getRequire(bundleSpecificationArray[n2].getName());
            object = (ResolverBundle)(resolverExport == null ? null : ((ResolverConstraint)((Object)resolverExport)).getSelectedSupplier());
            BundleDescription bundleDescription = object == null ? null : ((ResolverBundle)object).getBundle();
            this.state.resolveConstraint(bundleSpecificationArray[n2], bundleDescription);
            ++n2;
        }
    }

    private void stateResolveBundle(ResolverBundle resolverBundle) {
        VersionSupplier[] versionSupplierArray;
        if (!resolverBundle.isResolved() && !this.developmentMode) {
            return;
        }
        if (resolverBundle.isFragment()) {
            this.stateResolveFragConstraints(resolverBundle);
        } else {
            this.stateResolveConstraints(resolverBundle);
        }
        ResolverExport[] resolverExportArray = resolverBundle.getSelectedExports();
        ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>(resolverExportArray.length);
        int n = 0;
        while (n < resolverExportArray.length) {
            arrayList.add(resolverExportArray[n].getExportPackageDescription());
            ++n;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        ArrayList<BaseDescription> arrayList2 = new ArrayList<BaseDescription>(resolverImportArray.length);
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            if (resolverImportArray[n2].getSelectedSupplier() != null) {
                arrayList2.add(resolverImportArray[n2].getSelectedSupplier().getBaseDescription());
            }
            ++n2;
        }
        ExportPackageDescription[] exportPackageDescriptionArray2 = arrayList2.toArray(new ExportPackageDescription[arrayList2.size()]);
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        ArrayList<BaseDescription> arrayList3 = new ArrayList<BaseDescription>(bundleConstraintArray.length);
        int n3 = 0;
        while (n3 < bundleConstraintArray.length) {
            if (bundleConstraintArray[n3].getSelectedSupplier() != null) {
                arrayList3.add(bundleConstraintArray[n3].getSelectedSupplier().getBaseDescription());
            }
            ++n3;
        }
        BundleDescription[] bundleDescriptionArray = arrayList3.toArray(new BundleDescription[arrayList3.size()]);
        BundleDescription[] bundleDescriptionArray2 = null;
        if (resolverBundle.isFragment() && (versionSupplierArray = resolverBundle.getHost().getPossibleSuppliers()) != null && versionSupplierArray.length > 0) {
            bundleDescriptionArray2 = new BundleDescription[versionSupplierArray.length];
            int n4 = 0;
            while (n4 < versionSupplierArray.length) {
                bundleDescriptionArray2[n4] = versionSupplierArray[n4].getBundle();
                if (resolverBundle.isNewFragmentExports() && bundleDescriptionArray2[n4].isResolved()) {
                    ResolverExport[] resolverExportArray2 = ((ResolverBundle)versionSupplierArray[n4]).getSelectedExports();
                    ExportPackageDescription[] exportPackageDescriptionArray3 = new ExportPackageDescription[resolverExportArray2.length];
                    int n5 = 0;
                    while (n5 < resolverExportArray2.length) {
                        exportPackageDescriptionArray3[n5] = resolverExportArray2[n5].getExportPackageDescription();
                        ++n5;
                    }
                    this.state.resolveBundle(bundleDescriptionArray2[n4], true, null, exportPackageDescriptionArray3, bundleDescriptionArray2[n4].getResolvedRequires(), bundleDescriptionArray2[n4].getResolvedImports());
                }
                ++n4;
            }
        }
        this.state.resolveBundle(resolverBundle.getBundle(), resolverBundle.isResolved(), bundleDescriptionArray2, exportPackageDescriptionArray, bundleDescriptionArray, exportPackageDescriptionArray2);
    }

    public void bundleAdded(BundleDescription bundleDescription) {
        if (!this.initialized) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.unresolvedBundles.size()) {
            ResolverBundle resolverBundle = (ResolverBundle)this.unresolvedBundles.get(n);
            if (resolverBundle.getBundle() == bundleDescription) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            ResolverBundle resolverBundle = new ResolverBundle(bundleDescription, this);
            this.bundleMapping.put(bundleDescription, resolverBundle);
            this.unresolvedBundles.add(resolverBundle);
            this.resolverExports.put(resolverBundle.getExportPackages());
            this.resolverBundles.put(resolverBundle.getName(), resolverBundle);
            this.resolverGenerics.put(resolverBundle.getGenericCapabilities());
        }
    }

    private void unresolveBundle(ResolverBundle resolverBundle, boolean bl) {
        if (resolverBundle == null) {
            return;
        }
        Object[] objectArray = this.removalPending.remove(new Long(resolverBundle.getBundle().getBundleId()));
        int n = 0;
        while (n < objectArray.length) {
            ResolverBundle resolverBundle2 = (ResolverBundle)this.bundleMapping.get(objectArray[n]);
            this.unresolveBundle(resolverBundle2, true);
            this.state.removeBundleComplete((BundleDescription)objectArray[n]);
            this.resolverExports.remove(resolverBundle2.getExportPackages());
            this.resolverBundles.remove(resolverBundle2);
            this.resolverGenerics.remove(resolverBundle2.getGenericCapabilities());
            this.bundleMapping.remove(objectArray[n]);
            this.groupingChecker.clear(resolverBundle2);
            if (objectArray[n] == resolverBundle.getBundle()) {
                bl = true;
            }
            ++n;
        }
        if (!resolverBundle.getBundle().isResolved() && !this.developmentMode) {
            return;
        }
        this.setBundleUnresolved(resolverBundle, bl, false);
        BundleDescription[] bundleDescriptionArray = resolverBundle.getBundle().getDependents();
        this.state.resolveBundle(resolverBundle.getBundle(), false, null, null, null, null);
        int n2 = 0;
        while (n2 < bundleDescriptionArray.length) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(bundleDescriptionArray[n2]), false);
            ++n2;
        }
    }

    public void bundleUpdated(BundleDescription bundleDescription, BundleDescription bundleDescription2, boolean bl) {
        this.bundleRemoved(bundleDescription2, bl);
        this.bundleAdded(bundleDescription);
    }

    public void flush() {
        this.resolverExports = null;
        this.resolverBundles = null;
        this.resolverGenerics = null;
        this.unresolvedBundles = null;
        this.bundleMapping = null;
        Object[] objectArray = this.removalPending.getAllValues();
        int n = 0;
        while (n < objectArray.length) {
            this.state.removeBundleComplete((BundleDescription)objectArray[n]);
            ++n;
        }
        this.removalPending.clear();
        this.initialized = false;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
        this.flush();
    }

    private void setDebugOptions() {
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions == null) {
            return;
        }
        DEBUG = frameworkDebugOptions.getBooleanOption(OPTION_DEBUG, false);
        DEBUG_WIRING = frameworkDebugOptions.getBooleanOption(OPTION_WIRING, false);
        DEBUG_IMPORTS = frameworkDebugOptions.getBooleanOption(OPTION_IMPORTS, false);
        DEBUG_REQUIRES = frameworkDebugOptions.getBooleanOption(OPTION_REQUIRES, false);
        DEBUG_GENERICS = frameworkDebugOptions.getBooleanOption(OPTION_GENERICS, false);
        DEBUG_GROUPING = frameworkDebugOptions.getBooleanOption(OPTION_GROUPING, false);
        DEBUG_CYCLES = frameworkDebugOptions.getBooleanOption(OPTION_CYCLES, false);
    }

    static void log(String string) {
        Debug.println(string);
    }

    VersionHashMap getResolverExports() {
        return this.resolverExports;
    }

    public void setSelectionPolicy(Comparator comparator) {
        this.selectionPolicy = comparator;
    }

    public Comparator getSelectionPolicy() {
        return this.selectionPolicy;
    }

    private void rewireBundle(ResolverBundle resolverBundle, ArrayList arrayList) {
        if (arrayList.contains(resolverBundle)) {
            return;
        }
        arrayList.add(resolverBundle);
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            this.rewireRequire(bundleConstraintArray[n], arrayList);
            ++n;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            this.rewireImport(resolverImportArray[n2], arrayList);
            ++n2;
        }
        GenericConstraint[] genericConstraintArray = resolverBundle.getGenericRequires();
        int n3 = 0;
        while (n3 < genericConstraintArray.length) {
            this.rewireGeneric(genericConstraintArray[n3], arrayList);
            ++n3;
        }
    }

    private void rewireGeneric(GenericConstraint genericConstraint, ArrayList arrayList) {
        if (genericConstraint.getMatchingCapabilities() != null) {
            return;
        }
        GenericDescription[] genericDescriptionArray = ((GenericSpecification)genericConstraint.getVersionConstraint()).getSuppliers();
        if (genericDescriptionArray == null) {
            return;
        }
        Object[] objectArray = this.resolverGenerics.get(genericConstraint.getName());
        int n = 0;
        while (n < objectArray.length) {
            GenericCapability genericCapability = (GenericCapability)objectArray[n];
            int n2 = 0;
            while (n2 < genericDescriptionArray.length) {
                if (genericCapability.getBaseDescription() == genericDescriptionArray[n2]) {
                    genericConstraint.setMatchingCapability(genericCapability);
                }
                ++n2;
            }
            ++n;
        }
        GenericCapability[] genericCapabilityArray = genericConstraint.getMatchingCapabilities();
        if (genericCapabilityArray != null) {
            int n3 = 0;
            while (n3 < genericCapabilityArray.length) {
                this.rewireBundle(genericCapabilityArray[n3].getResolverBundle(), arrayList);
                ++n3;
            }
        }
    }

    private void rewireRequire(BundleConstraint bundleConstraint, ArrayList arrayList) {
        if (bundleConstraint.getSelectedSupplier() != null) {
            return;
        }
        ResolverBundle resolverBundle = (ResolverBundle)this.bundleMapping.get(bundleConstraint.getVersionConstraint().getSupplier());
        bundleConstraint.addPossibleSupplier(resolverBundle);
        if (resolverBundle == null && !bundleConstraint.isOptional()) {
            System.err.println("Could not find matching bundle for " + bundleConstraint.getVersionConstraint());
        }
        if (resolverBundle != null) {
            this.rewireBundle(resolverBundle, arrayList);
        }
    }

    private void rewireImport(ResolverImport resolverImport, ArrayList arrayList) {
        if (resolverImport.isDynamic() || resolverImport.getSelectedSupplier() != null) {
            return;
        }
        ResolverExport resolverExport = null;
        ExportPackageDescription exportPackageDescription = (ExportPackageDescription)resolverImport.getVersionConstraint().getSupplier();
        ResolverBundle resolverBundle = exportPackageDescription == null ? null : (ResolverBundle)this.bundleMapping.get(exportPackageDescription.getExporter());
        Object[] objectArray = this.resolverExports.get(resolverImport.getName());
        int n = 0;
        while (n < objectArray.length) {
            ResolverExport resolverExport2 = (ResolverExport)objectArray[n];
            if (resolverExport2.getExporter() == resolverBundle && exportPackageDescription == resolverExport2.getExportPackageDescription()) {
                resolverExport = resolverExport2;
                break;
            }
            ++n;
        }
        resolverImport.addPossibleSupplier(resolverExport);
        if (resolverExport == null && resolverBundle != null) {
            ResolverExport resolverExport3 = new ResolverExport(resolverBundle, exportPackageDescription);
            if (resolverBundle.getExport(resolverImport.getName()) == null) {
                resolverBundle.addExport(resolverExport3);
                this.resolverExports.put(resolverExport3.getName(), resolverExport3);
            }
            resolverImport.addPossibleSupplier(resolverExport3);
        }
        if (resolverImport.getSelectedSupplier() == null && !resolverImport.isOptional()) {
            System.err.println("Could not find matching export for " + resolverImport.getVersionConstraint());
        }
        if (resolverImport.getSelectedSupplier() != null) {
            this.rewireBundle(((ResolverExport)resolverImport.getSelectedSupplier()).getExporter(), arrayList);
        }
    }

    private void addUnresolvedWithDependents(ResolverBundle resolverBundle, HashSet hashSet) throws  {
        ResolverImpl$$Cold.addUnresolvedWithDependents(this, resolverBundle, hashSet);
    }

    private void addHostsFromFragmentConstraints(ResolverBundle resolverBundle, Set set) {
        if (!resolverBundle.isFragment()) {
            return;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle.getBundle().getImportPackages();
        BundleSpecification[] bundleSpecificationArray = resolverBundle.getBundle().getRequiredBundles();
        if (importPackageSpecificationArray.length == 0 && bundleSpecificationArray.length == 0) {
            return;
        }
        BundleConstraint bundleConstraint = resolverBundle.getHost();
        Object[] objectArray = this.resolverBundles.get(bundleConstraint.getVersionConstraint().getName());
        int n = 0;
        while (n < objectArray.length) {
            if (bundleConstraint.isSatisfiedBy((VersionSupplier)objectArray[n]) && ((ResolverBundle)objectArray[n]).isResolved()) {
                set.add(((ResolverBundle)objectArray[n]).getBundle());
            }
            ++n;
        }
    }

    private void resolveOptionalConstraints(ResolverBundle[] resolverBundleArray) {
        int n = 0;
        while (n < resolverBundleArray.length) {
            if (resolverBundleArray[n] != null) {
                this.resolveOptionalConstraints(resolverBundleArray[n]);
            }
            ++n;
        }
    }

    private void resolveOptionalConstraints(ResolverBundle resolverBundle) {
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        int n = 0;
        while (n < bundleConstraintArray.length) {
            if (bundleConstraintArray[n].isOptional() && bundleConstraintArray[n].getSelectedSupplier() == null) {
                arrayList.clear();
                this.resolveRequire(bundleConstraintArray[n], arrayList);
                if (bundleConstraintArray[n].getSelectedSupplier() != null) {
                    bl = true;
                }
            }
            ++n;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            if (resolverImportArray[n2].isOptional() && resolverImportArray[n2].getSelectedSupplier() == null) {
                arrayList.clear();
                this.resolveImport(resolverImportArray[n2], arrayList);
                if (resolverImportArray[n2].getSelectedSupplier() != null) {
                    bl = true;
                }
            }
            ++n2;
        }
        if (bl) {
            this.state.resolveBundle(resolverBundle.getBundle(), false, null, null, null, null);
            this.stateResolveConstraints(resolverBundle);
            this.stateResolveBundle(resolverBundle);
        }
    }

    private long getNumCombinations(ResolverConstraint[][] resolverConstraintArray) throws  {
        return ResolverImpl$$Cold.getNumCombinations(this, resolverConstraintArray);
    }

    private int[] getCombination(ResolverConstraint[][] resolverConstraintArray, int[] nArray) throws  {
        return ResolverImpl$$Cold.getCombination(this, resolverConstraintArray, nArray);
    }

    private ArrayList findBestCombination(ResolverBundle[] resolverBundleArray, ResolverConstraint[][] resolverConstraintArray, int[] nArray, ArrayList arrayList) {
        int n = this.getConflictCount(arrayList);
        ResolverBundle[] resolverBundleArray2 = this.getConflictedBundles(arrayList);
        while (n != 0 && this.getNextCombination(resolverConstraintArray)) {
            ArrayList arrayList2;
            int n2;
            if (DEBUG_GROUPING) {
                this.printCombination(this.getCombination(resolverConstraintArray, new int[resolverConstraintArray.length]));
            }
            if ((n2 = this.getConflictCount(arrayList2 = this.getConflicts(resolverBundleArray2, null, null))) >= n || (n2 = this.getConflictCount(arrayList2 = this.getConflicts(resolverBundleArray, null, null))) >= n) continue;
            n = n2;
            arrayList = arrayList2;
            this.getCombination(resolverConstraintArray, nArray);
            resolverBundleArray2 = this.getConflictedBundles(arrayList);
        }
        return arrayList;
    }

    private void printCombination(int[] nArray) throws  {
        ResolverImpl$$Cold.printCombination(this, nArray);
    }

    private ResolverBundle[] getConflictedBundles(ArrayList arrayList) throws  {
        return ResolverImpl$$Cold.getConflictedBundles(this, arrayList);
    }

    private boolean getNextCombination(ResolverConstraint[][] resolverConstraintArray) throws  {
        return ResolverImpl$$Cold.getNextCombination(this, resolverConstraintArray);
    }

    private int getConflictCount(ArrayList arrayList) throws  {
        return ResolverImpl$$Cold.getConflictCount(this, arrayList);
    }

    private void addConflictNames(GroupingChecker$PackageRoots[][] groupingChecker$PackageRootsArray, HashSet hashSet, HashSet hashSet2) throws  {
        ResolverImpl$$Cold.addConflictNames(this, groupingChecker$PackageRootsArray, hashSet, hashSet2);
    }

    private ResolverConstraint[][] getMultipleSuppliers(ResolverBundle[] resolverBundleArray, HashSet hashSet, HashSet hashSet2) {
        ArrayList<ResolverConstraint[]> arrayList;
        block16: {
            Object object;
            ArrayList<Object> arrayList2;
            ArrayList<Object> arrayList3;
            block15: {
                VersionSupplier[] versionSupplierArray;
                ResolverConstraint[] resolverConstraintArray;
                Object object2;
                arrayList3 = new ArrayList<Object>(1);
                arrayList2 = new ArrayList<Object>(1);
                int n = 0;
                while (n < resolverBundleArray.length) {
                    object = resolverBundleArray[n].getRequires();
                    int n2 = 0;
                    while (n2 < ((BundleConstraint[])object).length) {
                        if (object[n2].getNumPossibleSuppliers() > 1) {
                            arrayList2.add(object[n2]);
                        }
                        ++n2;
                    }
                    object2 = resolverBundleArray[n].getImportPackages();
                    int n3 = 0;
                    while (n3 < ((Object)object2).length) {
                        if (((ResolverConstraint)object2[n3]).getNumPossibleSuppliers() > 1) {
                            resolverConstraintArray = (ResolverConstraint[])((ResolverExport)((ResolverConstraint)object2[n3]).getSelectedSupplier()).getExportPackageDescription().getDirective("x-equinox-ee");
                            if (resolverConstraintArray.intValue() < 0) {
                                arrayList3.add(object2[n3]);
                            } else {
                                versionSupplierArray = ((ResolverConstraint)object2[n3]).getPossibleSuppliers();
                                int n4 = 1;
                                while (n4 < versionSupplierArray.length) {
                                    Integer n5 = (Integer)((ResolverExport)versionSupplierArray[n4]).getExportPackageDescription().getDirective("x-equinox-ee");
                                    if (n5 < 0 && ((ResolverExport)versionSupplierArray[n4]).getExporter().getRequire("org.eclipse.osgi") == null && ((ResolverExport)versionSupplierArray[n4]).getExporter().getRequire("system.bundle") == null) {
                                        arrayList3.add(object2[n3]);
                                        break;
                                    }
                                    ++n4;
                                }
                            }
                        }
                        ++n3;
                    }
                    ++n;
                }
                arrayList = new ArrayList<ResolverConstraint[]>();
                if (arrayList3.size() + arrayList2.size() <= MAX_MULTIPLE_SUPPLIERS_MERGE) break block15;
                object = new HashMap(1);
                object2 = arrayList3.iterator();
                while (object2.hasNext()) {
                    this.addMutipleSupplierConstraint((HashMap)object, (ResolverConstraint)object2.next());
                }
                object2 = new HashMap(1);
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    this.addMutipleSupplierConstraint((HashMap)object2, (ResolverConstraint)iterator.next());
                }
                this.addMergedSuppliers(arrayList, (HashMap)object);
                this.addMergedSuppliers(arrayList, (HashMap)object2);
                if (arrayList.size() <= MAX_MULTIPLE_SUPPLIERS_MERGE || hashSet == null || hashSet2 == null) break block16;
                iterator = arrayList.iterator();
                arrayList = new ArrayList();
                while (iterator.hasNext()) {
                    resolverConstraintArray = (ResolverConstraint[])iterator.next();
                    VersionSupplier[] versionSupplierArray2 = versionSupplierArray = resolverConstraintArray.length > 0 ? resolverConstraintArray[0] : null;
                    if (versionSupplierArray instanceof ResolverImport) {
                        if (!hashSet.contains(versionSupplierArray.getName())) continue;
                        arrayList.add(resolverConstraintArray);
                        continue;
                    }
                    if (!(versionSupplierArray instanceof BundleConstraint) || !hashSet2.contains(versionSupplierArray.getName())) continue;
                    arrayList.add(resolverConstraintArray);
                }
                break block16;
            }
            object = arrayList3.iterator();
            while (object.hasNext()) {
                arrayList.add(new ResolverConstraint[]{(ResolverConstraint)object.next()});
            }
            object = arrayList2.iterator();
            while (object.hasNext()) {
                arrayList.add(new ResolverConstraint[]{(ResolverConstraint)object.next()});
            }
        }
        return (ResolverConstraint[][])arrayList.toArray((T[])new ResolverConstraint[arrayList.size()][]);
    }

    private void addMergedSuppliers(ArrayList arrayList, HashMap hashMap) throws  {
        ResolverImpl$$Cold.addMergedSuppliers(this, arrayList, hashMap);
    }

    private void addMutipleSupplierConstraint(HashMap hashMap, ResolverConstraint resolverConstraint) throws  {
        ResolverImpl$$Cold.addMutipleSupplierConstraint(this, hashMap, resolverConstraint);
    }

    private boolean resolveGenericReq(GenericConstraint genericConstraint, ArrayList arrayList) {
        GenericCapability[] genericCapabilityArray;
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + genericConstraint.getBundle() + ", " + genericConstraint.getVersionConstraint());
        }
        if ((genericCapabilityArray = genericConstraint.getMatchingCapabilities()) != null) {
            int n = 0;
            while (n < genericCapabilityArray.length) {
                if (genericCapabilityArray[n].getResolverBundle().getState() == 1 && !arrayList.contains(genericConstraint.getBundle())) {
                    arrayList.add(genericConstraint.getBundle());
                }
                ++n;
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        Object[] objectArray = this.resolverGenerics.get(genericConstraint.getVersionConstraint().getName());
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            GenericCapability genericCapability = (GenericCapability)objectArray[n];
            if (DEBUG_GENERICS) {
                ResolverImpl.log("CHECKING GENERICS: " + genericCapability.getBaseDescription());
            }
            if (genericConstraint.isSatisfiedBy(genericCapability)) {
                genericCapability.getResolverBundle().addRef(genericConstraint.getBundle());
                if (!bl || (((GenericSpecification)genericConstraint.getVersionConstraint()).getResolution() & 2) != 0) {
                    genericConstraint.setMatchingCapability(genericCapability);
                    if (genericConstraint.getBundle() == genericCapability.getResolverBundle()) {
                        bl = true;
                    } else {
                        VersionSupplier[] versionSupplierArray;
                        if (genericCapability.isFromFragment()) {
                            versionSupplierArray = genericCapability.getResolverBundle().getHost().getPossibleSuppliers();
                        } else {
                            ResolverBundle[] resolverBundleArray = new ResolverBundle[1];
                            versionSupplierArray = resolverBundleArray;
                            resolverBundleArray[0] = genericCapability.getResolverBundle();
                        }
                        VersionSupplier[] versionSupplierArray2 = versionSupplierArray;
                        boolean bl2 = false;
                        int n2 = 0;
                        while (versionSupplierArray2 != null && n2 < versionSupplierArray2.length) {
                            ResolverBundle resolverBundle = (ResolverBundle)versionSupplierArray2[n2];
                            if (resolverBundle == genericConstraint.getBundle()) {
                                bl2 = true;
                            } else if (resolverBundle.getState() == 2 || this.resolveBundle(resolverBundle, arrayList) || this.developmentMode) {
                                bl2 |= !genericCapability.isFromFragment() ? true : genericCapability.getResolverBundle().getHost().getPossibleSuppliers() != null;
                                if (resolverBundle.getState() == 1 && !arrayList.contains(resolverBundle)) {
                                    arrayList.add(resolverBundle);
                                }
                            }
                            ++n2;
                        }
                        if (!bl2) {
                            genericConstraint.removeMatchingCapability(genericCapability);
                        } else {
                            if (DEBUG_GENERICS) {
                                ResolverImpl.log("Found match: " + genericCapability.getBaseDescription() + ". Wiring");
                            }
                            bl = true;
                        }
                    }
                }
            }
            ++n;
        }
        return bl ? true : (((GenericSpecification)genericConstraint.getVersionConstraint()).getResolution() & 1) != 0;
    }

    private boolean resolveImportReprovide0(ResolverImport resolverImport, ResolverBundle resolverBundle, ResolverBundle resolverBundle2, ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2.contains(resolverBundle2)) {
            return false;
        }
        arrayList2.add(resolverBundle2);
        BundleConstraint[] bundleConstraintArray = resolverBundle2.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            if (((BundleSpecification)bundleConstraintArray[n].getVersionConstraint()).isExported() && bundleConstraintArray[n].getSelectedSupplier() != null) {
                ResolverExport[] resolverExportArray = ((ResolverBundle)bundleConstraintArray[n].getSelectedSupplier()).getExports(resolverImport.getName());
                int n2 = 0;
                while (n2 < resolverExportArray.length) {
                    Map map = resolverExportArray[n2].getExportPackageDescription().getDirectives();
                    map.remove("uses");
                    ExportPackageDescription exportPackageDescription = this.state.getFactory().createExportPackageDescription(resolverExportArray[n2].getName(), resolverExportArray[n2].getVersion(), map, resolverExportArray[n2].getExportPackageDescription().getAttributes(), false, resolverBundle.getBundle());
                    if (resolverImport.getVersionConstraint().isSatisfiedBy(exportPackageDescription)) {
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log(" - Creating re-export for reprovide: " + resolverBundle + ":" + exportPackageDescription.getName());
                        }
                        ResolverExport resolverExport = new ResolverExport(resolverBundle, exportPackageDescription);
                        resolverBundle.addExport(resolverExport);
                        this.resolverExports.put(resolverExport.getName(), resolverExport);
                        resolverImport.addPossibleSupplier(resolverExport);
                        return true;
                    }
                    ++n2;
                }
                if (this.resolveImportReprovide0(resolverImport, resolverBundle, (ResolverBundle)bundleConstraintArray[n].getSelectedSupplier(), arrayList, arrayList2)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public synchronized ExportPackageDescription resolveDynamicImport(BundleDescription bundleDescription, String string) {
        Object object;
        ResolverBundle resolverBundle;
        if (this.state == null) {
            throw (Throwable)new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if ((resolverBundle = (ResolverBundle)this.bundleMapping.get(bundleDescription)).getExport(string) != null) {
            return null;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        boolean bl = false;
        int n = 0;
        while (n < resolverImportArray.length) {
            if (resolverImportArray[n].isDynamic()) {
                object = resolverImportArray[n].getName();
                if (((String)object).equals("*") || ((String)object).endsWith(".*") && string.startsWith(((String)object).substring(0, ((String)object).length() - 2))) {
                    resolverImportArray[n].setName(string);
                }
                if (string.equals(resolverImportArray[n].getName())) {
                    bl = true;
                    this.groupingChecker.populateRoots(resolverImportArray[n].getBundle());
                    if (this.resolveImport(resolverImportArray[n], new ArrayList())) {
                        bl = false;
                        while (!bl && resolverImportArray[n].getSelectedSupplier() != null) {
                            if (this.groupingChecker.isDynamicConsistent(resolverImportArray[n].getBundle(), (ResolverExport)resolverImportArray[n].getSelectedSupplier()) != null) {
                                resolverImportArray[n].selectNextSupplier();
                                continue;
                            }
                            bl = true;
                        }
                        resolverImportArray[n].setName(null);
                        if (!bl) {
                            resolverImportArray[n].setPossibleSuppliers(null);
                            return null;
                        }
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log("Resolved dynamic import: " + resolverBundle + ":" + resolverImportArray[n].getName() + " -> " + ((ResolverExport)resolverImportArray[n].getSelectedSupplier()).getExporter() + ":" + string);
                        }
                        ExportPackageDescription exportPackageDescription = ((ResolverExport)resolverImportArray[n].getSelectedSupplier()).getExportPackageDescription();
                        if (((String)object).endsWith("*")) {
                            resolverImportArray[n].setPossibleSuppliers(null);
                        }
                        return exportPackageDescription;
                    }
                }
                resolverImportArray[n].setName(null);
            }
            ++n;
        }
        if (!bl) {
            HashMap<String, String> hashMap = new HashMap<String, String>(1);
            hashMap.put("resolution", "dynamic");
            object = this.state.getFactory().createImportPackageSpecification(string, null, null, null, hashMap, null, bundleDescription);
            ResolverImport resolverImport = new ResolverImport(resolverBundle, (ImportPackageSpecification)object);
            if (this.resolveImport(resolverImport, new ArrayList())) {
                while (resolverImport.getSelectedSupplier() != null) {
                    if (this.groupingChecker.isDynamicConsistent(resolverBundle, (ResolverExport)resolverImport.getSelectedSupplier()) == null) break;
                    resolverImport.selectNextSupplier();
                }
                return ((ResolverExport)resolverImport.getSelectedSupplier()).getExportPackageDescription();
            }
        }
        if (DEBUG || DEBUG_IMPORTS) {
            ResolverImpl.log("Failed to resolve dynamic import: " + string);
        }
        return null;
    }

    public void bundleRemoved(BundleDescription bundleDescription, boolean bl) {
        if (bl) {
            this.removalPending.put(new Long(bundleDescription.getBundleId()), bundleDescription);
        }
        if (!this.initialized) {
            return;
        }
        ResolverBundle resolverBundle = (ResolverBundle)this.bundleMapping.get(bundleDescription);
        if (resolverBundle == null) {
            return;
        }
        if (!bl) {
            this.bundleMapping.remove(bundleDescription);
            this.groupingChecker.clear(resolverBundle);
        }
        if (!bl || !bundleDescription.isResolved()) {
            this.resolverExports.remove(resolverBundle.getExportPackages());
            this.resolverBundles.remove(resolverBundle);
            this.resolverGenerics.remove(resolverBundle.getGenericCapabilities());
        }
        this.unresolvedBundles.remove(resolverBundle);
    }

    private void printWirings() {
        ResolverImpl.log("****** Result Wirings ******");
        Object[] objectArray = this.resolverBundles.getAllValues();
        int n = 0;
        while (n < objectArray.length) {
            ResolverBundle resolverBundle = (ResolverBundle)objectArray[n];
            if (!resolverBundle.getBundle().isResolved()) {
                int n2;
                Object[] objectArray2;
                ResolverImpl.log("    * WIRING for " + resolverBundle);
                BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
                if (bundleConstraintArray.length == 0) {
                    ResolverImpl.log("        (r) no requires");
                } else {
                    int n3 = 0;
                    while (n3 < bundleConstraintArray.length) {
                        if (bundleConstraintArray[n3].getSelectedSupplier() == null) {
                            ResolverImpl.log("        (r) " + resolverBundle.getBundle() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (r) " + resolverBundle.getBundle() + " -> " + bundleConstraintArray[n3].getSelectedSupplier());
                        }
                        ++n3;
                    }
                }
                BundleConstraint bundleConstraint = resolverBundle.getHost();
                if (bundleConstraint != null && (objectArray2 = bundleConstraint.getPossibleSuppliers()) != null) {
                    n2 = 0;
                    while (n2 < objectArray2.length) {
                        ResolverImpl.log("        (h) " + resolverBundle.getBundle() + " -> " + ((VersionSupplier)objectArray2[n2]).getBundle());
                        ++n2;
                    }
                }
                if ((objectArray2 = resolverBundle.getImportPackages()).length == 0) {
                    ResolverImpl.log("        (w) no imports");
                } else {
                    n2 = 0;
                    while (n2 < objectArray2.length) {
                        if (((ResolverImport)objectArray2[n2]).isDynamic() && ((ResolverConstraint)objectArray2[n2]).getSelectedSupplier() == null) {
                            ResolverImpl.log("        (w) " + ((ResolverConstraint)objectArray2[n2]).getBundle() + ":" + ((ResolverImport)objectArray2[n2]).getName() + " -> DYNAMIC");
                        } else if (((ResolverImport)objectArray2[n2]).isOptional() && ((ResolverConstraint)objectArray2[n2]).getSelectedSupplier() == null) {
                            ResolverImpl.log("        (w) " + ((ResolverConstraint)objectArray2[n2]).getBundle() + ":" + ((ResolverImport)objectArray2[n2]).getName() + " -> OPTIONAL (could not be wired)");
                        } else if (((ResolverConstraint)objectArray2[n2]).getSelectedSupplier() == null) {
                            ResolverImpl.log("        (w) " + ((ResolverConstraint)objectArray2[n2]).getBundle() + ":" + ((ResolverImport)objectArray2[n2]).getName() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (w) " + ((ResolverConstraint)objectArray2[n2]).getBundle() + ":" + ((ResolverImport)objectArray2[n2]).getName() + " -> " + ((ResolverExport)((ResolverConstraint)objectArray2[n2]).getSelectedSupplier()).getExporter() + ":" + ((ResolverConstraint)objectArray2[n2]).getSelectedSupplier().getName());
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }
}

